/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import org.jline.utils.Log;

public class RegistryInstance<T>
implements Iterable<T>,
Comparator<T> {
    private final Registry<T> registry;
    private final Map<T, T> remaps = new HashMap<T, T>();

    public RegistryInstance(Registry<T> registry) {
        this.registry = registry;
        for (Object t : registry) {
            Log.trace((Object[])new Object[]{"- {}", t});
        }
    }

    public RegistryInstance(DynamicRegistries registries, RegistryKey<? extends Registry<T>> key) {
        this((Registry<T>)registries.func_243612_b(key));
    }

    public void addRemap(T in, T out) {
        this.remaps.put(in, out);
    }

    public T getRemap(T in) {
        return this.remaps.getOrDefault(in, in);
    }

    public Registry<T> getRegistry() {
        return this.registry;
    }

    public Optional<T> get(ResourceLocation name) {
        return this.registry.func_241873_b(name);
    }

    public T get(int id) {
        return (T)this.registry.func_148745_a(id);
    }

    public T get(RegistryKey<T> key) {
        return (T)this.registry.func_243576_d(key);
    }

    public T mustGet(ResourceLocation name) {
        return (T)this.registry.func_82594_a(name);
    }

    public RegistryKey<T> getKey(T t) {
        return this.registry.func_230519_c_(t).orElse(null);
    }

    public ResourceLocation getRegistryName(T t) {
        return this.registry.func_177774_c(t);
    }

    public int getId(T t) {
        return this.registry.func_148757_b(t);
    }

    public int getId(RegistryKey<T> key) {
        return this.registry.func_148757_b(this.get(key));
    }

    public String getName(T t) {
        return String.valueOf(this.registry.func_177774_c(t));
    }

    public String getName(int id) {
        return String.valueOf(this.registry.func_177774_c(this.get(id)));
    }

    public boolean contains(ResourceLocation name) {
        return this.registry.func_148742_b().contains(name);
    }

    @Override
    public Iterator<T> iterator() {
        return this.registry.iterator();
    }

    @Override
    public int compare(T o1, T o2) {
        ResourceLocation k1 = this.registry.func_177774_c(o1);
        ResourceLocation k2 = this.registry.func_177774_c(o2);
        if (k1 == null || k2 == null) {
            return 0;
        }
        return k1.compareTo(k2);
    }
}

