/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.template.feature;

import com.terraforged.mod.featuremanager.FeatureManager;
import com.terraforged.mod.featuremanager.template.decorator.Decorator;
import com.terraforged.mod.featuremanager.template.decorator.DecoratorConfig;
import com.terraforged.mod.featuremanager.template.feature.Placement;
import com.terraforged.mod.featuremanager.template.feature.TemplateFeatureConfig;
import com.terraforged.mod.featuremanager.template.paste.Paste;
import com.terraforged.mod.featuremanager.template.paste.PasteType;
import com.terraforged.mod.featuremanager.template.template.Dimensions;
import com.terraforged.mod.featuremanager.template.template.Template;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Mirror;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class TemplateFeature
extends Feature<TemplateFeatureConfig> {
    public TemplateFeature(String namespace) {
        super(TemplateFeatureConfig.CODEC);
        this.setRegistryName(namespace, "template");
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, TemplateFeatureConfig config) {
        Mirror mirror = TemplateFeature.nextMirror(rand);
        Rotation rotation = TemplateFeature.nextRotation(rand);
        return TemplateFeature.paste(world, rand, pos, mirror, rotation, config, config.decorator, Template.WORLD_GEN);
    }

    public static Template nextTemplate(List<Template> templates, Random random) {
        return templates.get(random.nextInt(templates.size()));
    }

    public static Mirror nextMirror(Random random) {
        return Mirror.values()[random.nextInt(Mirror.values().length)];
    }

    public static Rotation nextRotation(Random random) {
        return Rotation.values()[random.nextInt(Rotation.values().length)];
    }

    public static <T extends IWorld> boolean paste(ISeedReader world, Random rand, BlockPos pos, Mirror mirror, Rotation rotation, TemplateFeatureConfig config, DecoratorConfig<T> decorator, PasteType pasteType) {
        return TemplateFeature.paste(world, rand, pos, mirror, rotation, config, decorator, pasteType, false);
    }

    public static <T extends IWorld> boolean paste(ISeedReader world, Random rand, BlockPos pos, Mirror mirror, Rotation rotation, TemplateFeatureConfig config, DecoratorConfig<T> decorator, PasteType pasteType, boolean modified) {
        if (config.templates.isEmpty()) {
            FeatureManager.LOG.warn("Empty template list for config: {}", (Object)config.name);
            return false;
        }
        Template template = TemplateFeature.nextTemplate(config.templates, rand);
        Dimensions dimensions = template.getDimensions(mirror, rotation);
        if (!config.type.getPlacement().canPlaceAt((IWorld)world, pos, dimensions)) {
            return false;
        }
        Paste paste = pasteType.get(template);
        Placement placement = config.type.getPlacement();
        T buffer = decorator.createBuffer(world);
        if (paste.apply((IWorld)buffer, pos, mirror, rotation, placement, config.paste)) {
            ResourceLocation biome = world.func_242406_i(pos).map(RegistryKey::getRegistryName).orElse(null);
            for (Decorator<T> d : decorator.getDecorators(biome)) {
                d.apply(buffer, rand, modified);
            }
            return true;
        }
        return false;
    }
}

