/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.template;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.structure.Structure;

public class StructureUtils {
    public static final List<Structure<?>> SURFACE_STRUCTURES = Structure.field_236365_a_.values().stream().filter(structure -> structure.func_236396_f_() == GenerationStage.Decoration.SURFACE_STRUCTURES).collect(Collectors.toList());

    public static boolean hasOvergroundStructure(IChunk chunk) {
        Map references = chunk.func_201604_d();
        for (Structure<?> structure : SURFACE_STRUCTURES) {
            LongSet refs = (LongSet)references.get(structure);
            if (refs == null || refs.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasStructure(IChunk chunk, Structure<?> structure) {
        LongSet refs = (LongSet)chunk.func_201604_d().get(structure);
        return refs != null && refs.size() > 0;
    }
}

