/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.biome;

import com.google.common.base.Suppliers;
import com.terraforged.mod.featuremanager.biome.BiomeFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeFeatures {
    public static final BiomeFeatures NONE = new BiomeFeatures();
    private static final List<List<BiomeFeature>> NO_FEATURES = Stream.of(GenerationStage.Decoration.values()).map(stage -> Collections.emptyList()).collect(Collectors.toList());
    private static final List<List<Structure<?>>> NO_STRUCTURES = Stream.of(GenerationStage.Decoration.values()).map(stage -> Collections.emptyList()).collect(Collectors.toList());
    private static final Supplier<List<List<Structure<?>>>> STRUCTURES = Suppliers.memoize(() -> {
        Map<GenerationStage.Decoration, List<Structure>> map = ForgeRegistries.STRUCTURE_FEATURES.getValues().stream().collect(Collectors.groupingBy(Structure::func_236396_f_));
        ArrayList list = new ArrayList();
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            list.add(map.getOrDefault(stage, Collections.emptyList()));
        }
        return Collections.unmodifiableList(list);
    });
    private final List<List<BiomeFeature>> features;
    private final List<List<Structure<?>>> structures;

    private BiomeFeatures() {
        this.features = NO_FEATURES;
        this.structures = NO_STRUCTURES;
    }

    public BiomeFeatures(Builder builder) {
        this.features = builder.compileFeatures();
        this.structures = STRUCTURES.get();
    }

    public List<List<BiomeFeature>> getFeatures() {
        return this.features;
    }

    public List<List<Structure<?>>> getStructures() {
        return this.structures;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int size;
        private Map<GenerationStage.Decoration, List<BiomeFeature>> features = Collections.emptyMap();

        public Builder add(GenerationStage.Decoration stage, Collection<BiomeFeature> features) {
            for (BiomeFeature feature : features) {
                this.add(stage, feature);
            }
            return this;
        }

        public Builder add(GenerationStage.Decoration stage, BiomeFeature feature) {
            if (this.features.isEmpty()) {
                this.features = new EnumMap<GenerationStage.Decoration, List<BiomeFeature>>(GenerationStage.Decoration.class);
            }
            this.features.computeIfAbsent(stage, s -> new ArrayList()).add(feature);
            ++this.size;
            return this;
        }

        private List<List<BiomeFeature>> compileFeatures() {
            ArrayList<List<BiomeFeature>> list = new ArrayList<List<BiomeFeature>>(this.size);
            for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
                list.add(this.features.getOrDefault(stage, Collections.emptyList()));
            }
            return list;
        }

        public BiomeFeatures build() {
            return new BiomeFeatures(this);
        }
    }
}

