/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import com.terraforged.mod.featuremanager.util.codec.CodecException;
import com.terraforged.mod.featuremanager.util.codec.Codecs;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class FeatureSerializer {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Serializer");

    public static JsonElement serialize(ConfiguredFeature<?, ?> feature) {
        Optional<JsonElement> registered = Codecs.encodeOpt(ConfiguredFeature.field_242763_a, feature);
        if (registered.isPresent()) {
            return registered.get();
        }
        Optional<JsonElement> unregistered = FeatureSerializer.serializeUnregistered(feature);
        if (unregistered.isPresent()) {
            return unregistered.get();
        }
        ResourceLocation name = WorldGenRegistries.field_243653_e.func_177774_c(feature);
        if (name != null) {
            return new JsonPrimitive(name.toString());
        }
        return JsonNull.INSTANCE;
    }

    private static Optional<JsonElement> serializeUnregistered(ConfiguredFeature feature) {
        try {
            return Codecs.encodeOpt(feature.field_222737_a.func_236292_a_(), feature);
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    public static ConfiguredFeature<?, ?> deserializeUnchecked(JsonElement element) {
        Optional feature;
        if (element.isJsonPrimitive()) {
            String string = element.getAsString();
            ResourceLocation name = ResourceLocation.func_208304_a((String)string);
            if (name == null) {
                throw CodecException.of("Failed to deserialize feature. Invalid registry name: {}", element);
            }
            feature = WorldGenRegistries.field_243653_e.func_241873_b(name);
        } else {
            feature = Codecs.decode(ConfiguredFeature.field_242763_a, element);
        }
        return (ConfiguredFeature)feature.orElseThrow(CodecException.get("Failed to deserialize feature Json: {}", element));
    }

    public static Optional<ConfiguredFeature<?, ?>> deserialize(JsonElement element) {
        try {
            return Optional.of(FeatureSerializer.deserializeUnchecked(element));
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    public static <T> T encode(ConfiguredFeature<?, ?> feature, DynamicOps<T> ops) {
        return Codecs.encodeAndGet(ConfiguredFeature.field_242763_a, feature, ops);
    }

    public static <T> Optional<ConfiguredFeature<?, ?>> decode(OptionalDynamic<T> dynamic) {
        return dynamic.get().result().flatMap(FeatureSerializer::decode);
    }

    public static <T> Optional<ConfiguredFeature<?, ?>> decode(Dynamic<T> dynamic) {
        return Codecs.decode(ConfiguredFeature.field_242763_a, dynamic.getValue(), dynamic.getOps());
    }
}

