/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager;

import com.terraforged.mod.featuremanager.FeatureManager;
import com.terraforged.mod.featuremanager.biome.BiomeFeature;
import com.terraforged.mod.featuremanager.biome.BiomeFeatures;
import java.util.List;
import java.util.Random;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;

public interface FeatureDecorator {
    public static final int FEATURE_STAGES = GenerationStage.Decoration.values().length;

    public FeatureManager getFeatureManager();

    default public void decorate(ChunkGenerator generator, StructureManager manager, ISeedReader region, IChunk chunk, Biome biome, BlockPos pos) {
        SharedSeedRandom random = new SharedSeedRandom();
        long decorationSeed = random.func_202424_a(region.func_72905_C(), pos.func_177958_n(), pos.func_177952_p());
        BiomeFeatures biomeFeatures = this.getFeatureManager().getFeatures(biome);
        List<List<BiomeFeature>> stagedFeatures = biomeFeatures.getFeatures();
        List<List<Structure<?>>> stagedStructures = biomeFeatures.getStructures();
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        int startX = chunkPos.func_180334_c();
        int startZ = chunkPos.func_180333_d();
        MutableBoundingBox chunkBounds = new MutableBoundingBox(startX, startZ, startX + 15, startZ + 15);
        for (int stageIndex = 0; stageIndex < FEATURE_STAGES; ++stageIndex) {
            int featureSeed = 0;
            if (stageIndex < stagedStructures.size()) {
                List<Structure<?>> structures = stagedStructures.get(stageIndex);
                for (int structureIndex = 0; structureIndex < structures.size(); ++structureIndex) {
                    Structure<?> structure = structures.get(structureIndex);
                    random.func_202426_b(decorationSeed, featureSeed++, stageIndex);
                    try {
                        manager.func_235011_a_(SectionPos.func_218167_a((BlockPos)pos), structure).forEach(start -> start.func_230366_a_(region, manager, generator, (Random)random, chunkBounds, chunkPos));
                        continue;
                    }
                    catch (Throwable t) {
                        FeatureDecorator.handle("structure", structure.func_143025_a(), t);
                    }
                }
            }
            if (stageIndex >= stagedFeatures.size()) continue;
            List<BiomeFeature> features = stagedFeatures.get(stageIndex);
            for (int featureIndex = 0; featureIndex < features.size(); ++featureIndex) {
                BiomeFeature feature = features.get(featureIndex);
                random.func_202426_b(decorationSeed, featureSeed++, stageIndex);
                if (!feature.getPredicate().test(chunk, biome)) continue;
                try {
                    feature.getFeature().func_242765_a(region, generator, (Random)random, pos);
                    continue;
                }
                catch (Throwable t) {
                    FeatureDecorator.handle("feature", feature.getIdentity().getComponents(), t);
                }
            }
        }
    }

    public static void handle(String type, String identity, Throwable t) {
        FeatureManager.LOG.fatal("Fatal error placing {} '{}'", (Object)type, (Object)identity);
        t.printStackTrace();
    }
}

