/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature;

import com.google.common.collect.ImmutableMap;
import com.terraforged.mod.feature.BlockDataConfig;
import com.terraforged.mod.feature.sapling.SaplingConfig;
import com.terraforged.mod.featuremanager.data.DataManager;
import com.terraforged.mod.featuremanager.util.Json;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;

public class BlockDataManager {
    private static final Map<String, BlockDataConfig.Parser> parsers = ImmutableMap.builder().put((Object)"terraforged:sapling", SaplingConfig::deserialize).build();
    private final Map<Block, BlockDataConfig> blockdata = new HashMap<Block, BlockDataConfig>();

    public BlockDataManager(DataManager dataManager) {
        dataManager.forEachJson("blocks/saplings", (name, data) -> {
            String type = Json.getString("type", data.getAsJsonObject(), "");
            BlockDataConfig.Parser parser = parsers.get(type);
            if (parser == null) {
                return;
            }
            parser.parse(data.getAsJsonObject()).ifPresent(config -> this.blockdata.put(config.getTarget(), (BlockDataConfig)config));
        });
    }

    public <T extends BlockDataConfig> Optional<T> getConfig(Block block, Class<T> type) {
        return Optional.ofNullable(this.blockdata.get(block)).filter(type::isInstance).map(type::cast);
    }
}

