/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data.gen.feature;

import com.google.gson.JsonPrimitive;
import com.terraforged.mod.data.gen.FeatureInjectorProvider;
import com.terraforged.mod.feature.feature.BushFeature;
import com.terraforged.mod.featuremanager.FeatureSerializer;
import com.terraforged.mod.featuremanager.matcher.biome.BiomeMatcher;
import com.terraforged.mod.featuremanager.matcher.feature.FeatureMatcher;
import com.terraforged.mod.featuremanager.transformer.FeatureAppender;
import com.terraforged.mod.featuremanager.transformer.FeatureInjector;
import com.terraforged.mod.featuremanager.transformer.FeatureTransformer;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.ConfiguredRandomFeatureList;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpreadConfig;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;

public class Shrubs {
    private static final String[] BIRCH = new String[]{"minecraft:birch*", "minecraft:tall_birch*"};
    private static final String[] FOREST = new String[]{"minecraft:forest", "minecraft:forest_hills", "minecraft:dark_forest", "minecraft:dark_forest_hills"};
    private static final String[] MARSH = new String[]{"terraforged:marshland", "terraforged:cold_marshland"};
    private static final String[] PLAINS = new String[]{"minecraft:birch*", "minecraft:plains", "minecraft:sunflower_plains", "minecraft:mountains"};
    private static final String[] STEPPE = new String[]{"minecraft:savanna", "minecraft:shattered_savanna", "terraforged:steppe"};
    private static final String[] COLD_STEPPE = new String[]{"terraforged:cold_steppe", "terraforged:cold_marshland"};
    private static final String[] TAIGA = new String[]{"minecraft:snowy_tundra", "minecraft:taiga", "minecraft:taiga_hills", "minecraft:wooded_mountains", "minecraft:taiga_mountains", "minecraft:snowy_taiga_mountains", "minecraft:gravelly_mountains", "minecraft:modified_gravelly_mountains", "terraforged:taiga_scrub", "terraforged:snowy_taiga_scrub"};

    public static void addInjectors(FeatureInjectorProvider provider) {
        Shrubs.addLargeBush(provider, "shrubs/birch_forest_bush", BIRCH, Blocks.field_196619_M, Blocks.field_196647_Y, 0, 0.05f, 1);
        Shrubs.addLargeBush(provider, "shrubs/forest_bush", FOREST, Blocks.field_196619_M, Blocks.field_196647_Y, 1, 0.05f, 1);
        Shrubs.addSmallBush(provider, "shrubs/marsh_bush", MARSH, Blocks.field_196617_K, Blocks.field_196647_Y, 0.05f, 0.09f, 0.65f, 0, 0.3f, 1);
        Shrubs.addSmallBush(provider, "shrubs/plains_bush", PLAINS, Blocks.field_196617_K, Blocks.field_196647_Y, 0.05f, 0.09f, 0.65f, 0, 0.05f, 1);
        Shrubs.addSmallBush(provider, "shrubs/steppe_bush", STEPPE, Blocks.field_196621_O, Blocks.field_196572_aa, 0.06f, 0.08f, 0.7f, 0, 0.125f, 1);
        Shrubs.addSmallBush(provider, "shrubs/cold_steppe_bush", COLD_STEPPE, Blocks.field_196618_L, Blocks.field_196642_W, 0.05f, 0.075f, 0.6f, 0, 0.125f, 1);
        Shrubs.addSmallBush(provider, "shrubs/taiga_scrub_bush", TAIGA, Blocks.field_196618_L, Blocks.field_196645_X, 0.05f, 0.075f, 0.6f, 0, 0.1f, 1);
        Shrubs.addBirchGrass(provider, "shrubs/birch_forest_grass");
        Shrubs.addForestGrass(provider, "shrubs/forest_grass");
    }

    private static void addLargeBush(FeatureInjectorProvider provider, String path, String[] biomes, Block log, Block leaves, int count, float chance, int extra) {
        provider.add(path, BiomeMatcher.of(provider.getContext(), biomes), FeatureMatcher.and(log, leaves), FeatureInjector.after(Shrubs.transform(Shrubs.bush(count, chance, extra), FeatureTransformer.builder().value(Shrubs.wrap(Blocks.field_196648_Z), Shrubs.wrap(leaves)).value(Shrubs.wrap(Blocks.field_196620_N), Shrubs.wrap(log)).build())));
    }

    private static void addSmallBush(FeatureInjectorProvider provider, String path, String[] biomes, Block log, Block leaves, float air, float leaf, float size, int count, float chance, int extra) {
        provider.add(path, BiomeMatcher.of(provider.getContext(), biomes), FeatureMatcher.ANY, FeatureAppender.head(GenerationStage.Decoration.VEGETAL_DECORATION, BushFeature.INSTANCE.func_225566_b_(new BushFeature.Config(log.func_176223_P(), leaves.func_176223_P(), air, leaf, size)).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(count, chance, extra)))));
    }

    private static void addBirchGrass(FeatureInjectorProvider provider, String path) {
        provider.add(path, BiomeMatcher.of(provider.getContext(), BIRCH), FeatureMatcher.ANY, FeatureAppender.head(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig(Arrays.asList(Shrubs.patch(Shrubs.doubleBuilder(Blocks.field_196804_gh).func_227315_a_(56).func_227317_b_(), 0.8f), Shrubs.patch(Shrubs.doubleBuilder(Blocks.field_196801_ge).func_227315_a_(64).func_227317_b_(), 0.5f), Shrubs.patch(Shrubs.doubleBuilder(Blocks.field_196805_gi).func_227315_a_(48).func_227317_b_(), 0.3f), Shrubs.patch(Shrubs.singleBuilder(Blocks.field_196554_aH).func_227315_a_(24).func_227317_b_(), 0.2f), Shrubs.patch(Shrubs.doubleBuilder(Blocks.field_196803_gg).func_227315_a_(32).func_227317_b_(), 0.1f)), Feature.field_227248_z_.func_225566_b_((IFeatureConfig)Shrubs.doubleBuilder(Blocks.field_196804_gh).func_227315_a_(48).func_227317_b_().func_227322_d_()))).func_227228_a_(Shrubs.vegetationPlacement(7))));
    }

    private static void addForestGrass(FeatureInjectorProvider provider, String path) {
        provider.add(path, BiomeMatcher.of(provider.getContext(), FOREST), FeatureMatcher.ANY, FeatureAppender.head(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig(Arrays.asList(Shrubs.patch(Shrubs.singleBuilder(Blocks.field_150349_c).func_227315_a_(56).func_227317_b_(), 0.5f), Shrubs.patch(Shrubs.doubleBuilder(Blocks.field_196804_gh).func_227315_a_(56).func_227317_b_(), 0.4f), Shrubs.patch(Shrubs.doubleBuilder(Blocks.field_196805_gi).func_227315_a_(48).func_227317_b_(), 0.2f), Shrubs.patch(Shrubs.singleBuilder(Blocks.field_196554_aH).func_227315_a_(24).func_227317_b_(), 0.2f)), Feature.field_227248_z_.func_225566_b_((IFeatureConfig)Shrubs.singleBuilder(Blocks.field_150349_c).func_227315_a_(48).func_227317_b_().func_227322_d_()))).func_227228_a_(Shrubs.vegetationPlacement(7))));
    }

    private static ConfiguredPlacement<?> vegetationPlacement(int count) {
        return Placement.field_242906_k.func_227446_a_((IPlacementConfig)NoPlacementConfig.field_236556_b_).func_227228_a_(Placement.field_242899_c.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(count)));
    }

    private static ConfiguredRandomFeatureList patch(BlockClusterFeatureConfig.Builder cluster, float chance) {
        return Feature.field_227248_z_.func_225566_b_((IFeatureConfig)cluster.func_227322_d_()).func_227227_a_(chance);
    }

    private static BlockClusterFeatureConfig.Builder singleBuilder(Block block) {
        return new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(block.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer());
    }

    private static BlockClusterFeatureConfig.Builder doubleBuilder(Block block) {
        return new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(block.func_176223_P()), (BlockPlacer)new DoublePlantBlockPlacer());
    }

    private static JsonPrimitive wrap(Block block) {
        return new JsonPrimitive(block.getRegistryName().toString());
    }

    private static ConfiguredFeature<?, ?> bush(int count, float chance, int extra) {
        return Shrubs.bush(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(count, chance, extra)));
    }

    private static ConfiguredFeature<?, ?> bush(ConfiguredPlacement<?> placement) {
        return Features.field_243876_bV.func_227228_a_(placement);
    }

    private static ConfiguredFeature<?, ?> transform(ConfiguredFeature<?, ?> feature, FeatureTransformer transformer) {
        return FeatureSerializer.deserializeUnchecked(transformer.apply(FeatureSerializer.serialize(feature)));
    }
}

