/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.config;

import com.terraforged.engine.concurrent.thread.ThreadPools;
import com.terraforged.engine.settings.FilterSettings;
import com.terraforged.mod.Log;

public class PerfDefaults {
    public static final int TILE_SIZE = 3;
    public static final int BATCH_COUNT = 5;
    public static final int THREAD_COUNT = ThreadPools.defaultPoolSize();

    public static int getTileBorderSize(FilterSettings settings) {
        return Math.min(2, Math.max(1, settings.erosion.dropletLifetime / 16));
    }

    public static void print() {
        Log.info("System Defaults:", new Object[0]);
        Log.info(" Thread Count:  {}", THREAD_COUNT);
        Log.info(" Tile Size:     {}", 3);
        Log.info(" Batch Size:    {}", 5);
    }
}

