/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.element;

import com.terraforged.mod.client.gui.element.Element;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TFButton
extends Button
implements Element {
    private final List<String> tooltip;

    public TFButton(String displayString) {
        super(0, 0, 200, 20, (ITextComponent)new StringTextComponent(displayString), b -> {});
        this.tooltip = Collections.emptyList();
    }

    public TFButton(String displayString, String ... tooltip) {
        super(0, 0, 200, 20, (ITextComponent)new StringTextComponent(displayString), b -> {});
        this.tooltip = Arrays.asList(tooltip);
    }

    public TFButton init(int x, int y, int width, int height) {
        this.field_230690_l_ = x;
        this.field_230691_m_ = y;
        this.func_230991_b_(width);
        this.setHeight(height);
        return this;
    }

    @Override
    public List<String> getTooltip() {
        return this.tooltip;
    }

    public static TFButton create(String title, int x, int y, int width, int height, final String tooltip, final Runnable action) {
        TFButton button = new TFButton(title){
            private final List<String> tooltips;
            {
                super(displayString);
                this.tooltips = Collections.singletonList(tooltip);
            }

            @Override
            public List<String> getTooltip() {
                return this.tooltips;
            }

            public void func_230982_a_(double mouseX, double mouseY) {
                super.func_230982_a_(mouseX, mouseY);
                action.run();
            }
        };
        button.field_230690_l_ = x;
        button.field_230691_m_ = y;
        button.func_230991_b_(width);
        button.setHeight(height);
        return button;
    }
}

