/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.element;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class DependencyBinding {
    public static final DependencyBinding NONE = new DependencyBinding();
    private final CompoundNBT value;
    private final String dependency;
    private final Set<String> allowedValues;

    private DependencyBinding() {
        this.value = null;
        this.dependency = null;
        this.allowedValues = null;
    }

    public DependencyBinding(CompoundNBT value, String dependency, ListNBT allowedValues) {
        this.value = value;
        this.dependency = dependency;
        this.allowedValues = new HashSet<String>();
        for (INBT option : allowedValues) {
            this.allowedValues.add(option.toString());
        }
    }

    public boolean isValid() {
        if (this.allowedValues == null) {
            return true;
        }
        INBT dependencyValue = this.value.func_74781_a(this.dependency);
        if (dependencyValue == null) {
            return false;
        }
        return this.allowedValues.contains(dependencyValue.toString());
    }

    public static DependencyBinding of(String name, CompoundNBT value) {
        String key = '#' + name;
        CompoundNBT meta = value.func_74775_l(key);
        if (!meta.func_74764_b("restricted")) {
            return NONE;
        }
        CompoundNBT restriction = meta.func_74775_l("restricted");
        String dependency = restriction.func_74779_i("name");
        ListNBT allowedValues = restriction.func_150295_c("options", 8);
        if (allowedValues.size() == 0) {
            return NONE;
        }
        return new DependencyBinding(value, dependency, allowedValues);
    }
}

