/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.settings;

import com.google.gson.JsonObject;
import com.terraforged.engine.serialization.annotation.Comment;
import com.terraforged.engine.serialization.annotation.Hide;
import com.terraforged.engine.serialization.annotation.Limit;
import com.terraforged.engine.serialization.annotation.Name;
import com.terraforged.engine.serialization.annotation.NoName;
import com.terraforged.engine.serialization.annotation.Rand;
import com.terraforged.engine.serialization.annotation.Range;
import com.terraforged.engine.serialization.annotation.Serializable;
import com.terraforged.engine.serialization.annotation.Sorted;
import com.terraforged.mod.Log;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.biome.provider.analyser.BiomeAnalyser;
import com.terraforged.mod.featuremanager.util.codec.Codecs;
import com.terraforged.mod.util.DataUtils;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.gen.settings.StructureSpreadSettings;

@Serializable
public class StructureSettings {
    public StructureSpread stronghold = new StructureSpread();
    @NoName
    @Sorted
    public Map<String, StructureSeparation> structures = new LinkedHashMap<String, StructureSeparation>();

    public DimensionStructuresSettings apply(Supplier<DimensionSettings> settings) {
        this.init(settings);
        return Codecs.modify(settings.get().func_236108_a_(), DimensionStructuresSettings.field_236190_a_, data -> {
            JsonObject structures = DataUtils.getOrAddObject(data.getAsJsonObject(), "structures");
            JsonObject stronghold = DataUtils.getOrAddObject(data.getAsJsonObject(), "stronghold");
            for (Map.Entry<String, StructureSeparation> entry : this.structures.entrySet()) {
                if (entry.getValue().disabled) {
                    structures.remove(entry.getKey());
                    continue;
                }
                structures.add(entry.getKey(), DataUtils.toJson(entry.getValue()));
            }
            stronghold.addProperty("salt", (Number)this.stronghold.salt);
            stronghold.addProperty("count", (Number)this.stronghold.count);
            stronghold.addProperty("spread", (Number)this.stronghold.spread);
            stronghold.addProperty("distance", (Number)this.stronghold.distance);
            return data;
        });
    }

    public StructureSettings init(Supplier<DimensionSettings> settings) {
        this.addSettings(settings.get().func_236108_a_());
        this.addDefaults();
        return this;
    }

    public StructureSettings addSettings(DimensionStructuresSettings structuresSettings) {
        this.initStronghold(structuresSettings.func_236199_b_());
        this.initStructures(structuresSettings.func_236195_a_());
        return this;
    }

    public StructureSettings addDefaults() {
        DimensionSettings settings = (DimensionSettings)WorldGenRegistries.field_243658_j.func_243576_d(DimensionSettings.field_242734_c);
        DimensionStructuresSettings structuresSettings = settings.func_236108_a_();
        return this.addSettings(structuresSettings);
    }

    public void hideNonOverworld(TFBiomeContext context) {
        Predicate<String> predicate = StructureSettings.getOverworldStructurePredicate(context);
        for (Map.Entry<String, StructureSeparation> entry : this.structures.entrySet()) {
            entry.getValue().hidden = !predicate.test(entry.getKey());
        }
    }

    private void initStronghold(@Nullable StructureSpreadSettings stronghold) {
        if (!this.stronghold.isDefaulted()) {
            return;
        }
        boolean bl = this.stronghold.disabled = stronghold == null;
        if (stronghold == null) {
            return;
        }
        if (!StructureSettings.validateStronghold(stronghold.func_236663_c_(), stronghold.func_236662_b_(), stronghold.func_236660_a_())) {
            Log.warn("Structure [minecraft:stronghold] configured with invalid settings. Ignoring to prevent crashes!", new Object[0]);
            return;
        }
        this.stronghold.count = stronghold.func_236663_c_();
        this.stronghold.spread = stronghold.func_236662_b_();
        this.stronghold.distance = stronghold.func_236660_a_();
    }

    private void initStructures(Map<Structure<?>, StructureSeparationSettings> structures) {
        for (Map.Entry<Structure<?>, StructureSeparationSettings> entry : structures.entrySet()) {
            ResourceLocation registryName = entry.getKey().getRegistryName();
            StructureSeparationSettings settings = entry.getValue();
            if (registryName == null) continue;
            String name = registryName.toString();
            StructureSeparation separation = this.structures.get(name);
            if (separation == null) {
                separation = new StructureSeparation();
                separation.disabled = false;
                separation.salt = settings.func_236673_c_();
                separation.spacing = settings.func_236668_a_();
                separation.separation = settings.func_236671_b_();
            }
            if (!StructureSettings.validateStructure(name, separation.spacing, separation.separation, separation.salt)) {
                Log.warn("Structure [{}] registered with invalid separation settings. Ignoring to prevent crashes!", new Object[0]);
                continue;
            }
            this.structures.putIfAbsent(name, separation);
        }
    }

    private static Predicate<String> getOverworldStructurePredicate(TFBiomeContext context) {
        Biome[] biomes = BiomeAnalyser.getOverworldBiomes(context);
        HashSet set = new HashSet();
        for (Biome biome : biomes) {
            biome.func_242440_e().func_242487_a().forEach(s -> {
                Structure structure = ((StructureFeature)s.get()).field_236268_b_;
                ResourceLocation name = structure.getRegistryName();
                if (name != null) {
                    set.add(name.toString());
                }
            });
        }
        return set::contains;
    }

    private static boolean validateStructure(String name, int spacing, int separation, int salt) {
        if (spacing < separation) {
            Log.err("[{}] structure spacing ({}) cannot be lower than separation ({})", name, spacing, separation);
            return false;
        }
        boolean result = StructureSettings.checkRange(0, 4096, spacing, name, "spacing");
        result &= StructureSettings.checkRange(0, 4096, separation, name, "separation");
        return result &= StructureSettings.checkRange(0, Integer.MAX_VALUE, salt, name, "salt");
    }

    private static boolean validateStronghold(int count, int spread, int distance) {
        boolean result = StructureSettings.checkRange(0, 1023, distance, "minecraft:stronghold", "distance");
        result &= StructureSettings.checkRange(0, 1023, spread, "minecraft:stronghold", "spread");
        return result &= StructureSettings.checkRange(1, 4095, count, "minecraft:stronghold", "count");
    }

    private static boolean checkRange(int min, int max, int value, String name, String variable) {
        if (value >= min && value <= max) {
            return true;
        }
        Log.err("[{}] structure setting: {} = {} is outside of the valid range: {} - {}", name, variable, value, min, max);
        return false;
    }

    @Serializable
    public static class StructureSeparation {
        @Limit(lower="separation", pad=1.0f)
        @Range(min=1.0f, max=1000.0f)
        @Comment(value={"Controls the size of the grid used to generate the structure.", "Structures will attempt to generate once per grid cell. Larger", "spacing values will make the structure appear less frequently."})
        public int spacing = 1;
        @Limit(upper="spacing", pad=1.0f)
        @Range(min=0.0f, max=1000.0f)
        @Comment(value={"Controls the minimum distance between instances of the structure.", "Larger values guarantee larger distances between structures of the", "same type but cause them to generate more 'grid-aligned'.", "Lower values will produce a more random distribution but may allow", "instances to generate closer together."})
        public int separation = 0;
        @Rand
        @Name(value="seed")
        @Range(min=0.0f, max=2.1474836E9f)
        @Comment(value={"A random seed value for the structure."})
        public int salt = 0;
        @Comment(value={"Prevent this structure from generating."})
        public boolean disabled = false;
        @Hide
        public transient boolean hidden = false;
    }

    @Serializable
    public static class StructureSpread {
        private static final int DEF_DISTANCE = 32;
        private static final int DEF_SPREAD = 3;
        private static final int DEF_COUNT = 128;
        private static final int DEF_SALT = 0;
        @Range(min=0.0f, max=1023.0f)
        @Comment(value={"Controls how far from spawn strongholds will start generating"})
        public int distance = 32;
        @Range(min=0.0f, max=1023.0f)
        @Comment(value={"Controls how spread apart strongholds will generate"})
        public int spread = 3;
        @Range(min=1.0f, max=4095.0f)
        @Comment(value={"Controls the number of strongholds that will generate in the world"})
        public int count = 128;
        @Rand
        @Comment(value={"A seed offset used to randomise stronghold placement"})
        public int salt = 0;
        @Comment(value={"Set whether strongholds should only start in valid stronghold biomes. The vanilla behaviour", "(false) tries its best to move them to a valid biome but does not prevent generation if there", "are no valid biomes nearby. Setting to true outright blocks strongholds from starting in invalid", "biomes (note: it doesn't prevent them extending from a valid biome to an invalid one)."})
        public boolean constrainToBiomes = false;
        @Comment(value={"Prevent this structure from generating."})
        public boolean disabled = false;

        public boolean isDefaulted() {
            return !this.disabled && !this.constrainToBiomes && this.distance == 32 && this.spread == 3 && this.count == 128 && this.salt == 0;
        }
    }
}

