/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.provider.analyser;

import com.terraforged.engine.world.biome.map.BiomeCollector;
import com.terraforged.mod.biome.context.TFBiomeContext;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;

public class TFBiomeCollector
implements BiomeCollector<RegistryKey<Biome>> {
    private final TFBiomeContext context;
    private final Set<Biome> biomes = new HashSet<Biome>();

    public TFBiomeCollector(TFBiomeContext context) {
        this.context = context;
    }

    public TFBiomeCollector add(RegistryKey<Biome> key) {
        this.biomes.add(this.context.biomes.get(key));
        return this;
    }

    public Biome[] getBiomes() {
        Biome[] biomes = this.biomes.toArray(new Biome[0]);
        Arrays.sort(biomes, Comparator.comparing(this.context.biomes::getRegistryName));
        return biomes;
    }
}

