/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome;

import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.tile.chunk.ChunkReader;
import com.terraforged.engine.util.pos.PosIterator;
import com.terraforged.mod.biome.ModBiomes;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.biome.provider.TFBiomeProvider;
import com.terraforged.mod.chunk.util.FastChunk;
import com.terraforged.noise.source.Line;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;

public class TFBiomeContainer
extends BiomeContainer {
    private static final int BITS_WIDTH = (int)Math.round(Math.log(16.0) / Math.log(2.0)) - 2;
    private static final int ZOOM_VERT = (int)Math.round(Math.log(256.0) / Math.log(2.0)) - 2;
    public static final int BIOMES_3D_SIZE = 1 << BITS_WIDTH + BITS_WIDTH + ZOOM_VERT;
    public static final int BIOMES_2D_SIZE = 256;
    public static final int MASK_HORIZ = (1 << BITS_WIDTH) - 1;
    public static final int MASK_VERT = (1 << ZOOM_VERT) - 1;
    private final Biome[] biomes;
    private final Biome[] surface;
    private final Biome featureBiome;

    public TFBiomeContainer(Biome[] biomes, Biome[] surface, Biome feature, TFBiomeContext context) {
        super(context.biomes.getRegistry(), biomes);
        this.biomes = biomes;
        this.surface = surface;
        this.featureBiome = feature;
    }

    public Biome getBiome(int x, int z) {
        return this.surface[TFBiomeContainer.indexOf(x &= 0xF, z &= 0xF)];
    }

    public Biome getFeatureBiome() {
        return this.featureBiome;
    }

    public BiomeContainer bakeBiomes(boolean convertToVanilla, TFBiomeContext context) {
        if (convertToVanilla) {
            Biome[] biomeArray = new Biome[this.biomes.length];
            for (int i = 0; i < this.biomes.length; ++i) {
                Biome biome = this.biomes[i];
                biomeArray[i] = biome = ModBiomes.remap(biome, context);
            }
            return new BiomeContainer(context.biomes.getRegistry(), biomeArray);
        }
        return new BiomeContainer(context.biomes.getRegistry(), this.biomes);
    }

    public static TFBiomeContainer getOrNull(IChunk chunk) {
        BiomeContainer biomes = chunk.func_225549_i_();
        if (biomes instanceof TFBiomeContainer) {
            return (TFBiomeContainer)biomes;
        }
        return null;
    }

    public static TFBiomeContainer getOrCreate(IChunk chunk, ChunkReader reader, TFBiomeProvider biomeProvider) {
        BiomeContainer biomes = chunk.func_225549_i_();
        if (biomes instanceof TFBiomeContainer) {
            return (TFBiomeContainer)biomes;
        }
        TFBiomeContainer container = TFBiomeContainer.create(reader, biomeProvider);
        if (chunk instanceof FastChunk) {
            ((FastChunk)chunk).setBiomes(container);
        } else {
            ((ChunkPrimer)chunk).func_225548_a_((BiomeContainer)container);
        }
        return container;
    }

    public static TFBiomeContainer create(ChunkReader chunkReader, TFBiomeProvider biomeProvider) {
        Biome feature = null;
        float featureDist2 = 2.1474836E9f;
        Biome[] biomes2D = new Biome[256];
        Biome[] biomes3D = new Biome[BIOMES_3D_SIZE];
        PosIterator iterator = PosIterator.area(0, 0, 16, 16);
        while (iterator.next()) {
            Biome biome;
            int dx = iterator.x();
            int dz = iterator.z();
            int x = chunkReader.getBlockX() + dx;
            int z = chunkReader.getBlockZ() + dz;
            Cell cell = chunkReader.getCell(dx, dz);
            biomes2D[TFBiomeContainer.indexOf((int)dx, (int)dz)] = biome = biomeProvider.readBiome(cell, x, z);
            if (cell.biome.isExtreme()) {
                float dist2 = Line.dist2(dx, dz, 8.0f, 8.0f);
                if (feature == null || dist2 < featureDist2) {
                    featureDist2 = dist2;
                    feature = biome;
                }
            }
            if ((dx & 3) != 0 || (dz & 3) != 0) continue;
            for (int dy = 0; dy < 64; ++dy) {
                biomes3D[TFBiomeContainer.indexOf((int)(dx >> 2), (int)dy, (int)(dz >> 2))] = biome;
            }
        }
        if (feature == null) {
            feature = biomes2D[TFBiomeContainer.indexOf(8, 8)];
        }
        return new TFBiomeContainer(biomes3D, biomes2D, feature, biomeProvider.getContext().biomeContext);
    }

    private static int indexOf(int x, int z) {
        return (z << 4) + x;
    }

    public static int indexOf(int x, int y, int z) {
        y = MathHelper.func_76125_a((int)y, (int)0, (int)MASK_VERT);
        return y << BITS_WIDTH + BITS_WIDTH | (z &= MASK_HORIZ) << BITS_WIDTH | (x &= MASK_HORIZ);
    }
}

