/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.api.material.state;

import com.terraforged.mod.api.material.state.StateSupplier;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;

public class CachedState
extends StateSupplier {
    private static final List<CachedState> all = new CopyOnWriteArrayList<CachedState>();
    private final Supplier<BlockState> supplier;
    private final AtomicReference<BlockState> reference = new AtomicReference();

    public CachedState(Supplier<BlockState> supplier) {
        this.supplier = supplier;
        all.add(this);
    }

    @Override
    public BlockState get() {
        BlockState state = this.reference.get();
        if (state == null) {
            state = this.supplier.get();
            this.reference.set(state);
        }
        return state;
    }

    public CachedState clear() {
        this.reference.set(null);
        return this;
    }

    public static void clearAll() {
        all.forEach(CachedState::clear);
    }
}

