/*
 * Decompiled with CFR 0.152.
 */
package xyz.starmun.actuallycompatible.mixin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.FMLStatusPing;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.starmun.actuallycompatible.config.ActuallyCompatibleConfig;
import xyz.starmun.actuallycompatible.contracts.IFMLStatPingExtensions;

@Mixin(value={FMLStatusPing.class}, remap=false)
public class FMLStatusPingMixin
implements IFMLStatPingExtensions {
    private static final int CHANNEL_TRUNCATE_LIMIT = Integer.MAX_VALUE;
    private static final int MOD_TRUNCATE_LIMIT = Integer.MAX_VALUE;
    @Shadow
    private transient Map<ResourceLocation, Pair<String, Boolean>> channels;
    @Shadow
    private transient Map<String, String> mods;
    @Shadow
    private static volatile boolean warnedAboutTruncation;
    @Shadow
    private transient int fmlNetworkVer;

    @Override
    public Map<ResourceLocation, Pair<String, Boolean>> getChannels() {
        return this.channels;
    }

    @Override
    public Map<String, String> getMods() {
        return this.mods;
    }

    @Override
    public int getFMLNetworkVer() {
        return this.fmlNetworkVer;
    }

    @Mixin(value={FMLStatusPing.Serializer.class}, remap=false)
    public static class SerializerMixin {
        @Inject(method={"serialize"}, at={@At(value="HEAD")}, cancellable=true)
        private static void serialize(FMLStatusPing forgeData, JsonSerializationContext ctx, CallbackInfoReturnable<JsonObject> cir) {
            JsonObject obj = new JsonObject();
            JsonArray channels = new JsonArray();
            ((IFMLStatPingExtensions)forgeData).getChannels().entrySet().stream().limit(Integer.MAX_VALUE).forEach(entry -> {
                ResourceLocation namespace = (ResourceLocation)entry.getKey();
                Pair version = (Pair)entry.getValue();
                JsonObject mi = new JsonObject();
                mi.addProperty("res", namespace.toString());
                mi.addProperty("version", (String)version.getLeft());
                mi.addProperty("required", (Boolean)version.getRight());
                channels.add((JsonElement)mi);
            });
            obj.add("channels", (JsonElement)channels);
            JsonArray modTestValues = new JsonArray();
            ((IFMLStatPingExtensions)forgeData).getMods().entrySet().stream().filter(entry -> !((List)ActuallyCompatibleConfig.serverIgnoredMods.get()).contains(entry.getKey())).limit(Integer.MAX_VALUE).forEach(entry -> {
                String modId = (String)entry.getKey();
                String value = (String)entry.getValue();
                JsonObject mi = new JsonObject();
                mi.addProperty("modId", modId);
                mi.addProperty("modmarker", value);
                modTestValues.add((JsonElement)mi);
            });
            obj.add("mods", (JsonElement)modTestValues);
            obj.addProperty("fmlNetworkVersion", (Number)((IFMLStatPingExtensions)forgeData).getFMLNetworkVer());
            obj.addProperty("truncated", Boolean.valueOf(false));
            cir.setReturnValue((Object)obj);
        }
    }
}

