/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.tile_entities;

import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.entities.CampfireCartEntity;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class LockingRailTile
extends TileEntity
implements ITickableTileEntity {
    public static String LOCKED_CART_PROPERTY = "locked_cart";
    public static String SAVED_FUEL_PROPERTY = "saved_fuel";
    public static String SAVED_PUSH_X_PROPERTY = "saved_push_x";
    public static String SAVED_PUSH_Z_PROPERTY = "saved_push_z";
    private final int FURNACE_CART_MAX_FUEL = 32000;
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    public int saved_fuel;
    public double saved_push_x;
    public double saved_push_z;
    public UUID locked_minecart_uuid;
    @Nullable
    public AbstractMinecartEntity locked_minecart = null;

    public LockingRailTile() {
        super(MMReferences.locking_rail_te);
    }

    public LockingRailTile(boolean is_powered) {
        super(is_powered ? MMReferences.powered_locking_rail_te : MMReferences.locking_rail_te);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.locked_minecart != null) {
            compound.func_186854_a(LOCKED_CART_PROPERTY, this.locked_minecart.func_110124_au());
        }
        compound.func_74768_a(SAVED_FUEL_PROPERTY, this.saved_fuel);
        compound.func_74780_a(SAVED_PUSH_X_PROPERTY, this.saved_push_x);
        compound.func_74780_a(SAVED_PUSH_Z_PROPERTY, this.saved_push_z);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        try {
            this.locked_minecart_uuid = compound.func_186857_a(LOCKED_CART_PROPERTY);
            this.saved_fuel = compound.func_74762_e(SAVED_FUEL_PROPERTY);
            this.saved_push_x = compound.func_74762_e(SAVED_PUSH_X_PROPERTY);
            this.saved_push_z = compound.func_74762_e(SAVED_PUSH_Z_PROPERTY);
        }
        catch (NullPointerException e) {
            this.locked_minecart = null;
            this.saved_fuel = 0;
            this.saved_push_x = 0.0;
            this.saved_push_z = 0.0;
        }
        super.func_230337_a_(state, compound);
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            this.lockOut();
        }
        super.func_145843_s();
    }

    protected void lockIn(AbstractMinecartEntity cart) {
        if (this.locked_minecart == cart) {
            return;
        }
        this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_232695_bC_, SoundCategory.BLOCKS, 0.5f, 1.0f, false);
        this.locked_minecart = cart;
        this.locked_minecart.func_70107_b((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5);
        this.locked_minecart.func_213293_j(0.0, 0.0, 0.0);
        if (this.locked_minecart instanceof FurnaceMinecartEntity) {
            this.saved_fuel = ((FurnaceMinecartEntity)this.locked_minecart).field_94110_c;
            ((FurnaceMinecartEntity)this.locked_minecart).field_94110_c = 0;
            this.saved_push_x = ((FurnaceMinecartEntity)this.locked_minecart).field_94111_a;
            this.saved_push_z = ((FurnaceMinecartEntity)this.locked_minecart).field_94109_b;
        }
        if (this.locked_minecart instanceof CampfireCartEntity) {
            this.saved_fuel = ((CampfireCartEntity)this.locked_minecart).isMinecartPowered() ? 1 : 0;
            ((CampfireCartEntity)this.locked_minecart).setMinecartPowered(false);
            this.saved_push_x = ((CampfireCartEntity)this.locked_minecart).pushX;
            this.saved_push_z = ((CampfireCartEntity)this.locked_minecart).pushZ;
        }
    }

    protected void lockOut() {
        if (this.locked_minecart == null) {
            return;
        }
        this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_232697_bz_, SoundCategory.BLOCKS, 0.0f, 0.5f, false);
        if (this.locked_minecart instanceof FurnaceMinecartEntity) {
            FurnaceMinecartEntity furnace_minecart = (FurnaceMinecartEntity)this.locked_minecart;
            int fuel = furnace_minecart.field_94110_c;
            if ((fuel += this.saved_fuel) > 32000) {
                fuel = 32000;
            }
            furnace_minecart.field_94110_c = fuel;
            furnace_minecart.field_94111_a = this.saved_push_x;
            furnace_minecart.field_94109_b = this.saved_push_z;
        }
        if (this.locked_minecart instanceof CampfireCartEntity) {
            ((CampfireCartEntity)this.locked_minecart).setMinecartPowered(this.saved_fuel >= 1);
            ((CampfireCartEntity)this.locked_minecart).pushX = this.saved_push_x;
            ((CampfireCartEntity)this.locked_minecart).pushZ = this.saved_push_z;
        }
        this.locked_minecart = null;
    }

    public boolean updateLock(boolean locked) {
        List<AbstractMinecartEntity> list;
        if (!(this.locked_minecart == null || locked && this.locked_minecart.func_70089_S())) {
            this.lockOut();
            return true;
        }
        if (locked && this.locked_minecart == null && (list = this.findMinecarts(this.field_145850_b, this.func_174877_v(), AbstractMinecartEntity.class, cart -> true)).size() > 0) {
            this.lockIn(list.get(0));
            return true;
        }
        return false;
    }

    protected <T extends AbstractMinecartEntity> List<T> findMinecarts(World worldIn, BlockPos pos, Class<T> cartType, @Nullable Predicate<Entity> filter) {
        return worldIn.func_175647_a(cartType, this.getDectectionBox(pos), filter);
    }

    private AxisAlignedBB getDectectionBox(BlockPos pos) {
        double d0 = 0.2;
        return new AxisAlignedBB((double)pos.func_177958_n() + 0.2, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.2, (double)(pos.func_177958_n() + 1) - 0.2, (double)(pos.func_177956_o() + 1) - 0.2, (double)(pos.func_177952_p() + 1) - 0.2);
    }

    public int getComparatorSignal() {
        return this.locked_minecart == null ? 0 : 15;
    }

    public void func_73660_a() {
        if (this.locked_minecart_uuid != null && !this.field_145850_b.field_72995_K) {
            Entity locked_entity = ((ServerWorld)this.field_145850_b).func_217461_a(this.locked_minecart_uuid);
            if (locked_entity instanceof AbstractMinecartEntity) {
                this.locked_minecart = (AbstractMinecartEntity)locked_entity;
            } else {
                this.saved_fuel = 0;
                this.saved_push_x = 0.0;
                this.saved_push_z = 0.0;
            }
            this.locked_minecart_uuid = null;
        }
        if (this.locked_minecart != null && !this.field_145850_b.field_72995_K) {
            if (this.locked_minecart.func_70089_S()) {
                this.locked_minecart.func_70107_b((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5);
                this.locked_minecart.func_213293_j(0.0, 0.0, 0.0);
            } else {
                this.locked_minecart = null;
                this.field_145850_b.func_175666_e(this.func_174877_v(), this.func_195044_w().func_177230_c());
            }
        }
    }
}

