/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.proxy;

import com.alc.moreminecarts.MoreMinecartsMod;
import com.alc.moreminecarts.containers.ChunkLoaderContainer;
import com.alc.moreminecarts.containers.FlagCartContainer;
import com.alc.moreminecarts.containers.MinecartUnLoaderContainer;
import com.alc.moreminecarts.entities.CouplerEntity;
import com.alc.moreminecarts.entities.PistonPushcartEntity;
import com.alc.moreminecarts.tile_entities.AbstractCommonLoader;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CUseEntityPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class MoreMinecartsPacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("moreminecarts", "example"), () -> "1", "1"::equals, "1"::equals);

    public static void Init() {
        int id = 0;
        INSTANCE.registerMessage(id++, CouplePacket.class, CouplePacket::encode, CouplePacket::decode, CouplePacket::handle);
        INSTANCE.registerMessage(id++, ChunkLoaderPacket.class, ChunkLoaderPacket::encode, ChunkLoaderPacket::decode, ChunkLoaderPacket::handle);
        INSTANCE.registerMessage(id++, PistonPushcartPacket.class, PistonPushcartPacket::encode, PistonPushcartPacket::decode, PistonPushcartPacket::handle);
        INSTANCE.registerMessage(id++, ExtendedInteractPacket.class, ExtendedInteractPacket::encode, ExtendedInteractPacket::decode, ExtendedInteractPacket::handle);
        INSTANCE.registerMessage(id++, MinecartLoaderPacket.class, MinecartLoaderPacket::encode, MinecartLoaderPacket::decode, MinecartLoaderPacket::handle);
        INSTANCE.registerMessage(id++, FlagCartPacket.class, FlagCartPacket::encode, FlagCartPacket::decode, FlagCartPacket::handle);
    }

    public static void handleInteract(NetworkManager network, CUseEntityPacket p_147340_1_, ServerPlayerEntity player) {
        double d0;
        ServerWorld serverworld = player.func_71121_q();
        Entity entity = p_147340_1_.func_149564_a((World)serverworld);
        player.func_143004_u();
        player.func_226284_e_(p_147340_1_.func_241792_e_());
        if (entity != null && (d0 = player.func_70068_e(entity)) >= 36.0 && d0 < 175.0) {
            Hand hand = p_147340_1_.func_186994_b();
            ItemStack itemstack = hand != null ? player.func_184586_b(hand).func_77946_l() : ItemStack.field_190927_a;
            Optional<Object> optional = Optional.empty();
            if (p_147340_1_.func_149565_c() == CUseEntityPacket.Action.INTERACT) {
                optional = Optional.of(player.func_190775_a(entity, hand));
            } else if (p_147340_1_.func_149565_c() == CUseEntityPacket.Action.INTERACT_AT) {
                if (ForgeHooks.onInteractEntityAt((PlayerEntity)player, (Entity)entity, (Vector3d)p_147340_1_.func_179712_b(), (Hand)hand) != null) {
                    return;
                }
                optional = Optional.of(entity.func_184199_a((PlayerEntity)player, p_147340_1_.func_179712_b(), hand));
            } else if (p_147340_1_.func_149565_c() == CUseEntityPacket.Action.ATTACK) {
                if (entity instanceof ItemEntity || entity instanceof ExperienceOrbEntity || entity instanceof AbstractArrowEntity || entity == player) {
                    network.func_150718_a((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.invalid_entity_attacked"));
                    return;
                }
                player.func_71059_n(entity);
            }
            if (optional.isPresent() && ((ActionResultType)optional.get()).func_226246_a_()) {
                CriteriaTriggers.field_241276_P_.func_241476_a_(player, itemstack, entity);
                if (((ActionResultType)optional.get()).func_226247_b_()) {
                    player.func_226292_a_(hand, true);
                }
            }
        }
    }

    public static class FlagCartPacket {
        public boolean is_decrement;
        public boolean is_disclude;

        public FlagCartPacket(boolean is_decrement, boolean is_disclude) {
            this.is_decrement = is_decrement;
            this.is_disclude = is_disclude;
        }

        public static void encode(FlagCartPacket msg, PacketBuffer buf) {
            buf.writeBoolean(msg.is_decrement);
            buf.writeBoolean(msg.is_disclude);
        }

        public static FlagCartPacket decode(PacketBuffer buf) {
            FlagCartPacket packet = new FlagCartPacket(false, false);
            packet.is_decrement = buf.readBoolean();
            packet.is_disclude = buf.readBoolean();
            return packet;
        }

        public static void handle(FlagCartPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender.field_71070_bA instanceof FlagCartContainer) {
                    ((FlagCartContainer)sender.field_71070_bA).changeSelection(msg.is_decrement, msg.is_disclude);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class MinecartLoaderPacket {
        public boolean is_unloader;
        public boolean locked_minecarts_only;
        public boolean leave_one_item_in_stack;
        public boolean redstone_output;
        public AbstractCommonLoader.ComparatorOutputType output_type;

        public MinecartLoaderPacket() {
        }

        public MinecartLoaderPacket(boolean is_unloader, boolean locked_minecarts_only, boolean leave_one_item_in_stack, AbstractCommonLoader.ComparatorOutputType output_type, boolean redstone_output) {
            this.is_unloader = is_unloader;
            this.locked_minecarts_only = locked_minecarts_only;
            this.leave_one_item_in_stack = leave_one_item_in_stack;
            this.output_type = output_type;
            this.redstone_output = redstone_output;
        }

        public static void encode(MinecartLoaderPacket msg, PacketBuffer buf) {
            buf.writeBoolean(msg.is_unloader);
            buf.writeBoolean(msg.locked_minecarts_only);
            buf.writeBoolean(msg.leave_one_item_in_stack);
            buf.func_179249_a((Enum)msg.output_type);
            buf.writeBoolean(msg.redstone_output);
        }

        public static MinecartLoaderPacket decode(PacketBuffer buf) {
            MinecartLoaderPacket packet = new MinecartLoaderPacket();
            packet.is_unloader = buf.readBoolean();
            packet.locked_minecarts_only = buf.readBoolean();
            packet.leave_one_item_in_stack = buf.readBoolean();
            packet.output_type = (AbstractCommonLoader.ComparatorOutputType)buf.func_179257_a(AbstractCommonLoader.ComparatorOutputType.class);
            packet.redstone_output = buf.readBoolean();
            return packet;
        }

        public static void handle(MinecartLoaderPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender.field_71070_bA instanceof MinecartUnLoaderContainer) {
                    MinecartUnLoaderContainer container = (MinecartUnLoaderContainer)sender.field_71070_bA;
                    container.setOptions(msg.locked_minecarts_only, msg.leave_one_item_in_stack, msg.output_type, msg.redstone_output);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class ExtendedInteractPacket
    extends CUseEntityPacket {
        public ExtendedInteractPacket() {
        }

        @OnlyIn(value=Dist.CLIENT)
        public ExtendedInteractPacket(Entity p_i47098_1_, Hand p_i47098_2_, boolean p_i47098_4_) {
            super(p_i47098_1_, p_i47098_2_, p_i47098_4_);
        }

        public static void encode(ExtendedInteractPacket msg, PacketBuffer buf) {
            try {
                msg.func_148840_b(buf);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public static ExtendedInteractPacket decode(PacketBuffer buf) {
            ExtendedInteractPacket packet = new ExtendedInteractPacket();
            try {
                packet.func_148837_a(buf);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return packet;
        }

        public static void handle(ExtendedInteractPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
                NetworkManager network = ((NetworkEvent.Context)ctx.get()).getNetworkManager();
                MoreMinecartsPacketHandler.handleInteract(network, msg, sender);
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class PistonPushcartPacket {
        public boolean is_up_key;
        public boolean now_down;

        public PistonPushcartPacket(boolean is_up_key, boolean now_down) {
            this.is_up_key = is_up_key;
            this.now_down = now_down;
        }

        public static void encode(PistonPushcartPacket msg, PacketBuffer buf) {
            buf.writeBoolean(msg.is_up_key);
            buf.writeBoolean(msg.now_down);
        }

        public static PistonPushcartPacket decode(PacketBuffer buf) {
            PistonPushcartPacket packet = new PistonPushcartPacket(false, false);
            packet.is_up_key = buf.readBoolean();
            packet.now_down = buf.readBoolean();
            return packet;
        }

        public static void handle(PistonPushcartPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender.func_184208_bv() instanceof PistonPushcartEntity) {
                    ((PistonPushcartEntity)sender.func_184208_bv()).setElevating(msg.is_up_key, msg.now_down);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class ChunkLoaderPacket {
        public boolean set_enabled;

        public ChunkLoaderPacket(boolean set_enabled) {
            this.set_enabled = set_enabled;
        }

        public static void encode(ChunkLoaderPacket msg, PacketBuffer buf) {
            buf.writeBoolean(msg.set_enabled);
        }

        public static ChunkLoaderPacket decode(PacketBuffer buf) {
            ChunkLoaderPacket packet = new ChunkLoaderPacket(false);
            packet.set_enabled = buf.readBoolean();
            return packet;
        }

        public static void handle(ChunkLoaderPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender.field_71070_bA instanceof ChunkLoaderContainer) {
                    ((ChunkLoaderContainer)sender.field_71070_bA).setEnabled(msg.set_enabled);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class CouplePacket {
        public int coupler_id;
        public int v1;
        public int v2;

        public CouplePacket(int coupler_id, int v1, int v2) {
            this.coupler_id = coupler_id;
            this.v1 = v1;
            this.v2 = v2;
        }

        public static void encode(CouplePacket msg, PacketBuffer buf) {
            buf.writeInt(msg.v1);
            buf.writeInt(msg.v2);
            buf.writeInt(msg.coupler_id);
        }

        public static CouplePacket decode(PacketBuffer buf) {
            CouplePacket packet = new CouplePacket(0, 0, 0);
            packet.v1 = buf.readInt();
            packet.v2 = buf.readInt();
            packet.coupler_id = buf.readInt();
            return packet;
        }

        public static void handle(CouplePacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                World world = MoreMinecartsMod.PROXY.getWorld();
                Entity ent = world.func_73045_a(msg.coupler_id);
                if (ent != null && ent instanceof CouplerEntity) {
                    CouplerEntity coupler_ent = (CouplerEntity)ent;
                    coupler_ent.vehicle1_id = msg.v1;
                    coupler_ent.vehicle2_id = msg.v2;
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

