/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.entities;

import com.alc.moreminecarts.MMItemReferences;
import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.entities.IronPushcartEntity;
import com.alc.moreminecarts.proxy.MoreMinecartsPacketHandler;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.World;

public class PistonPushcartEntity
extends IronPushcartEntity {
    private static final ImmutableMap<Pose, ImmutableList<Integer>> POSE_DISMOUNT_HEIGHTS = ImmutableMap.of((Object)Pose.STANDING, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)Pose.CROUCHING, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)Pose.SWIMMING, (Object)ImmutableList.of((Object)0, (Object)1));
    public static final DataParameter<Float> HEIGHT_PARAMETER = EntityDataManager.func_187226_a(PistonPushcartEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Float> LAST_HEIGHT_PARAMETER = EntityDataManager.func_187226_a(PistonPushcartEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final String HEIGHT_NAME = "height";
    public static final String LAST_HEIGHT_NAME = "last_height";
    public boolean going_up;
    public boolean going_down;

    public float getHeight() {
        return ((Float)this.field_70180_af.func_187225_a(HEIGHT_PARAMETER)).floatValue();
    }

    protected void setHeight(float height) {
        this.field_70180_af.func_187227_b(HEIGHT_PARAMETER, (Object)Float.valueOf(height));
    }

    public float getLastHeight() {
        return ((Float)this.field_70180_af.func_187225_a(LAST_HEIGHT_PARAMETER)).floatValue();
    }

    protected void setLastHeight(float height) {
        this.field_70180_af.func_187227_b(LAST_HEIGHT_PARAMETER, (Object)Float.valueOf(height));
    }

    public PistonPushcartEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    public PistonPushcartEntity(EntityType<?> type, World worldIn, double x, double y, double z) {
        super(type, worldIn, x, y, z);
    }

    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a(HEIGHT_NAME, this.getHeight());
        compound.func_74776_a(LAST_HEIGHT_NAME, this.getLastHeight());
    }

    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHeight(compound.func_74760_g(HEIGHT_NAME));
        this.setLastHeight(compound.func_74760_g(LAST_HEIGHT_NAME));
    }

    public double func_70042_X() {
        return 0.65 + (double)this.getHeight();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        float height = this.getHeight();
        float last_height = this.getLastHeight();
        if (height != last_height) {
            this.setLastHeight(height);
        }
        if (this.ContainsPlayerPassenger()) {
            if (this.going_up) {
                this.attemptMove(true, false);
            }
            if (this.going_down) {
                this.attemptMove(false, false);
            }
        }
    }

    public void attemptMove(boolean going_up, boolean is_reduced) {
        float height = this.getHeight();
        if (going_up) {
            BlockPos test_pos = this.func_233580_cy_().func_177981_b((int)Math.ceil((double)height + 1.5));
            BlockState test_state = this.field_70170_p.func_180495_p(test_pos);
            if (!test_state.func_235785_r_((IBlockReader)this.field_70170_p, test_pos)) {
                this.setHeight(height + this.getVerticalSpeed() * (is_reduced ? 0.2f : 1.0f));
            }
            if (this.getHeight() > 10.0f) {
                this.setHeight(10.0f);
            }
        } else {
            this.setHeight(height - this.getVerticalSpeed() * (is_reduced ? 0.2f : 1.0f));
            if (this.getHeight() < 0.0f) {
                this.setHeight(0.0f);
            }
        }
    }

    public float getVerticalSpeed() {
        return 0.2f;
    }

    public boolean ContainsPlayerPassenger() {
        for (Entity entity : this.func_184188_bt()) {
            if (!(entity instanceof PlayerEntity)) continue;
            return true;
        }
        return false;
    }

    protected void func_184225_p(Entity p_184225_1_) {
        this.going_up = false;
        this.going_down = false;
        super.func_184225_p(p_184225_1_);
    }

    protected void func_184200_o(Entity p_184200_1_) {
        this.going_up = false;
        this.going_down = false;
        super.func_184200_o(p_184200_1_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(HEIGHT_PARAMETER, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(LAST_HEIGHT_PARAMETER, (Object)Float.valueOf(0.0f));
    }

    public void setElevating(boolean is_upwards, boolean is_down) {
        if (is_upwards) {
            this.going_up = is_down;
        } else {
            this.going_down = is_down;
        }
    }

    public BlockState func_174897_t() {
        return MMReferences.piston_display_block.func_176223_P();
    }

    public BlockState func_180457_u() {
        return MMReferences.piston_display_block.func_176223_P();
    }

    public AxisAlignedBB func_184177_bl() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        AxisAlignedBB true_axisalignedbb = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, axisalignedbb.field_72337_e + 0.2 + (double)this.getHeight(), axisalignedbb.field_72334_f);
        return this.func_94100_s() ? true_axisalignedbb.func_186662_g((double)Math.abs(this.func_94099_q()) / 16.0) : true_axisalignedbb;
    }

    @Override
    public void func_94095_a(DamageSource source) {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            ItemStack stack = new ItemStack((IItemProvider)MMItemReferences.iron_pushcart);
            if (this.func_145818_k_()) {
                stack.func_200302_a(this.func_200201_e());
            }
            this.func_199701_a_(stack);
            this.func_199701_a_(new ItemStack((IItemProvider)Items.field_221602_aD));
        }
    }

    public AxisAlignedBB func_174813_aQ() {
        AxisAlignedBB bounding_box = super.func_174813_aQ();
        return new AxisAlignedBB(bounding_box.field_72340_a, bounding_box.field_72338_b, bounding_box.field_72339_c, bounding_box.field_72336_d, bounding_box.field_72337_e + 0.2 + (double)this.getHeight(), bounding_box.field_72334_f);
    }

    public Vector3d func_230268_c_(LivingEntity p_230268_1_) {
        Direction direction = this.func_184172_bi();
        if (direction.func_176740_k() == Direction.Axis.Y) {
            return super.func_230268_c_(p_230268_1_);
        }
        int[][] aint = TransportationHelper.func_234632_a_((Direction)direction);
        BlockPos blockpos = this.func_233580_cy_();
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        ImmutableList immutablelist = p_230268_1_.func_230297_ef_();
        for (Pose pose : immutablelist) {
            EntitySize entitysize = p_230268_1_.func_213305_a(pose);
            float f = Math.min(entitysize.field_220315_a, 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableIterator = ((ImmutableList)POSE_DISMOUNT_HEIGHTS.get((Object)pose)).iterator();
            while (unmodifiableIterator.hasNext()) {
                int i = (Integer)unmodifiableIterator.next();
                for (int[] aint1 : aint) {
                    Vector3d vector3d;
                    AxisAlignedBB axisalignedbb;
                    blockpos$mutable.func_189532_c((double)(blockpos.func_177958_n() + aint1[0]), (double)((float)blockpos.func_177956_o() + this.getHeight() + (float)i), (double)(blockpos.func_177952_p() + aint1[1]));
                    double d0 = this.field_70170_p.func_242402_a(TransportationHelper.func_242380_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable), () -> TransportationHelper.func_242380_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable.func_177977_b()));
                    if (!TransportationHelper.func_234630_a_((double)d0) || !TransportationHelper.func_234631_a_((ICollisionReader)this.field_70170_p, (LivingEntity)p_230268_1_, (AxisAlignedBB)(axisalignedbb = new AxisAlignedBB((double)(-f), 0.0, (double)(-f), (double)f, (double)entitysize.field_220316_b, (double)f)).func_191194_a(vector3d = Vector3d.func_237490_a_((Vector3i)blockpos$mutable, (double)d0)))) continue;
                    p_230268_1_.func_213301_b(pose);
                    return vector3d;
                }
            }
        }
        double d1 = this.func_174813_aQ().field_72337_e;
        blockpos$mutable.func_189532_c((double)blockpos.func_177958_n(), d1, (double)blockpos.func_177952_p());
        for (Pose pose1 : immutablelist) {
            double d2 = p_230268_1_.func_213305_a((Pose)pose1).field_220316_b;
            int j = MathHelper.func_76143_f((double)(d1 - (double)blockpos$mutable.func_177956_o() + d2));
            double d3 = TransportationHelper.func_242383_a((BlockPos)blockpos$mutable, (int)j, p_242377_1_ -> this.field_70170_p.func_180495_p(p_242377_1_).func_196952_d((IBlockReader)this.field_70170_p, p_242377_1_));
            if (!(d1 + d2 <= d3)) continue;
            p_230268_1_.func_213301_b(pose1);
            break;
        }
        return super.func_230268_c_(p_230268_1_);
    }

    @Override
    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ActionResultType result = super.func_184230_a(player, hand);
        double distance = this.func_70068_e((Entity)player);
        if (result == ActionResultType.SUCCESS && this.field_70170_p.field_72995_K && distance >= 36.0 && distance < 175.0) {
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)new MoreMinecartsPacketHandler.ExtendedInteractPacket((Entity)this, hand, player.func_225608_bj_()));
        }
        return result;
    }

    @Override
    public ItemStack getCartItem() {
        return new ItemStack((IItemProvider)MMItemReferences.piston_pushcart);
    }
}

