/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.entities;

import com.alc.moreminecarts.MMItemReferences;
import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.blocks.OrbStasisBlock;
import com.alc.moreminecarts.tile_entities.OrbStasisTile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkHooks;

public class OrbStasisCart
extends AbstractMinecartEntity {
    private static final DataParameter<Boolean> HAS_ORB = EntityDataManager.func_187226_a(OrbStasisCart.class, (IDataSerializer)DataSerializers.field_187198_h);
    @Nullable
    public UUID owner_uuid;

    public OrbStasisCart(EntityType<?> type, World world) {
        super(type, world);
    }

    public OrbStasisCart(EntityType<?> type, World worldIn, double x, double y, double z) {
        super(type, worldIn, x, y, z);
    }

    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.CHEST;
    }

    public void func_94095_a(DamageSource source) {
        super.func_94095_a(source);
        if (!source.func_94541_c() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            this.func_199703_a((IItemProvider)MMItemReferences.pearl_stasis_chamber);
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.attemptTeleport();
    }

    public void func_96095_a(int p_96095_1_, int p_96095_2_, int p_96095_3_, boolean p_96095_4_) {
        if (p_96095_4_) {
            this.attemptTeleport();
        }
    }

    public ActionResultType func_184230_a(PlayerEntity playerEntity, Hand hand) {
        ActionResultType ret = super.func_184230_a(playerEntity, hand);
        if (ret.func_226246_a_()) {
            return ret;
        }
        if (this.getHasOrb()) {
            return ActionResultType.PASS;
        }
        ItemStack item_used = playerEntity.func_184586_b(hand);
        if (item_used.func_77973_b() == Items.field_151079_bi) {
            if (this.field_70170_p.field_72995_K) {
                return ActionResultType.CONSUME;
            }
            if (this.owner_uuid == null) {
                this.addPearl(playerEntity);
                if (!playerEntity.func_184812_l_()) {
                    item_used.func_190918_g(1);
                }
            }
        }
        return ActionResultType.PASS;
    }

    protected void addPearl(PlayerEntity player) {
        this.owner_uuid = player.func_146103_bH().getId();
        this.setHasOrb(true);
    }

    protected void attemptTeleport() {
        if (this.field_70170_p.field_72995_K || this.owner_uuid == null) {
            return;
        }
        PlayerEntity entity = this.field_70170_p.func_217371_b(this.owner_uuid);
        if (entity instanceof ServerPlayerEntity) {
            EnderTeleportEvent event;
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            if (player.field_71135_a.func_147298_b().func_150724_d() && player.field_70170_p == this.field_70170_p && !player.func_70608_bn() && !MinecraftForge.EVENT_BUS.post((Event)(event = new EnderTeleportEvent((LivingEntity)player, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 5.0f)))) {
                if (this.field_70170_p.field_73012_v.nextFloat() < 0.05f && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223601_d)) {
                    EndermiteEntity endermiteentity = (EndermiteEntity)EntityType.field_200804_r.func_200721_a(this.field_70170_p);
                    endermiteentity.func_175496_a(true);
                    endermiteentity.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
                    this.field_70170_p.func_217376_c((Entity)endermiteentity);
                }
                if (entity.func_184218_aH()) {
                    entity.func_184210_p();
                }
                entity.func_70634_a(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                entity.field_70143_R = 0.0f;
                entity.func_70097_a(DamageSource.field_76379_h, event.getAttackDamage());
            }
        }
        this.owner_uuid = null;
        this.setHasOrb(false);
    }

    public BlockState func_180457_u() {
        BlockState blockState = this.field_70170_p.func_180495_p(this.func_233580_cy_());
        boolean is_activated = blockState.func_203425_a(Blocks.field_150408_cc) && (Boolean)blockState.func_177229_b((Property)PoweredRailBlock.field_176569_M) != false;
        return (BlockState)((BlockState)MMReferences.pearl_stasis_chamber.func_176223_P().func_206870_a((Property)OrbStasisBlock.CONTAINS_PEARL, (Comparable)Boolean.valueOf(this.getHasOrb()))).func_206870_a((Property)OrbStasisBlock.POWERED, (Comparable)Boolean.valueOf(is_activated));
    }

    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_186854_a(OrbStasisTile.PLAYER_UUID_PROPERTY, this.owner_uuid);
    }

    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.owner_uuid = compound.func_186857_a(OrbStasisTile.PLAYER_UUID_PROPERTY);
        this.setHasOrb(this.owner_uuid != null);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_ORB, (Object)false);
    }

    protected boolean getHasOrb() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_ORB);
    }

    protected void setHasOrb(boolean powered) {
        this.field_70180_af.func_187227_b(HAS_ORB, (Object)powered);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ItemStack getCartItem() {
        return new ItemStack((IItemProvider)MMItemReferences.minecart_with_stasis);
    }
}

