/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.entities;

import com.alc.moreminecarts.MMItemReferences;
import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.blocks.PistonDisplayBlock;
import com.alc.moreminecarts.blocks.utility_rails.ArithmeticRailBlock;
import com.alc.moreminecarts.containers.FlagCartContainer;
import com.alc.moreminecarts.misc.FlagUtil;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.ContainerMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class FlagCartEntity
extends ContainerMinecartEntity {
    public static String SELECTED_SLOT_PROPERTY = "selected_slot";
    public static String DISCLUDED_SLOTS_PROPERTY = "discluded_slots";
    private static final DataParameter<Integer> DISPLAY_TYPE = EntityDataManager.func_187226_a(FlagCartEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public int selected_slot = 0;
    public int discluded_slots = 0;
    public BlockPos old_block_pos;
    public final IIntArray dataAccess = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return FlagCartEntity.this.selected_slot;
                }
                case 1: {
                    return FlagCartEntity.this.discluded_slots;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int set_to) {
            switch (index) {
                case 0: {
                    FlagCartEntity.this.selected_slot = set_to;
                    break;
                }
                case 1: {
                    FlagCartEntity.this.discluded_slots = set_to;
                    FlagCartEntity.this.selected_slot = Math.min(8 - FlagCartEntity.this.discluded_slots, FlagCartEntity.this.selected_slot);
                    break;
                }
            }
            FlagCartEntity.this.updateDisplayType();
        }

        public int func_221478_a() {
            return 2;
        }
    };

    public FlagCartEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    public FlagCartEntity(EntityType<?> type, World worldIn, double x, double y, double z) {
        super(type, x, y, z, worldIn);
    }

    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.CHEST;
    }

    public void func_94095_a(DamageSource source) {
        super.func_94095_a(source);
        if (!source.func_94541_c() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            this.func_199703_a((IItemProvider)Items.field_222094_pA);
            this.func_199703_a((IItemProvider)Items.field_222029_iU);
        }
    }

    protected Container func_213968_a(int i, PlayerInventory inv) {
        return new FlagCartContainer(i, this.field_70170_p, this, inv, inv.field_70458_d);
    }

    public BlockState func_180457_u() {
        int raw_display = 6 + this.getDisplayType();
        return (BlockState)MMReferences.piston_display_block.func_176223_P().func_206870_a((Property)PistonDisplayBlock.VARIANT, (Comparable)Integer.valueOf(raw_display));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_96095_a(int p_96095_1_, int p_96095_2_, int p_96095_3_, boolean p_96095_4_) {
        if (!this.field_70170_p.field_72995_K) {
            this.selected_slot = 0;
        }
        this.updateDisplayType();
    }

    public int func_70302_i_() {
        return 9;
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        ItemStack ret = super.func_70298_a(p_70298_1_, p_70298_2_);
        this.updateDisplayType();
        return ret;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        super.func_70299_a(p_70299_1_, p_70299_2_);
        this.updateDisplayType();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return player.func_70092_e(this.func_213303_ch().field_72450_a + 0.5, this.func_213303_ch().field_72448_b + 0.5, this.func_213303_ch().field_72449_c + 0.5) <= 64.0;
    }

    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a(SELECTED_SLOT_PROPERTY, this.selected_slot);
        compound.func_74768_a(DISCLUDED_SLOTS_PROPERTY, this.discluded_slots);
    }

    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.selected_slot = compound.func_74762_e(SELECTED_SLOT_PROPERTY);
        this.discluded_slots = compound.func_74762_e(DISCLUDED_SLOTS_PROPERTY);
        this.updateDisplayType();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DISPLAY_TYPE, (Object)0);
    }

    public Item getSelectedFlag() {
        return this.func_70301_a(this.selected_slot).func_77973_b();
    }

    public void cycleFlag(ArithmeticRailBlock.SignalEffect effect) {
        boolean is_decrement = effect.isNegative();
        if (effect.isShift()) {
            this.selected_slot = FlagUtil.getNextSelectedSlot(this.selected_slot, this.discluded_slots, is_decrement);
        } else {
            if (!is_decrement && this.discluded_slots >= 8) {
                return;
            }
            if (is_decrement && this.discluded_slots <= 0) {
                return;
            }
            this.discluded_slots += is_decrement ? -1 : 1;
            this.selected_slot = Math.min(8 - this.discluded_slots, this.selected_slot);
        }
        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187626_cN, SoundCategory.BLOCKS, 0.5f, 1.0f, true);
        this.updateDisplayType();
    }

    public int getDisplayType() {
        return (Integer)this.field_70180_af.func_187225_a(DISPLAY_TYPE);
    }

    public void updateDisplayType() {
        if (!this.field_70170_p.field_72995_K) {
            Item this_item = this.func_70301_a(this.selected_slot).func_77973_b();
            int full_display = 0;
            this.field_70180_af.func_187227_b(DISPLAY_TYPE, (Object)(full_display += FlagUtil.getFlagColorValue(this_item)));
        }
    }

    public void func_70071_h_() {
        BlockPos new_block_pos;
        if (this.old_block_pos == null) {
            this.old_block_pos = this.func_233580_cy_();
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.old_block_pos.equals((Object)(new_block_pos = this.func_233580_cy_()))) {
            BlockState new_blockstate = this.field_70170_p.func_180495_p(new_block_pos);
            if (new_blockstate.func_177230_c() == MMReferences.arithmetic_rail && ((Boolean)new_blockstate.func_177229_b((Property)ArithmeticRailBlock.POWERED)).booleanValue()) {
                this.cycleFlag((ArithmeticRailBlock.SignalEffect)((Object)new_blockstate.func_177229_b((Property)ArithmeticRailBlock.EFFECT)));
            }
            this.old_block_pos = new_block_pos;
        }
    }

    public ItemStack getCartItem() {
        return new ItemStack((IItemProvider)MMItemReferences.flag_cart);
    }
}

