/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.containers;

import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.proxy.MoreMinecartsPacketHandler;
import com.alc.moreminecarts.tile_entities.AbstractCommonLoader;
import com.alc.moreminecarts.tile_entities.MinecartLoaderTile;
import com.alc.moreminecarts.tile_entities.MinecartUnloaderTile;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class MinecartUnLoaderContainer
extends Container {
    private final AbstractCommonLoader tile;
    private final IInventory inventory;
    private final IIntArray data;
    protected final World level;

    public MinecartUnLoaderContainer(int n, World world, PlayerInventory player_inventory, PlayerEntity player_entity) {
        super(MMReferences.minecart_loader_c, n);
        this.tile = null;
        this.inventory = new Inventory(1);
        this.data = new IntArray(3);
        this.level = player_inventory.field_70458_d.field_70170_p;
        this.CommonInitialization(player_inventory);
    }

    public MinecartUnLoaderContainer(int n, World world, BlockPos pos, PlayerInventory player_inventory, PlayerEntity player_entity) {
        super(MMReferences.minecart_loader_c, n);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MinecartLoaderTile) {
            MinecartLoaderTile loader = (MinecartLoaderTile)te;
            this.inventory = loader;
            this.data = loader.dataAccess;
            this.tile = loader;
        } else if (te instanceof MinecartUnloaderTile) {
            MinecartUnloaderTile unloader = (MinecartUnloaderTile)te;
            this.inventory = unloader;
            this.data = unloader.dataAccess;
            this.tile = unloader;
        } else {
            this.inventory = new Inventory(1);
            this.data = new IntArray(2);
            this.tile = null;
        }
        this.level = player_inventory.field_70458_d.field_70170_p;
        this.CommonInitialization(player_inventory);
    }

    public void CommonInitialization(PlayerInventory player_inventory) {
        int i;
        MinecartUnLoaderContainer.func_216962_a((IInventory)this.inventory, (int)9);
        MinecartUnLoaderContainer.func_216959_a((IIntArray)this.data, (int)2);
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot(this.inventory, i, 8 + i * 18, 42));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)player_inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)player_inventory, k, 8 + k * 18, 142));
        }
        this.func_216961_a(this.data);
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.inventory.func_70300_a(player);
    }

    public ItemStack func_82846_b(PlayerEntity p_82846_1_, int p_82846_2_) {
        int containerRows = 1;
        ItemStack lvt_3_1_ = ItemStack.field_190927_a;
        Slot lvt_4_1_ = (Slot)this.field_75151_b.get(p_82846_2_);
        if (lvt_4_1_ != null && lvt_4_1_.func_75216_d()) {
            ItemStack lvt_5_1_ = lvt_4_1_.func_75211_c();
            lvt_3_1_ = lvt_5_1_.func_77946_l();
            if (p_82846_2_ < containerRows * 9 ? !this.func_75135_a(lvt_5_1_, containerRows * 9, this.field_75151_b.size(), true) : !this.func_75135_a(lvt_5_1_, 0, containerRows * 9, false)) {
                return ItemStack.field_190927_a;
            }
            if (lvt_5_1_.func_190926_b()) {
                lvt_4_1_.func_75215_d(ItemStack.field_190927_a);
            } else {
                lvt_4_1_.func_75218_e();
            }
        }
        return lvt_3_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSize() {
        return 9;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public FluidStack getFluids() {
        if (this.tile == null) {
            return null;
        }
        return this.tile.getFluidStack();
    }

    public int getEnergy() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergyAmount();
    }

    public boolean getRedstoneOutput() {
        return (this.data.func_221476_a(0) & 0x10) == 16;
    }

    public boolean getLockedMinecartsOnly() {
        return this.data.func_221476_a(0) % 2 == 1;
    }

    public boolean getLeaveOneInStack() {
        return (this.data.func_221476_a(0) & 2) == 2;
    }

    public AbstractCommonLoader.ComparatorOutputType getComparatorOutputType() {
        return AbstractCommonLoader.ComparatorOutputType.fromInt((this.data.func_221476_a(0) & 0xC) >> 2);
    }

    public MoreMinecartsPacketHandler.MinecartLoaderPacket getCurrentPacket() {
        return new MoreMinecartsPacketHandler.MinecartLoaderPacket(false, this.getLockedMinecartsOnly(), this.getLeaveOneInStack(), this.getComparatorOutputType(), this.getRedstoneOutput());
    }

    public boolean getIsUnloader() {
        return this.data.func_221476_a(1) > 0;
    }

    public void setOptions(boolean locked_minecarts_only, boolean leave_one_in_stack, AbstractCommonLoader.ComparatorOutputType comparator_output, boolean redstone_output) {
        int options = (locked_minecarts_only ? 1 : 0) + ((leave_one_in_stack ? 1 : 0) << 1) + (comparator_output.toInt() << 2) + ((redstone_output ? 1 : 0) << 4);
        this.func_75137_b(0, options);
        this.func_75142_b();
    }
}

