/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.blocks.rail_turns;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RailTurn
extends AbstractRailBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.field_208166_S;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty FLIPPED = BooleanProperty.func_177716_a((String)"flipped");

    public RailTurn(AbstractBlock.Properties builder) {
        super(true, builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FLIPPED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_189541_b(BlockState state, World worldIn, BlockPos pos, Block blockIn) {
        boolean flag2;
        boolean flag1 = (Boolean)state.func_177229_b((Property)POWERED);
        if (flag1 != (flag2 = worldIn.func_175640_z(pos))) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(flag2)), 3);
            worldIn.func_195593_d(pos.func_177977_b(), (Block)this);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_195992_f();
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction);
    }

    public Property<RailShape> func_176560_l() {
        return SHAPE;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.func_203425_a(state.func_177230_c())) {
            this.func_189541_b(state, worldIn, pos, state.func_177230_c());
        }
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
    }

    protected BlockState func_235327_a_(BlockState state, World world, BlockPos pos, boolean isMoving) {
        return state;
    }

    protected BlockState func_208489_a(World worldIn, BlockPos pos, BlockState state, boolean placing) {
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, SHAPE, POWERED, FLIPPED});
    }

    public boolean canMakeSlopes(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public RailShape getRailDirection(BlockState state, IBlockReader world, BlockPos pos, @Nullable AbstractMinecartEntity cart) {
        boolean is_powered = (Boolean)state.func_177229_b((Property)POWERED);
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        boolean is_x_axis = facing == Direction.NORTH || facing == Direction.SOUTH;
        boolean backwards = facing == Direction.NORTH || facing == Direction.EAST;
        boolean flipped = (Boolean)state.func_177229_b((Property)FLIPPED);
        if (cart != null) {
            boolean turn_approach;
            boolean bl = is_x_axis ? Math.abs(cart.func_213322_ci().field_72450_a) > 0.05 : (turn_approach = Math.abs(cart.func_213322_ci().field_72449_c) > 0.05);
            if (is_powered || turn_approach) {
                boolean backwards_approach;
                boolean bl2 = backwards_approach = (!is_x_axis ? cart.func_213322_ci().field_72450_a : -cart.func_213322_ci().field_72449_c) * (double)(backwards ? 1 : -1) <= 0.0 && !turn_approach;
                if (!backwards_approach) {
                    if (flipped) {
                        if (is_x_axis) {
                            return backwards ? RailShape.SOUTH_WEST : RailShape.NORTH_EAST;
                        }
                        return backwards ? RailShape.NORTH_WEST : RailShape.SOUTH_EAST;
                    }
                    if (is_x_axis) {
                        return backwards ? RailShape.SOUTH_EAST : RailShape.NORTH_WEST;
                    }
                    return backwards ? RailShape.SOUTH_WEST : RailShape.NORTH_EAST;
                }
            }
        }
        return is_x_axis ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.func_201670_d()) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)FLIPPED, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)FLIPPED) == false)));
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return ActionResultType.func_233537_a_((boolean)worldIn.func_201670_d());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        state = (BlockState)state.func_206870_a((Property)FLIPPED, (Comparable)Boolean.valueOf((Boolean)(state = state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)))).func_177229_b((Property)FLIPPED) == false));
        return state;
    }
}

