/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.blocks.powered_rails;

import com.alc.moreminecarts.MMConstants;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PoweredLightspeedRail
extends PoweredRailBlock {
    public PoweredLightspeedRail(AbstractBlock.Properties builder) {
        super(builder, true);
    }

    public float getRailMaxSpeed(BlockState state, World world, BlockPos pos, AbstractMinecartEntity cart) {
        return MMConstants.LIGHTSPEED_MAX_SPEED;
    }

    public boolean canMakeSlopes(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn.func_201670_d()) {
            return;
        }
        if (((Boolean)state.func_177229_b((Property)field_176569_M)).booleanValue() && entityIn instanceof AbstractMinecartEntity) {
            AbstractMinecartEntity minecart = (AbstractMinecartEntity)entityIn;
            if (!minecart.shouldDoRailFunctions()) {
                return;
            }
            RailShape railshape = this.getRailDirection(state, (IBlockReader)worldIn, pos, minecart);
            Vector3d minecartVelocity = minecart.func_213322_ci();
            double minecartSpeedMagnitude = Math.sqrt(AbstractMinecartEntity.func_213296_b((Vector3d)minecartVelocity));
            if (minecartSpeedMagnitude > 0.01) {
                double d19 = MMConstants.POWERED_LIGHTSPEED_BOOST;
                minecart.func_213317_d(minecartVelocity.func_72441_c(minecartVelocity.field_72450_a / minecartSpeedMagnitude * d19, 0.0, minecartVelocity.field_72449_c / minecartSpeedMagnitude * d19));
            } else {
                Vector3d vector3d7 = minecart.func_213322_ci();
                double d20 = vector3d7.field_72450_a;
                double d21 = vector3d7.field_72449_c;
                if (railshape == RailShape.EAST_WEST) {
                    if (this.isRedstoneConductor(worldIn, pos.func_177976_e())) {
                        d20 = 0.02;
                    } else if (this.isRedstoneConductor(worldIn, pos.func_177974_f())) {
                        d20 = -0.02;
                    }
                } else {
                    if (railshape != RailShape.NORTH_SOUTH) {
                        return;
                    }
                    if (this.isRedstoneConductor(worldIn, pos.func_177978_c())) {
                        d21 = 0.02;
                    } else if (this.isRedstoneConductor(worldIn, pos.func_177968_d())) {
                        d21 = -0.02;
                    }
                }
                minecart.func_213293_j(d20, vector3d7.field_72448_b, d21);
            }
        }
    }

    private boolean isRedstoneConductor(World world, BlockPos p_213900_1_) {
        return world.func_180495_p(p_213900_1_).func_215686_e((IBlockReader)world, p_213900_1_);
    }
}

