/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.blocks.holographic_rails;

import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.blocks.holographic_rails.HolographicRail;
import com.alc.moreminecarts.misc.RailUtil;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ProjectorRail
extends AbstractRailBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.field_208166_S;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public ProjectorRail(AbstractBlock.Properties builder) {
        super(true, builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, SHAPE, POWERED});
    }

    protected int getHologramLength() {
        return 5;
    }

    protected Block getHologramRail() {
        return MMReferences.hologram_rail;
    }

    protected void func_189541_b(BlockState state, World worldIn, BlockPos pos, Block blockIn) {
        this.updateState(state, worldIn, pos, blockIn, false);
    }

    protected void updateState(BlockState state, World worldIn, BlockPos pos, Block blockIn, boolean force) {
        boolean now_powered;
        boolean currently_powered = (Boolean)state.func_177229_b((Property)POWERED);
        if (currently_powered != (now_powered = worldIn.func_175640_z(pos)) || force) {
            BlockState test_state;
            BlockPos test_pos;
            int i;
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(now_powered)), 3);
            Direction direction = (Direction)state.func_177229_b((Property)FACING);
            RailShape shape = RailUtil.FacingToShape(direction, now_powered);
            RailShape old_shape = RailUtil.FacingToShape(direction, !now_powered);
            for (i = 0; i < this.getHologramLength(); ++i) {
                test_pos = pos.func_177967_a(direction, i + 1).func_177981_b(!now_powered ? i : 0);
                test_state = worldIn.func_180495_p(test_pos);
                if (!test_state.func_203425_a(this.getHologramRail()) || test_state.func_177229_b((Property)FACING) != direction || test_state.func_177229_b(SHAPE) != old_shape) continue;
                worldIn.func_180501_a(test_pos, Blocks.field_150350_a.func_176223_P(), 3);
            }
            for (i = 0; i < this.getHologramLength(); ++i) {
                test_pos = pos.func_177967_a(direction, i + 1).func_177981_b(now_powered ? i : 0);
                test_state = worldIn.func_180495_p(test_pos);
                if (test_state.func_203425_a(this.getHologramRail()) && test_state.func_177229_b((Property)FACING) == direction && test_state.func_177229_b(SHAPE) == shape) continue;
                if (!test_state.func_196958_f()) break;
                worldIn.func_180501_a(test_pos, (BlockState)((BlockState)((BlockState)this.getHologramRail().func_176223_P().func_206870_a((Property)FACING, (Comparable)direction)).func_206870_a(SHAPE, (Comparable)shape)).func_206870_a((Property)HolographicRail.LENGTH, (Comparable)Integer.valueOf(i)), 3);
            }
            worldIn.func_195593_d(pos.func_177977_b(), (Block)this);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_195992_f();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction)).func_206870_a(SHAPE, (Comparable)(direction.func_176740_k() == Direction.Axis.Z ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST));
    }

    public Property<RailShape> func_176560_l() {
        return SHAPE;
    }

    public RailShape getRailDirection(BlockState state, IBlockReader world, BlockPos pos, @Nullable AbstractMinecartEntity cart) {
        return ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == Direction.Axis.Z ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!worldIn.func_201670_d()) {
            this.updateState(state, worldIn, pos, state.func_177230_c(), true);
        }
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
    }

    protected BlockState func_235327_a_(BlockState state, World world, BlockPos pos, boolean isMoving) {
        return state;
    }

    protected BlockState func_208489_a(World worldIn, BlockPos pos, BlockState state, boolean placing) {
        return state;
    }

    public boolean canMakeSlopes(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.func_201670_d()) {
            this.updateState(state, worldIn, pos, state.func_177230_c(), true);
        }
        return ActionResultType.func_233537_a_((boolean)worldIn.func_201670_d());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
        return state;
    }
}

