/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.blocks.holographic_rails;

import com.alc.moreminecarts.MMReferences;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class HolographicRail
extends AbstractRailBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.field_208166_S;
    public static final IntegerProperty LENGTH = BlockStateProperties.field_208132_ag;
    protected static final VoxelShape FULL_BLOCK_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public HolographicRail(AbstractBlock.Properties builder) {
        super(true, builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).func_206870_a((Property)LENGTH, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, SHAPE, LENGTH});
    }

    protected Block getProjectorRail() {
        return MMReferences.projector_rail;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world_reader, BlockPos pos) {
        BlockPos holograph_position;
        BlockState holograph_state;
        int length = (Integer)state.func_177229_b((Property)LENGTH);
        if (length != 0 && ((holograph_state = world_reader.func_180495_p(holograph_position = this.getSupportHolograph(state, pos))).func_177230_c() != state.func_177230_c() || holograph_state.func_177229_b((Property)FACING) != state.func_177229_b((Property)FACING))) {
            return false;
        }
        BlockPos projector_position = this.getSupportProjector(state, pos);
        BlockState projector_state = world_reader.func_180495_p(projector_position);
        return projector_state.func_177230_c() == this.getProjectorRail() && projector_state.func_177229_b((Property)FACING) == state.func_177229_b((Property)FACING);
    }

    public BlockPos getSupportHolograph(BlockState state, BlockPos pos) {
        RailShape shape = (RailShape)state.func_177229_b(SHAPE);
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        return pos.func_177979_c(shape.func_208092_c() ? 1 : 0).func_177972_a(facing.func_176734_d());
    }

    public BlockPos getSupportProjector(BlockState state, BlockPos pos) {
        RailShape shape = (RailShape)state.func_177229_b(SHAPE);
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        int length = (Integer)state.func_177229_b((Property)LENGTH);
        return pos.func_177979_c(shape.func_208092_c() ? length : 0).func_177967_a(facing.func_176734_d(), length + 1);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_195992_f();
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction);
    }

    public void func_220069_a(BlockState p_220069_1_, World p_220069_2_, BlockPos p_220069_3_, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        if (!p_220069_2_.field_72995_K && p_220069_2_.func_180495_p(p_220069_3_).func_203425_a((Block)this) && !this.func_196260_a(p_220069_1_, (IWorldReader)p_220069_2_, p_220069_3_)) {
            HolographicRail.func_220075_c((BlockState)p_220069_1_, (World)p_220069_2_, (BlockPos)p_220069_3_);
            p_220069_2_.func_217377_a(p_220069_3_, p_220069_6_);
        }
    }

    public Property<RailShape> func_176560_l() {
        return SHAPE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader block_reader, BlockPos pos, ISelectionContext selection_context) {
        RailShape railshape = state.func_203425_a((Block)this) ? (RailShape)state.func_177229_b(this.func_176560_l()) : null;
        return railshape != null && railshape.func_208092_c() ? FULL_BLOCK_AABB : field_185590_a;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.func_203425_a(state.func_177230_c())) {
            this.func_189541_b(state, worldIn, pos, state.func_177230_c());
        }
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
    }

    protected BlockState func_235327_a_(BlockState state, World world, BlockPos pos, boolean isMoving) {
        return state;
    }

    protected BlockState func_208489_a(World worldIn, BlockPos pos, BlockState state, boolean placing) {
        return state;
    }

    public boolean canMakeSlopes(BlockState state, IBlockReader world, BlockPos pos) {
        return true;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
        return state;
    }
}

