/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.blocks.holo_scaffolds;

import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.items.HoloRemoteItem;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class HoloScaffold
extends Block
implements IWaterLoggable {
    public static final int MAX_DISTANCE = 15;
    private static final VoxelShape STABLE_SHAPE;
    private static final VoxelShape UNSTABLE_SHAPE;
    private static final VoxelShape UNSTABLE_SHAPE_BOTTOM;
    private static final VoxelShape BELOW_BLOCK;
    public static final IntegerProperty TRUE_DISTANCE;
    public static final BooleanProperty WATERLOGGED;
    public static final BooleanProperty BOTTOM;
    public static final EnumProperty STRENGTH;

    public HoloScaffold(AbstractBlock.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)TRUE_DISTANCE, (Comparable)Integer.valueOf(15))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)STRENGTH, (Comparable)((Object)HoloScaffoldStrength.strong)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{TRUE_DISTANCE, WATERLOGGED, BOTTOM, STRENGTH});
    }

    public static int getDistance(IBlockReader reader, BlockPos pos) {
        int min_distance = 16;
        for (Direction direction : Direction.values()) {
            BlockState blockstate1 = reader.func_180495_p(pos.func_177972_a(direction));
            if (blockstate1.func_203425_a(MMReferences.holo_scaffold) || blockstate1.func_203425_a(MMReferences.chaotic_holo_scaffold)) {
                min_distance = Math.min(min_distance, (Integer)blockstate1.func_177229_b((Property)TRUE_DISTANCE) + 1);
                continue;
            }
            if (!blockstate1.func_203425_a(MMReferences.holo_scaffold_generator)) continue;
            return 1;
        }
        return min_distance;
    }

    public boolean isValidDistance(IBlockReader reader, BlockPos pos) {
        int distance = HoloScaffold.getDistance(reader, pos);
        return distance >= 0 && distance <= 15;
    }

    private void tickNeighbors(IWorld world, BlockPos pos, int value, boolean only_greater) {
        for (Direction direction : Direction.values()) {
            BlockPos check_pos = pos.func_177972_a(direction);
            BlockState blockstate1 = world.func_180495_p(check_pos);
            if (!blockstate1.func_203425_a(MMReferences.holo_scaffold) && !blockstate1.func_203425_a(MMReferences.chaotic_holo_scaffold)) continue;
            int distance = (Integer)blockstate1.func_177229_b((Property)TRUE_DISTANCE);
            if (only_greater && distance >= value) {
                world.func_205220_G_().func_205362_a(check_pos, (Object)this, 1, TickPriority.LOW);
            }
            if (only_greater || distance > value) continue;
            world.func_205220_G_().func_205362_a(check_pos, (Object)this, 1, TickPriority.LOW);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        super.func_225534_a_(state, world, pos, rand);
        int new_distance = HoloScaffold.getDistance((IBlockReader)world, pos);
        boolean new_bottom = this.isBottom((IBlockReader)world, pos, new_distance);
        if (new_distance == -1 || new_distance > 15) {
            world.func_175655_b(pos, true);
            return;
        }
        int old_distance = (Integer)state.func_177229_b((Property)TRUE_DISTANCE);
        boolean old_bottom = (Boolean)state.func_177229_b((Property)BOTTOM);
        if (new_distance < old_distance) {
            this.tickNeighbors((IWorld)world, pos, new_distance, true);
        } else if (new_distance > old_distance) {
            this.tickNeighbors((IWorld)world, pos, new_distance, false);
        }
        if (new_distance != old_distance || new_bottom != old_bottom) {
            world.func_180501_a(pos, (BlockState)((BlockState)((BlockState)state.func_206870_a((Property)TRUE_DISTANCE, (Comparable)Integer.valueOf(new_distance))).func_206870_a((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBottom((IBlockReader)world, pos, new_distance)))).func_206870_a((Property)STRENGTH, (Comparable)((Object)HoloScaffoldStrength.getFromLength(new_distance))), 2);
        }
    }

    public void func_220069_a(BlockState p_220069_1_, World p_220069_2_, BlockPos p_220069_3_, Block block, BlockPos p_220069_5_, boolean p_220069_6_) {
        if (!p_220069_2_.func_201670_d() && !(block instanceof HoloScaffold)) {
            p_220069_2_.func_205220_G_().func_205360_a(p_220069_5_, (Object)this, 1);
        }
    }

    public boolean func_196260_a(BlockState p_196260_1_, IWorldReader p_196260_2_, BlockPos p_196260_3_) {
        return this.isValidDistance((IBlockReader)p_196260_2_, p_196260_3_);
    }

    public FluidState func_204507_t(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(p_204507_1_);
    }

    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        BlockPos blockpos = p_196258_1_.func_195995_a();
        World world = p_196258_1_.func_195991_k();
        int i = HoloScaffold.getDistance((IBlockReader)world, blockpos);
        if (i < 0) {
            i = 0;
        }
        if (i > 15) {
            i = 15;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(blockpos).func_206886_c() == Fluids.field_204546_a))).func_206870_a((Property)TRUE_DISTANCE, (Comparable)Integer.valueOf(i))).func_206870_a((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBottom((IBlockReader)world, blockpos, i)))).func_206870_a((Property)STRENGTH, (Comparable)((Object)HoloScaffoldStrength.getFromLength(i)));
    }

    protected boolean isBottom(IBlockReader block_reader, BlockPos pos, int distance) {
        return block_reader.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_150350_a);
    }

    public boolean isScaffolding(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        if (!p_220053_4_.func_216375_a(p_220053_1_.func_177230_c().func_199767_j())) {
            return (Boolean)p_220053_1_.func_177229_b((Property)BOTTOM) != false ? UNSTABLE_SHAPE : STABLE_SHAPE;
        }
        return VoxelShapes.func_197868_b();
    }

    public VoxelShape func_199600_g(BlockState p_199600_1_, IBlockReader p_199600_2_, BlockPos p_199600_3_) {
        return VoxelShapes.func_197868_b();
    }

    public boolean func_196253_a(BlockState p_196253_1_, BlockItemUseContext p_196253_2_) {
        Item item_in_hand = p_196253_2_.func_195996_i().func_77973_b();
        return item_in_hand instanceof HoloRemoteItem && (((HoloRemoteItem)item_in_hand).remote_type == HoloRemoteItem.HoloRemoteType.regular || ((HoloRemoteItem)item_in_hand).remote_type == HoloRemoteItem.HoloRemoteType.backwards);
    }

    public BlockState func_196271_a(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, IWorld p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        if (((Boolean)p_196271_1_.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            p_196271_4_.func_205219_F_().func_205360_a(p_196271_5_, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)p_196271_4_));
        }
        if (!p_196271_4_.func_201670_d()) {
            p_196271_4_.func_205220_G_().func_205360_a(p_196271_5_, (Object)this, 1);
        }
        return p_196271_1_;
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        if (p_220071_4_.func_216378_a(VoxelShapes.func_197868_b(), p_220071_3_, true) && !p_220071_4_.func_225581_b_()) {
            return STABLE_SHAPE;
        }
        return (Integer)p_220071_1_.func_177229_b((Property)TRUE_DISTANCE) != 0 && (Boolean)p_220071_1_.func_177229_b((Property)BOTTOM) != false && p_220071_4_.func_216378_a(BELOW_BLOCK, p_220071_3_, true) ? UNSTABLE_SHAPE_BOTTOM : VoxelShapes.func_197880_a();
    }

    static {
        UNSTABLE_SHAPE_BOTTOM = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
        BELOW_BLOCK = VoxelShapes.func_197868_b().func_197751_a(0.0, -1.0, 0.0);
        TRUE_DISTANCE = IntegerProperty.func_177719_a((String)"distance", (int)0, (int)15);
        WATERLOGGED = BlockStateProperties.field_208198_y;
        BOTTOM = BlockStateProperties.field_222513_b;
        STRENGTH = EnumProperty.func_177706_a((String)"strength", HoloScaffoldStrength.class, (Enum[])new HoloScaffoldStrength[]{HoloScaffoldStrength.strong, HoloScaffoldStrength.weak, HoloScaffoldStrength.weakest});
        VoxelShape voxelshape = Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape voxelshape1 = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0);
        VoxelShape voxelshape2 = Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
        VoxelShape voxelshape3 = Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0);
        VoxelShape voxelshape4 = Block.func_208617_a((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        STABLE_SHAPE = VoxelShapes.func_216384_a((VoxelShape)voxelshape, (VoxelShape[])new VoxelShape[]{voxelshape1, voxelshape2, voxelshape3, voxelshape4});
        VoxelShape voxelshape5 = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)16.0);
        VoxelShape voxelshape6 = Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
        VoxelShape voxelshape7 = Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0, (double)16.0);
        VoxelShape voxelshape8 = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)2.0);
        UNSTABLE_SHAPE = VoxelShapes.func_216384_a((VoxelShape)UNSTABLE_SHAPE_BOTTOM, (VoxelShape[])new VoxelShape[]{STABLE_SHAPE, voxelshape6, voxelshape5, voxelshape8, voxelshape7});
    }

    public static enum HoloScaffoldStrength implements IStringSerializable
    {
        weakest,
        weak,
        strong;


        public String func_176610_l() {
            switch (this) {
                case strong: {
                    return "strong";
                }
                case weak: {
                    return "weak";
                }
                case weakest: {
                    return "weakest";
                }
            }
            return "ERROR";
        }

        public static HoloScaffoldStrength getFromLength(int length) {
            if (length == 15) {
                return weakest;
            }
            if (length >= 10) {
                return weak;
            }
            return strong;
        }
    }
}

