/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.blocks;

import com.alc.moreminecarts.tile_entities.OrbStasisTile;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class OrbStasisBlock
extends Block
implements ITileEntityProvider {
    public static final BooleanProperty CONTAINS_PEARL = BooleanProperty.func_177716_a((String)"has_orb");
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public OrbStasisBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)CONTAINS_PEARL, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CONTAINS_PEARL, POWERED});
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.func_203425_a(state.func_177230_c())) {
            this.updateState(state, worldIn, pos, state.func_177230_c());
        }
    }

    public void func_220069_a(BlockState p_220069_1_, World p_220069_2_, BlockPos p_220069_3_, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        super.func_220069_a(p_220069_1_, p_220069_2_, p_220069_3_, p_220069_4_, p_220069_5_, p_220069_6_);
        this.updateState(p_220069_1_, p_220069_2_, p_220069_3_, p_220069_4_);
    }

    protected void updateState(BlockState state, World worldIn, BlockPos pos, Block blockIn) {
        boolean new_powered;
        boolean old_powered = (Boolean)state.func_177229_b((Property)POWERED);
        if (old_powered != (new_powered = worldIn.func_175640_z(pos))) {
            BlockState new_state = (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(new_powered));
            worldIn.func_180501_a(pos, new_state, 3);
            worldIn.func_195593_d(pos, (Block)this);
            this.updateTileEntity(new_state, worldIn, pos, null);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blocktrace) {
        if (((Boolean)state.func_177229_b((Property)CONTAINS_PEARL)).booleanValue()) {
            return ActionResultType.PASS;
        }
        ItemStack item_used = playerEntity.func_184586_b(hand);
        if (item_used.func_77973_b() == Items.field_151079_bi) {
            if (world.field_72995_K) {
                return ActionResultType.CONSUME;
            }
            if (this.updateTileEntity(state, world, pos, playerEntity) && !playerEntity.func_184812_l_()) {
                item_used.func_190918_g(1);
            }
        }
        return ActionResultType.PASS;
    }

    private boolean updateTileEntity(BlockState state, World worldIn, BlockPos pos, PlayerEntity user) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof OrbStasisTile) {
            boolean now_has_pearl = ((OrbStasisTile)te).updateLock((Boolean)state.func_177229_b((Property)POWERED), user);
            if (now_has_pearl != (Boolean)state.func_177229_b((Property)CONTAINS_PEARL)) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)CONTAINS_PEARL, (Comparable)Boolean.valueOf(now_has_pearl)), 2);
                worldIn.func_175666_e(pos, state.func_177230_c());
            }
            return now_has_pearl;
        }
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader p_196283_1_) {
        return new OrbStasisTile();
    }

    public boolean func_149740_M(BlockState p_149740_1_) {
        return true;
    }

    public int func_180641_l(BlockState state, World p_180641_2_, BlockPos p_180641_3_) {
        return (Boolean)state.func_177229_b((Property)CONTAINS_PEARL) != false ? 15 : 0;
    }
}

