/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.immersiveengineering.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.immersiveengineering.recipe.IERecipeJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.util.ListJS;
import net.minecraftforge.common.crafting.CraftingHelper;

public class CrusherRecipeJS
extends IERecipeJS {
    public void create(ListJS args) {
        this.outputItems.add(this.parseResultItem(args.get(0)));
        this.inputItems.add(this.parseIngredientItem(args.get(1)).asIngredientStack());
        if (args.size() >= 3) {
            this.outputItems.addAll(this.parseResultItemList(args.get(2)));
        }
        this.json.addProperty("energy", (Number)6000);
    }

    public void deserialize() {
        this.outputItems.add(this.parseResultItem(this.json.get("result")));
        if (this.json.has("secondaries")) {
            for (JsonElement e : this.json.get("secondaries").getAsJsonArray()) {
                JsonObject o = e.getAsJsonObject();
                if (!CraftingHelper.processConditions((JsonObject)o, (String)"conditions")) continue;
                ItemStackJS stack = this.parseResultItem(o.get("output"));
                if (o.has("chance")) {
                    stack.setChance(o.get("chance").getAsDouble());
                }
                this.outputItems.add(stack);
            }
        }
        this.inputItems.add(this.parseIngredientItemIE(this.json.get("input")));
    }

    public void serialize() {
        if (this.serializeOutputs) {
            this.json.add("result", ((ItemStackJS)this.outputItems.get(0)).toResultJson());
            JsonArray array = new JsonArray();
            for (int i = 1; i < this.outputItems.size(); ++i) {
                JsonObject o = new JsonObject();
                ItemStackJS is = ((ItemStackJS)this.outputItems.get(i)).copy();
                o.addProperty("chance", (Number)(is.hasChance() ? is.getChance() : 1.0));
                is.removeChance();
                o.add("output", is.toResultJson());
                array.add((JsonElement)o);
            }
            this.json.add("secondaries", (JsonElement)array);
        }
        if (this.serializeInputs) {
            this.json.add("input", ((IngredientJS)this.inputItems.get(0)).toJson());
        }
    }
}

