/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.init;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterstrongholds.BetterStrongholds;
import com.yungnickyoung.minecraft.betterstrongholds.init.BSModConfiguredStructures;
import com.yungnickyoung.minecraft.betterstrongholds.mixin.ChunkGeneratorAccessor;
import com.yungnickyoung.minecraft.betterstrongholds.world.BetterStrongholdStructure;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BSModStructures {
    public static final DeferredRegister<Structure<?>> DEFERRED_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"betterstrongholds");
    public static final RegistryObject<Structure<NoFeatureConfig>> BETTER_STRONGHOLD = DEFERRED_REGISTRY.register("stronghold", () -> new BetterStrongholdStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static void init() {
        DEFERRED_REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BSModStructures::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(BSModStructures::addDimensionalSpacing);
        MinecraftForge.EVENT_BUS.addListener(BSModStructures::onBiomeLoad);
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Structure.field_236365_a_.put((Object)"Better Stronghold".toLowerCase(Locale.ROOT), (Object)BETTER_STRONGHOLD.get());
            DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put((Object)BETTER_STRONGHOLD.get(), (Object)new StructureSeparationSettings(85, 50, 596441294)).build();
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)new ResourceLocation("betterstrongholds", "stronghold"), BSModConfiguredStructures.CONFIGURED_BETTER_STRONGHOLD);
            FlatGenerationSettings.field_202247_j.put(BETTER_STRONGHOLD.get(), BSModConfiguredStructures.CONFIGURED_BETTER_STRONGHOLD);
            WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
                Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
                if (structureMap instanceof ImmutableMap) {
                    HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(structureMap);
                    tempMap.put(BETTER_STRONGHOLD.get(), DimensionStructuresSettings.field_236191_b_.get((Object)BETTER_STRONGHOLD.get()));
                    ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
                } else {
                    structureMap.put(BETTER_STRONGHOLD.get(), DimensionStructuresSettings.field_236191_b_.get((Object)BETTER_STRONGHOLD.get()));
                }
            });
        });
    }

    private static void onBiomeLoad(BiomeLoadingEvent event) {
        event.getGeneration().getStructures().removeIf(supplier -> ((StructureFeature)supplier.get()).field_236268_b_ == Structure.field_236375_k_);
        if (BetterStrongholds.blacklistedBiomes.contains(event.getName().toString())) {
            return;
        }
        event.getGeneration().getStructures().add(() -> BSModConfiguredStructures.CONFIGURED_BETTER_STRONGHOLD);
    }

    private static void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            try {
                ResourceLocation chunkGenResourceLocation = Registry.field_239690_aB_.func_177774_c(((ChunkGeneratorAccessor)serverWorld.func_72863_F().field_186029_c).betterstrongholds_getCodec());
                if (chunkGenResourceLocation != null && chunkGenResourceLocation.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                BetterStrongholds.LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            if (!BetterStrongholds.whitelistedDimensions.contains(serverWorld.func_234923_W_().func_240901_a_().toString())) {
                tempMap.keySet().remove(BETTER_STRONGHOLD.get());
            } else if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                tempMap.keySet().remove(BETTER_STRONGHOLD.get());
            } else {
                tempMap.put(BETTER_STRONGHOLD.get(), DimensionStructuresSettings.field_236191_b_.get((Object)BETTER_STRONGHOLD.get()));
            }
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

