/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.mehvahdjukaar.supplementaries.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.client.gui.BlackBoardButton;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.UpdateServerBlackboardPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class BlackBoardGui
extends Screen {
    private final BlackboardBlockTile tileBoard;
    private final BlackBoardButton[][] buttons = new BlackBoardButton[16][16];

    public BlackBoardGui(BlackboardBlockTile teBoard) {
        super((ITextComponent)new TranslationTextComponent("gui.supplementaries.blackboard.edit"));
        this.tileBoard = teBoard;
    }

    public static void open(BlackboardBlockTile sign) {
        Minecraft.func_71410_x().func_147108_a((Screen)new BlackBoardGui(sign));
    }

    public void func_231023_e_() {
        if (!this.tileBoard.func_200662_C().func_223045_a(this.tileBoard.func_195044_w().func_177230_c())) {
            this.close();
        }
    }

    public void func_231175_as__() {
        this.close();
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        byte[][] pixels = new byte[16][16];
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                pixels[xx][yy] = this.buttons[xx][yy].color;
            }
        }
        NetworkHandler.INSTANCE.sendToServer((Object)new UpdateServerBlackboardPacket(this.tileBoard.func_174877_v(), pixels));
    }

    private void close() {
        this.tileBoard.func_70296_d();
        this.field_230706_i_.func_147108_a(null);
    }

    public void setPixel(int x, int y, boolean on) {
        this.tileBoard.pixels[x][y] = (byte)(on ? 1 : 0);
    }

    public void dragButtons(double mx, double my, boolean on) {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                if (!this.buttons[xx][yy].func_231047_b_(mx, my)) continue;
                this.buttons[xx][yy].onDrag(mx, my, on);
            }
        }
    }

    private void clear() {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                this.setPixel(xx, yy, false);
                this.buttons[xx][yy].color = 0;
            }
        }
    }

    protected void func_231160_c_() {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                this.buttons[xx][yy] = new BlackBoardButton(this.field_230708_k_ / 2, 65, xx, yy, this::setPixel, this::dragButtons);
                this.func_230481_d_(this.buttons[xx][yy]);
                this.buttons[xx][yy].color = this.tileBoard.pixels[xx][yy];
            }
        }
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 4 + 120, 96, 20, (ITextComponent)new TranslationTextComponent("gui.supplementaries.blackboard.clear"), b -> this.clear()));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 4, this.field_230709_l_ / 4 + 120, 96, 20, DialogTexts.field_240632_c_, p_238847_1_ -> this.close()));
    }

    public void func_230430_a_(MatrixStack matrixstack, int mouseX, int mouseY, float partialTicks) {
        RenderHelper.func_227783_c_();
        this.func_230446_a_(matrixstack);
        BlackBoardGui.func_238472_a_((MatrixStack)matrixstack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)40, (int)0xFFFFFF);
        matrixstack.func_227860_a_();
        int ut = -1;
        int vt = -1;
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                if (this.buttons[xx][yy].isHovered()) {
                    ut = xx;
                    vt = yy;
                }
                this.buttons[xx][yy].func_230430_a_(matrixstack, mouseX, mouseY, partialTicks);
            }
        }
        if (ut != -1) {
            this.buttons[ut][vt].renderTooltip(matrixstack);
        }
        matrixstack.func_227865_b_();
        RenderHelper.func_227784_d_();
        super.func_230430_a_(matrixstack, mouseX, mouseY, partialTicks);
    }
}

