/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.compat.curios.SupplementariesCuriosPlugin;
import net.mehvahdjukaar.supplementaries.items.KeyItem;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class KeyLockableTile
extends TileEntity {
    public String password = null;

    public KeyLockableTile() {
        super((TileEntityType)ModRegistry.KEY_LOCKABLE_TILE.get());
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPassword(ItemStack stack) {
        this.setPassword(stack.func_200301_q().getString());
    }

    public void clearOwner() {
        this.password = null;
    }

    public static boolean isCorrectKey(ItemStack key, String password) {
        return key.func_200301_q().getString().equals(password);
    }

    public boolean isCorrectKey(ItemStack key) {
        return KeyLockableTile.isCorrectKey(key, this.password);
    }

    public static KeyStatus hasKeyInInventory(PlayerEntity player, String key) {
        KeyStatus found = KeyStatus.INCORRECT_KEY;
        if (CompatHandler.curios && (found = SupplementariesCuriosPlugin.isKeyInCurio(player, key)) == KeyStatus.CORRECT_KEY) {
            return found;
        }
        AtomicReference itemHandler = new AtomicReference();
        player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(itemHandler::set);
        if (itemHandler.get() != null) {
            for (int _idx = 0; _idx < ((IItemHandler)itemHandler.get()).getSlots(); ++_idx) {
                ItemStack stack = ((IItemHandler)itemHandler.get()).getStackInSlot(_idx);
                if (!(stack.func_77973_b() instanceof KeyItem)) continue;
                found = KeyStatus.INCORRECT_KEY;
                if (!KeyLockableTile.isCorrectKey(stack, key)) continue;
                return KeyStatus.CORRECT_KEY;
            }
        }
        return found;
    }

    public static boolean doesPlayerHaveKeyToOpen(PlayerEntity player, String lockPassword, boolean feedbackMessage, @Nullable String translName) {
        KeyStatus key = KeyLockableTile.hasKeyInInventory(player, lockPassword);
        if (key == KeyStatus.INCORRECT_KEY) {
            if (feedbackMessage) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.supplementaries.safe.incorrect_key"), true);
            }
            return false;
        }
        if (key == KeyStatus.CORRECT_KEY) {
            return true;
        }
        if (feedbackMessage) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.supplementaries." + translName + ".locked"), true);
        }
        return false;
    }

    public boolean handleAction(PlayerEntity player, Hand handIn, String translName) {
        if (player.func_175149_v()) {
            return false;
        }
        ItemStack stack = player.func_184586_b(handIn);
        Item item2 = stack.func_77973_b();
        boolean isKey = item2 instanceof KeyItem;
        if (player.func_225608_bj_() && isKey && (player.func_184812_l_() || this.isCorrectKey(stack))) {
            this.clearOwner();
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.supplementaries.safe.cleared"), true);
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187617_cK, SoundCategory.BLOCKS, 0.5f, 1.5f);
            return false;
        }
        if (this.password == null) {
            if (isKey) {
                this.setPassword(stack);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.supplementaries.safe.assigned_key", new Object[]{this.password}), true);
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187617_cK, SoundCategory.BLOCKS, 0.5f, 1.5f);
                return false;
            }
            return true;
        }
        return player.func_184812_l_() || KeyLockableTile.doesPlayerHaveKeyToOpen(player, this.password, true, translName);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("Password")) {
            this.password = compound.func_74779_i("Password");
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.password != null) {
            compound.func_74778_a("Password", this.password);
        }
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public static enum KeyStatus {
        CORRECT_KEY,
        INCORRECT_KEY,
        NO_KEY;

    }
}

