/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.selene.fluids.ISoftFluidConsumer;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.util.Utils;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.HoneyBottleItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class PancakeBlock
extends WaterBlock
implements ISoftFluidConsumer {
    protected static final VoxelShape SHAPE_1 = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    protected static final VoxelShape SHAPE_2 = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    protected static final VoxelShape SHAPE_3 = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    protected static final VoxelShape SHAPE_4 = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    protected static final VoxelShape SHAPE_5 = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    protected static final VoxelShape SHAPE_6 = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    protected static final VoxelShape SHAPE_7 = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    protected static final VoxelShape SHAPE_8 = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final IntegerProperty PANCAKES = BlockProperties.PANCAKES_1_8;
    public static final EnumProperty<BlockProperties.Topping> TOPPING = BlockProperties.TOPPING;

    public PancakeBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)PANCAKES, (Comparable)Integer.valueOf(1))).func_206870_a(TOPPING, (Comparable)((Object)BlockProperties.Topping.NONE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private BlockProperties.Topping getTopping(Item item2) {
        if (item2 instanceof HoneyBottleItem) {
            return BlockProperties.Topping.HONEY;
        }
        if (ModTags.CHOCOLATE_BARS.func_230236_b_().isEmpty() && item2 == Items.field_196130_bo || item2.func_206844_a(ModTags.CHOCOLATE_BARS)) {
            return BlockProperties.Topping.CHOCOLATE;
        }
        if (item2.getRegistryName().toString().equals("autumnity:syrup_bottle")) {
            return BlockProperties.Topping.SYRUP;
        }
        return BlockProperties.Topping.NONE;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(handIn);
        Item item2 = stack.func_77973_b();
        BlockProperties.Topping t = this.getTopping(item2);
        if (t != BlockProperties.Topping.NONE) {
            if (state.func_177229_b(TOPPING) == BlockProperties.Topping.NONE) {
                ItemStack returnItem;
                if (!worldIn.field_72995_K) {
                    worldIn.func_180501_a(pos, (BlockState)state.func_206870_a(TOPPING, (Comparable)((Object)t)), 3);
                    worldIn.func_184133_a(null, pos, SoundEvents.field_226138_eS_, SoundCategory.BLOCKS, 1.0f, 1.2f);
                }
                ItemStack itemStack = returnItem = t == BlockProperties.Topping.CHOCOLATE ? ItemStack.field_190927_a : new ItemStack((IItemProvider)Items.field_151069_bo);
                if (!player.func_184812_l_()) {
                    Utils.swapItem((PlayerEntity)player, (Hand)handIn, (ItemStack)returnItem);
                }
                return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
            }
        } else {
            if (item2 == ModRegistry.PANCAKE_ITEM.get()) {
                return ActionResultType.PASS;
            }
            if (player.func_71043_e(false)) {
                player.func_71024_bL().func_75122_a(1, 0.1f);
                if (!worldIn.field_72995_K) {
                    PancakeBlock.removeLayer(state, pos, worldIn, player);
                    player.func_213823_a(SoundEvents.field_187537_bA, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    return ActionResultType.CONSUME;
                }
                Minecraft.func_71410_x().field_71452_i.func_180533_a(player.func_233580_cy_().func_177981_b(1), state);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public static void removeLayer(BlockState state, BlockPos pos, World world, PlayerEntity player) {
        BlockPos up;
        BlockState upState;
        int i = (Integer)state.func_177229_b((Property)PANCAKES);
        if (i == 8 && (upState = world.func_180495_p(up = pos.func_177984_a())).func_177230_c() == state.func_177230_c()) {
            PancakeBlock.removeLayer(upState, up, world, player);
            return;
        }
        if (i > 1) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)PANCAKES, (Comparable)Integer.valueOf(i - 1)), 3);
        } else {
            world.func_217377_a(pos, false);
        }
        if (state.func_177229_b(TOPPING) != BlockProperties.Topping.NONE) {
            player.func_195064_c(new EffectInstance(Effects.field_76424_c, 160));
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (blockstate.func_203425_a((Block)this)) {
            return (BlockState)blockstate.func_206870_a((Property)PANCAKES, (Comparable)Integer.valueOf(Math.min(8, (Integer)blockstate.func_177229_b((Property)PANCAKES) + 1)));
        }
        boolean flag = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    protected boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return !state.func_196952_d(worldIn, pos).func_212434_a(Direction.UP).func_197766_b() || state.func_224755_d(worldIn, pos, Direction.UP);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return this.isValidGround(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return useContext.func_195996_i().func_77973_b() == this.func_199767_j() && (Integer)state.func_177229_b((Property)PANCAKES) < 8 || super.func_196253_a(state, useContext);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Integer)state.func_177229_b((Property)PANCAKES)) {
            default: {
                return SHAPE_1;
            }
            case 2: {
                return SHAPE_2;
            }
            case 3: {
                return SHAPE_3;
            }
            case 4: {
                return SHAPE_4;
            }
            case 5: {
                return SHAPE_5;
            }
            case 6: {
                return SHAPE_6;
            }
            case 7: {
                return SHAPE_7;
            }
            case 8: 
        }
        return SHAPE_8;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PANCAKES, TOPPING, WATERLOGGED});
    }

    public boolean tryAcceptingFluid(World world, BlockState state, BlockPos pos, SoftFluid f, CompoundNBT nbt, int amount) {
        BlockProperties.Topping topping = BlockProperties.Topping.fromFluid(f);
        if (state.func_177229_b(TOPPING) == BlockProperties.Topping.NONE && topping != BlockProperties.Topping.NONE) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a(TOPPING, (Comparable)((Object)topping)), 2);
            world.func_184133_a(null, pos, SoundEvents.field_226138_eS_, SoundCategory.BLOCKS, 1.0f, 1.2f);
            return true;
        }
        return false;
    }
}

