/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.ellpeck.naturesaura.recipes.ModRecipe;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AnimalSpawnerRecipe
extends ModRecipe {
    public final Ingredient[] ingredients;
    public final EntityType<?> entity;
    public final int aura;
    public final int time;

    public AnimalSpawnerRecipe(ResourceLocation name, EntityType<?> entity, int aura, int time, Ingredient ... ingredients) {
        super(name);
        this.ingredients = ingredients;
        this.entity = entity;
        this.aura = aura;
        this.time = time;
    }

    public Entity makeEntity(World world, BlockPos pos) {
        if (pos == BlockPos.field_177992_a) {
            return this.entity.func_200721_a(world);
        }
        return this.entity.func_220349_b((ServerWorld)world, null, null, null, pos, SpawnReason.SPAWNER, false, false);
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipes.ANIMAL_SPAWNER_SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return ModRecipes.ANIMAL_SPAWNER_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AnimalSpawnerRecipe> {
        public AnimalSpawnerRecipe read(ResourceLocation recipeId, JsonObject json) {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            for (JsonElement e : json.getAsJsonArray("ingredients")) {
                ingredients.add(Ingredient.func_199802_a((JsonElement)e));
            }
            return new AnimalSpawnerRecipe(recipeId, (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(json.get("entity").getAsString())), json.get("aura").getAsInt(), json.get("time").getAsInt(), ingredients.toArray(new Ingredient[0]));
        }

        @Nullable
        public AnimalSpawnerRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient[] ings = new Ingredient[buffer.readInt()];
            for (int i = 0; i < ings.length; ++i) {
                ings[i] = Ingredient.func_199566_b((PacketBuffer)buffer);
            }
            return new AnimalSpawnerRecipe(recipeId, (EntityType)ForgeRegistries.ENTITIES.getValue(buffer.func_192575_l()), buffer.readInt(), buffer.readInt(), ings);
        }

        public void write(PacketBuffer buffer, AnimalSpawnerRecipe recipe) {
            buffer.writeInt(recipe.ingredients.length);
            for (Ingredient ing : recipe.ingredients) {
                ing.func_199564_a(buffer);
            }
            buffer.func_192572_a(recipe.entity.getRegistryName());
            buffer.writeInt(recipe.aura);
            buffer.writeInt(recipe.time);
        }
    }
}

