/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemAuraBottle
extends ItemImpl
implements IColorProvidingItem,
ICustomItemModel {
    public ItemAuraBottle(Item emptyBottle) {
        super("aura_bottle");
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        DispenserBlock.func_199774_a((IItemProvider)emptyBottle, (source, stack) -> {
            ServerWorld world = source.func_197524_h();
            BlockState state = source.func_189992_e();
            Direction facing = (Direction)state.func_177229_b((Property)DispenserBlock.field_176441_a);
            BlockPos offset = source.func_180699_d().func_177972_a(facing);
            BlockState offsetState = world.func_180495_p(offset);
            ItemStack dispense = stack.func_77979_a(1);
            if (offsetState.func_177230_c().isAir(offsetState, (IBlockReader)world, offset) && IAuraChunk.getAuraInArea((IWorld)world, offset, 30) >= 100000) {
                dispense = ItemAuraBottle.setType(new ItemStack((IItemProvider)this), IAuraType.forWorld((IWorld)world));
                BlockPos spot = IAuraChunk.getHighestSpot((IWorld)world, offset, 30, offset);
                IAuraChunk.getAuraChunk((IWorld)world, spot).drainAura(spot, 20000);
            }
            DefaultDispenseItemBehavior.func_82486_a((World)world, (ItemStack)dispense, (int)6, (Direction)facing, (IPosition)DispenserBlock.func_149939_a((IBlockSource)source));
            return stack;
        });
    }

    public static IAuraType getType(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return NaturesAuraAPI.TYPE_OTHER;
        }
        String type = stack.func_77978_p().func_74779_i("stored_type");
        if (type.isEmpty()) {
            return NaturesAuraAPI.TYPE_OTHER;
        }
        return NaturesAuraAPI.AURA_TYPES.get(new ResourceLocation(type));
    }

    public static ItemStack setType(ItemStack stack, IAuraType type) {
        stack.func_196082_o().func_74778_a("stored_type", type.getName().toString());
        return stack;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (IAuraType type : NaturesAuraAPI.AURA_TYPES.values()) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                ItemAuraBottle.setType(stack, type);
                items.add((Object)stack);
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new TranslationTextComponent(stack.func_77977_a() + "." + ItemAuraBottle.getType(stack).getName());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IItemColor getItemColor() {
        return (stack, tintIndex) -> tintIndex > 0 ? ItemAuraBottle.getType(stack).getColor() : 0xFFFFFF;
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/generated")).texture("layer0", "item/" + this.getBaseName())).texture("layer1", "item/" + this.getBaseName() + "_overlay");
    }

    private class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public void onRightClick(PlayerInteractEvent.RightClickItem event) {
            ItemStack held = event.getItemStack();
            if (held.func_190926_b() || held.func_77973_b() != ModItems.BOTTLE_TWO_THE_REBOTTLING) {
                return;
            }
            PlayerEntity player = event.getPlayer();
            BlockRayTraceResult ray = ItemAuraBottle.func_219968_a((World)player.field_70170_p, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
            if (ray.func_216346_c() == RayTraceResult.Type.BLOCK) {
                return;
            }
            BlockPos pos = player.func_233580_cy_();
            if (IAuraChunk.getAuraInArea((IWorld)player.field_70170_p, pos, 30) < 100000) {
                return;
            }
            if (!player.field_70170_p.field_72995_K) {
                held.func_190918_g(1);
                player.field_71071_by.func_70441_a(ItemAuraBottle.setType(new ItemStack((IItemProvider)ItemAuraBottle.this), IAuraType.forWorld((IWorld)player.field_70170_p)));
                BlockPos spot = IAuraChunk.getHighestSpot((IWorld)player.field_70170_p, pos, 30, pos);
                IAuraChunk.getAuraChunk((IWorld)player.field_70170_p, spot).drainAura(spot, 20000);
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187618_I, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            player.func_184609_a(event.getHand());
        }
    }
}

