/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class AngerEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "anger");
    private AxisAlignedBB bb;

    private boolean calcValues(World world, BlockPos pos, Integer spot) {
        if (spot >= 0) {
            return false;
        }
        int aura = IAuraChunk.getAuraInArea((IWorld)world, pos, 50);
        if (aura > 0) {
            return false;
        }
        int dist = Math.min(Math.abs(aura) / 50000, 75);
        if (dist < 10) {
            return false;
        }
        this.bb = new AxisAlignedBB(pos).func_186662_g((double)dist);
        return true;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(PlayerEntity player, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.field_70170_p, pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (!this.bb.func_72318_a(player.func_213303_ch())) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((IItemProvider)Items.field_151059_bz);
    }

    @Override
    public void update(World world, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (world.func_82737_E() % 100L != 0L) {
            return;
        }
        if (!this.calcValues(world, pos, spot)) {
            return;
        }
        List entities = world.func_217357_a(LivingEntity.class, this.bb);
        for (LivingEntity entity : entities) {
            PlayerEntity player;
            if (!(entity instanceof IAngerable) || (player = world.func_217362_a((Entity)entity, 25.0)) == null) continue;
            ((IAngerable)entity).func_70624_b((LivingEntity)player);
        }
    }

    @Override
    public boolean appliesHere(Chunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.angerEffect.get();
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

