/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles.render;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityEnderCrate;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.dispenser.IPosition;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderEnderCrate
extends TileEntityRenderer<TileEntityEnderCrate> {
    private static final Random RANDOM = new Random(31100L);
    private static final List<RenderType> RENDER_TYPES = (List)IntStream.range(0, 16).mapToObj(i -> RenderType.func_228630_a_((int)(i + 1))).collect(ImmutableList.toImmutableList());

    public RenderEnderCrate(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileEntityEnderCrate tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        RANDOM.setSeed(31100L);
        double d0 = tileEntityIn.func_174877_v().func_218138_a((IPosition)this.field_228858_b_.field_217666_g.func_216785_c(), true);
        int i = this.getPasses(d0);
        float f = this.getOffset();
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        this.renderCube(f, 0.15f, matrix4f, bufferIn.getBuffer(RENDER_TYPES.get(0)));
        for (int j = 1; j < i; ++j) {
            this.renderCube(f, 2.0f / (float)(18 - j), matrix4f, bufferIn.getBuffer(RENDER_TYPES.get(j)));
        }
    }

    private void renderCube(float g, float h, Matrix4f mat, IVertexBuilder builder) {
        float f = (RANDOM.nextFloat() * 0.5f + 0.1f) * h;
        float f1 = (RANDOM.nextFloat() * 0.5f + 0.4f) * h;
        float f2 = (RANDOM.nextFloat() * 0.5f + 0.5f) * h;
        this.renderFace(mat, builder, g, g, f, f1, f2);
    }

    private void renderFace(Matrix4f mat, IVertexBuilder builder, float h, float i, float n, float o, float p) {
        builder.func_227888_a_(mat, 0.125f, h, 0.875f).func_227885_a_(n, o, p, 1.0f).func_181675_d();
        builder.func_227888_a_(mat, 0.875f, h, 0.875f).func_227885_a_(n, o, p, 1.0f).func_181675_d();
        builder.func_227888_a_(mat, 0.875f, i, 0.125f).func_227885_a_(n, o, p, 1.0f).func_181675_d();
        builder.func_227888_a_(mat, 0.125f, i, 0.125f).func_227885_a_(n, o, p, 1.0f).func_181675_d();
    }

    protected int getPasses(double dist) {
        int i = dist > 36864.0 ? 1 : (dist > 25600.0 ? 3 : (dist > 16384.0 ? 5 : (dist > 9216.0 ? 7 : (dist > 4096.0 ? 9 : (dist > 1024.0 ? 11 : (dist > 576.0 ? 13 : (dist > 256.0 ? 14 : 15)))))));
        return i;
    }

    protected float getOffset() {
        return 1.001f;
    }
}

