/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.misc.WeatherType;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityWeatherChanger
extends TileEntityImpl
implements ITickableTileEntity {
    private int processTime;
    private WeatherType type;
    private int itemAmount;

    public TileEntityWeatherChanger() {
        super(ModTileEntities.WEATHER_CHANGER);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 10L != 0L) {
                return;
            }
            if (this.processTime <= 0) {
                return;
            }
            int color = this.type == WeatherType.SUN ? 16111426 : (this.type == WeatherType.RAIN ? 5069539 : 3617351);
            for (int r = 0; r < 360; r += 20) {
                double xOff = Math.cos(Math.toRadians(r)) * 3.0;
                double zOff = Math.sin(Math.toRadians(r)) * 3.0;
                for (int i = this.field_145850_b.field_73012_v.nextInt(3); i > 0; --i) {
                    NaturesAuraAPI.instance().spawnMagicParticle((double)((float)this.field_174879_c.func_177958_n() + 0.5f) + xOff, this.field_174879_c.func_177956_o(), (double)((float)this.field_174879_c.func_177952_p() + 0.5f) + zOff, this.field_145850_b.field_73012_v.nextGaussian() * (double)0.02f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.1f, this.field_145850_b.field_73012_v.nextGaussian() * (double)0.02f, color, this.field_145850_b.field_73012_v.nextFloat() * 2.0f + 1.0f, this.field_145850_b.field_73012_v.nextInt(80) + 80, 0.0f, false, true);
                }
            }
            return;
        }
        if (this.processTime > 0) {
            if (this.processTime % 20 == 0) {
                BlockPos spot = IAuraChunk.getHighestSpot((IWorld)this.field_145850_b, this.field_174879_c, 35, this.field_174879_c);
                IAuraChunk.getAuraChunk((IWorld)this.field_145850_b, spot).drainAura(spot, 30000 * this.itemAmount);
            }
            --this.processTime;
            if (this.processTime <= 0) {
                this.sendToClients();
                int time = 6000 * this.itemAmount;
                ServerWorld server = (ServerWorld)this.field_145850_b;
                switch (this.type) {
                    case SUN: {
                        server.func_241113_a_(time, 0, false, false);
                        break;
                    }
                    case RAIN: {
                        server.func_241113_a_(0, time, true, false);
                        break;
                    }
                    case THUNDERSTORM: {
                        server.func_241113_a_(0, time, true, true);
                    }
                }
            }
        } else {
            if (this.field_145850_b.func_82737_E() % 20L != 0L) {
                return;
            }
            Pair<WeatherType, Integer> type = this.getNextWeatherType();
            if (type == null) {
                return;
            }
            this.type = (WeatherType)((Object)type.getLeft());
            this.itemAmount = (Integer)type.getRight();
            this.processTime = 100;
            this.sendToClients();
        }
    }

    @Override
    public void writeNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            compound.func_74768_a("time", this.processTime);
            if (this.type != null) {
                compound.func_74768_a("weather", this.type.ordinal());
            }
            compound.func_74768_a("amount", this.itemAmount);
        }
    }

    @Override
    public void readNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            this.processTime = compound.func_74762_e("time");
            this.type = WeatherType.values()[compound.func_74762_e("weather")];
            this.itemAmount = compound.func_74762_e("amount");
        }
    }

    private Pair<WeatherType, Integer> getNextWeatherType() {
        AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c).func_186662_g(2.0);
        List items = this.field_145850_b.func_175647_a(ItemEntity.class, area, EntityPredicates.field_94557_a);
        for (ItemEntity entity : items) {
            if (entity.func_174874_s()) continue;
            ItemStack stack = entity.func_92059_d();
            for (Map.Entry<ItemStack, WeatherType> entry : NaturesAuraAPI.WEATHER_CHANGER_CONVERSIONS.entrySet()) {
                if (!Helper.areItemsEqual(stack, entry.getKey(), true)) continue;
                entity.func_92058_a(ItemStack.field_190927_a);
                entity.func_70106_y();
                return Pair.of((Object)((Object)entry.getValue()), (Object)stack.func_190916_E());
            }
        }
        return null;
    }
}

