/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.misc.IWorldData;
import de.ellpeck.naturesaura.blocks.BlockEnderCrate;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.gui.ContainerEnderCrate;
import de.ellpeck.naturesaura.gui.ModContainers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityEnderCrate
extends TileEntityImpl
implements INamedContainerProvider {
    public String name;
    private final IItemHandlerModifiable wrappedEnderStorage = new IItemHandlerModifiable(){

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.getStorage().setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.getStorage().getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.getStorage().getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemStack remain = this.getStorage().insertItem(slot, stack, simulate);
            if (!simulate) {
                TileEntityEnderCrate.this.drainAura((stack.func_190916_E() - remain.func_190916_E()) * 20);
            }
            return remain;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack extracted = this.getStorage().extractItem(slot, amount, simulate);
            if (!simulate) {
                TileEntityEnderCrate.this.drainAura(extracted.func_190916_E() * 20);
            }
            return extracted;
        }

        public int getSlotLimit(int slot) {
            return this.getStorage().getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.getStorage().isItemValid(slot, stack);
        }

        private IItemHandlerModifiable getStorage() {
            return IWorldData.getOverworldData(TileEntityEnderCrate.this.field_145850_b).getEnderStorage(TileEntityEnderCrate.this.name);
        }
    };

    public TileEntityEnderCrate() {
        super(ModTileEntities.ENDER_CRATE);
    }

    @Override
    public IItemHandlerModifiable getItemHandler() {
        if (this.canOpen()) {
            return this.wrappedEnderStorage;
        }
        return null;
    }

    public boolean canOpen() {
        return this.name != null;
    }

    @Override
    public void dropInventory() {
    }

    @Override
    public void modifyDrop(ItemStack regularItem) {
        if (this.name != null) {
            if (!regularItem.func_77942_o()) {
                regularItem.func_77982_d(new CompoundNBT());
            }
            regularItem.func_77978_p().func_74778_a("naturesaura:ender_name", this.name);
        }
    }

    @Override
    public void loadDataOnPlace(ItemStack stack) {
        String name;
        super.loadDataOnPlace(stack);
        if (!this.field_145850_b.field_72995_K && (name = BlockEnderCrate.getEnderName(stack)) != null && !name.isEmpty()) {
            this.name = name;
        }
    }

    @Override
    public void writeNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK && this.name != null) {
            compound.func_74778_a("name", this.name);
        }
    }

    @Override
    public void readNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK && compound.func_74764_b("name")) {
            this.name = compound.func_74779_i("name");
        }
    }

    public void drainAura(int amount) {
        if (amount > 0) {
            BlockPos spot = IAuraChunk.getHighestSpot((IWorld)this.field_145850_b, this.field_174879_c, 35, this.field_174879_c);
            IAuraChunk.getAuraChunk((IWorld)this.field_145850_b, spot).drainAura(spot, amount);
        }
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("info.naturesaura.ender_crate", new Object[]{TextFormatting.ITALIC + this.name + TextFormatting.RESET});
    }

    @Nullable
    public Container createMenu(int window, PlayerInventory inv, PlayerEntity player) {
        return new ContainerEnderCrate(ModContainers.ENDER_CRATE, window, player, (IItemHandler)this.getItemHandler());
    }
}

