/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.TileEntitySlimeSplitGenerator;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockSlimeSplitGenerator
extends BlockContainerImpl
implements IVisualizable,
ICustomBlockState {
    public BlockSlimeSplitGenerator() {
        super("slime_split_generator", TileEntitySlimeSplitGenerator::new, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_180399_cE).func_200943_b(2.0f));
        MinecraftForge.EVENT_BUS.register((Object)new Events());
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().cubeBottomTop(this.getBaseName(), generator.modLoc("block/" + this.getBaseName()), generator.modLoc("block/" + this.getBaseName() + "_bottom"), generator.modLoc("block/" + this.getBaseName() + "_top")));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getVisualizationBounds(World world, BlockPos pos) {
        return new AxisAlignedBB(pos).func_186662_g(8.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getVisualizationColor(World world, BlockPos pos) {
        return 5089359;
    }

    private static class Events {
        private Events() {
        }

        @SubscribeEvent
        public void onLivingDeath(LivingDeathEvent event) {
            LivingEntity entity = event.getEntityLiving();
            if (!(entity instanceof SlimeEntity) || entity.field_70170_p.field_72995_K) {
                return;
            }
            SlimeEntity slime = (SlimeEntity)entity;
            int size = slime.func_70809_q();
            if (size <= 1) {
                return;
            }
            Helper.getTileEntitiesInArea((IWorld)entity.field_70170_p, entity.func_233580_cy_(), 8, tile -> {
                if (!(tile instanceof TileEntitySlimeSplitGenerator)) {
                    return false;
                }
                TileEntitySlimeSplitGenerator gen = (TileEntitySlimeSplitGenerator)((Object)tile);
                if (gen.isBusy()) {
                    return false;
                }
                gen.startGenerating(slime);
                return true;
            });
        }
    }
}

