/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityProjectileGenerator;
import de.ellpeck.naturesaura.blocks.tiles.render.RenderProjectileGenerator;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ITESRProvider;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class BlockProjectileGenerator
extends BlockContainerImpl
implements ITESRProvider<TileEntityProjectileGenerator>,
ICustomBlockState {
    public BlockProjectileGenerator() {
        super("projectile_generator", TileEntityProjectileGenerator::new, AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(2.5f).func_200947_a(SoundType.field_185851_d));
        MinecraftForge.EVENT_BUS.register((Object)this);
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151079_bi, (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            protected ProjectileEntity func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EnderPearlEntity ret = new EnderPearlEntity(EntityType.field_200752_ar, worldIn);
                ret.func_70107_b(position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                return ret;
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Items.field_203184_eO, (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            protected ProjectileEntity func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                TridentEntity ret = new TridentEntity(EntityType.field_203098_aL, worldIn);
                ret.func_70107_b(position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                ObfuscationReflectionHelper.setPrivateValue(TridentEntity.class, (Object)ret, (Object)stackIn.func_77946_l(), (String)"field_203054_h");
                ret.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
                return ret;
            }
        });
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        Entity entity = event.getEntity();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        RayTraceResult ray = event.getRayTraceResult();
        if (!(ray instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult blockRay = (BlockRayTraceResult)ray;
        BlockPos pos = blockRay.func_216350_a();
        if (pos == null) {
            return;
        }
        TileEntity tile = entity.field_70170_p.func_175625_s(pos);
        if (!(tile instanceof TileEntityProjectileGenerator)) {
            return;
        }
        TileEntityProjectileGenerator generator = (TileEntityProjectileGenerator)tile;
        if (generator.nextSide != blockRay.func_216354_b()) {
            return;
        }
        Integer amount = NaturesAuraAPI.PROJECTILE_GENERATIONS.get(entity.func_200600_R());
        if (amount == null || amount <= 0) {
            return;
        }
        if (!generator.canGenerateRightNow(amount)) {
            return;
        }
        generator.generateAura(amount);
        PacketHandler.sendToAllAround(entity.field_70170_p, pos, 32, new PacketParticles((float)entity.func_226277_ct_(), (float)entity.func_226278_cu_(), (float)entity.func_226281_cx_(), PacketParticles.Type.PROJECTILE_GEN, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        entity.field_70170_p.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187528_aR, SoundCategory.BLOCKS, 0.8f, 1.0f);
        generator.nextSide = generator.nextSide.func_176746_e();
        generator.sendToClients();
        entity.func_70106_y();
        event.setCanceled(true);
    }

    @Override
    public Tuple<TileEntityType<TileEntityProjectileGenerator>, Supplier<Function<? super TileEntityRendererDispatcher, ? extends TileEntityRenderer<? super TileEntityProjectileGenerator>>>> getTESR() {
        return new Tuple(ModTileEntities.PROJECTILE_GENERATOR, () -> RenderProjectileGenerator::new);
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().cubeBottomTop(this.getBaseName(), generator.modLoc("block/" + this.getBaseName()), generator.modLoc("block/" + this.getBaseName() + "_top"), generator.modLoc("block/" + this.getBaseName() + "_top")));
    }
}

