/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render.debugging;

import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.util.inventory.MultiFluidTank;
import com.mojang.blaze3d.matrix.MatrixStack;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.CokerUnitTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.DistillationTowerTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.HydrotreaterTileEntity;
import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class DebugRenderHandler {
    private boolean isHoldingDebugItem(PlayerEntity player) {
        ItemStack main = player.func_184586_b(Hand.MAIN_HAND);
        ItemStack off = player.func_184586_b(Hand.OFF_HAND);
        return main != ItemStack.field_190927_a && main.func_77973_b() == IPContent.debugItem || off != ItemStack.field_190927_a && off.func_77973_b() == IPContent.debugItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void renderDebuggingOverlay(RenderGameOverlayEvent.Post event) {
        RayTraceResult rt;
        ClientPlayerEntity player;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && event.getType() == RenderGameOverlayEvent.ElementType.TEXT && this.isHoldingDebugItem((PlayerEntity)(player = mc.field_71439_g)) && (rt = mc.field_71476_x) != null) {
            switch (rt.func_216346_c()) {
                case BLOCK: {
                    BlockRayTraceResult result = (BlockRayTraceResult)rt;
                    World world = player.field_70170_p;
                    ArrayList<ITextComponent> debugOut = new ArrayList<ITextComponent>();
                    TileEntity te = world.func_175625_s(result.func_216350_a());
                    boolean isMBPart = te instanceof MultiblockPartTileEntity;
                    if (isMBPart) {
                        MultiblockPartTileEntity multiblock = (MultiblockPartTileEntity)te;
                        if (!multiblock.offsetToMaster.equals((Object)BlockPos.field_177992_a)) {
                            multiblock = multiblock.master();
                        }
                        if (te instanceof DistillationTowerTileEntity) {
                            DebugRenderHandler.distillationtower(debugOut, (DistillationTowerTileEntity)multiblock);
                        } else if (te instanceof CokerUnitTileEntity) {
                            DebugRenderHandler.cokerunit(debugOut, (CokerUnitTileEntity)multiblock);
                        } else if (te instanceof HydrotreaterTileEntity) {
                            DebugRenderHandler.hydrotreater(debugOut, (HydrotreaterTileEntity)multiblock);
                        }
                    }
                    if (debugOut.isEmpty() && !isMBPart) break;
                    if (isMBPart) {
                        MultiblockPartTileEntity generic = (MultiblockPartTileEntity)te;
                        BlockPos tPos = generic.posInMultiblock;
                        if (!generic.offsetToMaster.equals((Object)BlockPos.field_177992_a)) {
                            generic = generic.master();
                        }
                        BlockPos hit = result.func_216350_a();
                        Block block = generic.func_195044_w().func_177230_c();
                        debugOut.add(0, (ITextComponent)DebugRenderHandler.toText("World XYZ: " + hit.func_177958_n() + ", " + hit.func_177956_o() + ", " + hit.func_177952_p()));
                        debugOut.add(1, (ITextComponent)DebugRenderHandler.toText("Template XYZ: " + tPos.func_177958_n() + ", " + tPos.func_177956_o() + ", " + tPos.func_177952_p()));
                        IFormattableTextComponent name = DebugRenderHandler.toTranslation(block.func_149739_a(), new Object[0]).func_240699_a_(TextFormatting.GOLD);
                        try {
                            name.func_230529_a_((ITextComponent)DebugRenderHandler.toText(generic.isRSDisabled() ? " (Redstoned)" : "").func_240699_a_(TextFormatting.RED));
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            // empty catch block
                        }
                        if (generic instanceof PoweredMultiblockTileEntity) {
                            PoweredMultiblockTileEntity poweredGeneric = (PoweredMultiblockTileEntity)generic;
                            name.func_230529_a_((ITextComponent)DebugRenderHandler.toText(poweredGeneric.shouldRenderAsActive() ? " (Active)" : "").func_240699_a_(TextFormatting.GREEN));
                            debugOut.add(2, (ITextComponent)DebugRenderHandler.toText(poweredGeneric.energyStorage.getEnergyStored() + "/" + poweredGeneric.energyStorage.getMaxEnergyStored() + "RF"));
                        }
                        List<LubricatedHandler.LubricatedTileInfo> list = LubricatedHandler.lubricatedTiles;
                        synchronized (list) {
                            for (LubricatedHandler.LubricatedTileInfo info : LubricatedHandler.lubricatedTiles) {
                                if (!info.pos.equals((Object)generic.func_174877_v())) continue;
                                name.func_230529_a_((ITextComponent)DebugRenderHandler.toText(" (Lubricated " + info.ticks + ")").func_240699_a_(TextFormatting.YELLOW));
                            }
                        }
                        debugOut.add(2, (ITextComponent)name);
                    }
                    DebugRenderHandler.renderOverlay(event.getMatrixStack(), debugOut);
                    break;
                }
                case ENTITY: {
                    EntityRayTraceResult result = (EntityRayTraceResult)rt;
                    if (!(result.func_216348_a() instanceof MotorboatEntity)) break;
                    MotorboatEntity boat = (MotorboatEntity)result.func_216348_a();
                    ArrayList<ITextComponent> debugOut = new ArrayList<ITextComponent>();
                    debugOut.add((ITextComponent)DebugRenderHandler.toText("").func_230529_a_(boat.func_145748_c_()).func_240699_a_(TextFormatting.GOLD));
                    FluidStack fluid = boat.getContainedFluid();
                    if (fluid == FluidStack.EMPTY) {
                        debugOut.add((ITextComponent)DebugRenderHandler.toText("Tank: Empty"));
                    } else {
                        debugOut.add((ITextComponent)DebugRenderHandler.toText("Tank: " + fluid.getAmount() + "/" + boat.getMaxFuel() + "mB of ").func_230529_a_(fluid.getDisplayName()));
                    }
                    NonNullList<ItemStack> upgrades = boat.getUpgrades();
                    int i = 0;
                    for (ItemStack upgrade : upgrades) {
                        if (upgrade == null || upgrade == ItemStack.field_190927_a) {
                            debugOut.add((ITextComponent)DebugRenderHandler.toText("Upgrade " + ++i + ": Empty"));
                            continue;
                        }
                        debugOut.add((ITextComponent)DebugRenderHandler.toText("Upgrade " + ++i + ": ").func_230529_a_(upgrade.func_200301_q()));
                    }
                    DebugRenderHandler.renderOverlay(event.getMatrixStack(), debugOut);
                    break;
                }
            }
        }
    }

    private static void renderOverlay(MatrixStack matrix, List<ITextComponent> debugOut) {
        Minecraft mc = Minecraft.func_71410_x();
        matrix.func_227860_a_();
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        for (int i = 0; i < debugOut.size(); ++i) {
            int w = mc.field_71466_p.func_78256_a(debugOut.get(i).getString());
            mc.field_71466_p.getClass();
            int yOff = i * (9 + 2);
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, 0.0, 1.0);
            GuiHelper.drawColouredRect((int)1, (int)(1 + yOff), (int)(w + 1), (int)10, (int)-1358954496, (IRenderTypeBuffer)buffer, (MatrixStack)matrix);
            buffer.func_228461_a_();
            mc.field_71466_p.func_243248_b(matrix, debugOut.get(i), 2.0f, (float)(2 + yOff), -1);
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
    }

    private static void distillationtower(List<ITextComponent> text, DistillationTowerTileEntity tower) {
        for (int i = 0; i < tower.tanks.length; ++i) {
            text.add((ITextComponent)DebugRenderHandler.toText("Tank " + (i + 1)).func_240699_a_(TextFormatting.UNDERLINE));
            MultiFluidTank tank = tower.tanks[i];
            if (tank.fluids.size() > 0) {
                for (int j = 0; j < tank.fluids.size(); ++j) {
                    FluidStack fstack = (FluidStack)tank.fluids.get(j);
                    text.add((ITextComponent)DebugRenderHandler.toText("  " + fstack.getDisplayName().getString() + " (" + fstack.getAmount() + "mB)"));
                }
                continue;
            }
            text.add((ITextComponent)DebugRenderHandler.toText("  Empty"));
        }
    }

    private static void cokerunit(List<ITextComponent> text, CokerUnitTileEntity coker) {
        FluidTank tank = coker.bufferTanks[0];
        FluidStack fs = tank.getFluid();
        text.add((ITextComponent)DebugRenderHandler.toText("In Buffer: " + fs.getAmount() + "/" + tank.getCapacity() + "mB " + (fs.isEmpty() ? "" : "(" + fs.getDisplayName().getString() + ")")));
        tank = coker.bufferTanks[1];
        fs = tank.getFluid();
        text.add((ITextComponent)DebugRenderHandler.toText("Out Buffer: " + fs.getAmount() + "/" + tank.getCapacity() + "mB " + (fs.isEmpty() ? "" : "(" + fs.getDisplayName().getString() + ")")));
        for (int i = 0; i < coker.chambers.length; ++i) {
            CokerUnitTileEntity.CokingChamber chamber = coker.chambers[i];
            FluidTank tank2 = chamber.getTank();
            FluidStack fs2 = tank2.getFluid();
            float completed = chamber.getTotalAmount() > 0 ? 100.0f * ((float)chamber.getOutputAmount() / (float)chamber.getTotalAmount()) : 0.0f;
            text.add((ITextComponent)DebugRenderHandler.toText("Chamber " + i).func_240701_a_(new TextFormatting[]{TextFormatting.UNDERLINE, TextFormatting.AQUA}));
            text.add((ITextComponent)DebugRenderHandler.toText("State: " + chamber.getState().toString()));
            text.add((ITextComponent)DebugRenderHandler.toText("  Tank: " + fs2.getAmount() + "/" + tank2.getCapacity() + "mB " + (fs2.isEmpty() ? "" : "(" + fs2.getDisplayName().getString() + ")")));
            text.add((ITextComponent)DebugRenderHandler.toText("  Content: " + chamber.getTotalAmount() + " / " + chamber.getCapacity()).func_240702_b_(" (" + chamber.getInputItem().func_200301_q().getString() + ")"));
            text.add((ITextComponent)DebugRenderHandler.toText("  Out: " + chamber.getOutputItem().func_200301_q().getString()));
            text.add((ITextComponent)DebugRenderHandler.toText("  " + MathHelper.func_76141_d((float)completed) + "% Completed. (Raw: " + completed + ")"));
        }
    }

    private static void hydrotreater(List<ITextComponent> text, HydrotreaterTileEntity treater) {
        IFluidTank[] tanks = treater.getInternalTanks();
        if (tanks != null && tanks.length > 0) {
            for (int i = 0; i < tanks.length; ++i) {
                FluidStack fs = tanks[i].getFluid();
                text.add((ITextComponent)DebugRenderHandler.toText("Tank " + i + ": " + fs.getAmount() + "/" + tanks[i].getCapacity() + "mB " + (fs.isEmpty() ? "" : "(" + fs.getDisplayName().getString() + ")")));
            }
        }
    }

    static IFormattableTextComponent toText(String string) {
        return new StringTextComponent(string);
    }

    static IFormattableTextComponent toTranslation(String translationKey, Object ... args) {
        return new TranslationTextComponent(translationKey, args);
    }
}

