/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.ITag;
import org.apache.commons.lang3.tuple.Pair;

public class LubricantHandler {
    static final Set<Pair<ITag<Fluid>, Integer>> lubricants = new HashSet<Pair<ITag<Fluid>, Integer>>();

    public static void registerLubricant(Fluid lube, int amount) {
        ImmersivePetroleum.log.warn("LubricantHandler skipped adding \"" + lube.getRegistryName() + "\". Please use the FluidTag registration!");
    }

    public static void register(@Nonnull ITag<Fluid> fluid, int amount) {
        if (fluid != null && !lubricants.stream().anyMatch(pair -> pair.getLeft() == fluid)) {
            lubricants.add((Pair<ITag<Fluid>, Integer>)Pair.of(fluid, (Object)amount));
        }
    }

    public static int getLubeAmount(@Nonnull Fluid toCheck) {
        if (toCheck != null) {
            for (Map.Entry entry : lubricants) {
                if (!((ITag)entry.getKey()).func_230235_a_((Object)toCheck)) continue;
                return (Integer)entry.getValue();
            }
        }
        return 0;
    }

    public static boolean isValidLube(@Nonnull Fluid toCheck) {
        return toCheck != null && lubricants.stream().anyMatch(pair -> ((ITag)pair.getKey()).func_230235_a_((Object)toCheck));
    }
}

