/*
 * Decompiled with CFR 0.152.
 */
package cofh.omgourd.event;

import cofh.lib.item.impl.KnifeItem;
import cofh.lib.util.Utils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="omgourd")
public class CommonEvents {
    private static final Object2ObjectOpenHashMap<Block, Block> CARVE_PREV_MAP = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<Block, Block> CARVE_NEXT_MAP = new Object2ObjectOpenHashMap();

    private CommonEvents() {
    }

    public static boolean registerPrev(Block block, Block prevBlock) {
        if (block instanceof CarvedPumpkinBlock && prevBlock instanceof CarvedPumpkinBlock) {
            CARVE_PREV_MAP.put((Object)block, (Object)prevBlock);
            return true;
        }
        return false;
    }

    public static boolean registerNext(Block block, Block nextBlock) {
        if (block instanceof CarvedPumpkinBlock && nextBlock instanceof CarvedPumpkinBlock) {
            CARVE_NEXT_MAP.put((Object)block, (Object)nextBlock);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void handlePlayerRightClickEvent(PlayerInteractEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event instanceof PlayerInteractEvent.RightClickBlock)) {
            return;
        }
        World world = event.getWorld();
        Direction face = event.getFace();
        if (face == null) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        BlockPos pos = event.getPos();
        Block block = world.func_180495_p(pos).func_177230_c();
        ItemStack heldStack = player.func_184586_b(event.getHand());
        if (heldStack.func_77973_b() instanceof ShearsItem || heldStack.func_77973_b() instanceof KnifeItem) {
            Block newBlock;
            Block block2 = newBlock = player.func_226563_dT_() ? (Block)CARVE_PREV_MAP.get((Object)block) : (Block)CARVE_NEXT_MAP.get((Object)block);
            if (newBlock != null) {
                if (Utils.isClientWorld((World)world)) {
                    player.func_184609_a(event.getHand());
                } else {
                    Direction newDir = face.func_176740_k() == Direction.Axis.Y ? player.func_174811_aO().func_176734_d() : face;
                    world.func_180501_a(pos, (BlockState)newBlock.func_176223_P().func_206870_a((Property)CarvedPumpkinBlock.field_196359_a, (Comparable)newDir), 11);
                }
            }
        }
    }
}

