/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.stonecutter;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.StonecuttingRecipe;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.BackpackWidget;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.stonecutter.StonecutterRecipeContainer;

public class StonecutterRecipeControl
extends BackpackWidget {
    private static final TextureBlitData SLIDER = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 131), Dimension.RECTANGLE_12_15);
    private static final TextureBlitData DISABLED_SLIDER = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(41, 131), Dimension.RECTANGLE_12_15);
    private static final TextureBlitData RECIPE_BACKGROUND = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(110, 148), Dimension.RECTANGLE_16_18);
    private static final TextureBlitData SELECTED_RECIPE_BACKGROUND = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(110, 166), Dimension.RECTANGLE_16_18);
    private static final TextureBlitData RECIPE_BACKGROUND_HOVERED = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(110, 184), Dimension.RECTANGLE_16_18);
    private static final TextureBlitData LIST_BACKGROUND = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 146), new Dimension(81, 56));
    private static final int LIST_Y_OFFSET = 22;
    private static final int INPUT_SLOT_HEIGHT = 18;
    private static final int SPACING = 4;
    private boolean clickedOnScroll;
    private final BackpackScreen screen;
    private final StonecutterRecipeContainer container;
    private boolean hasItemsInInputSlot;
    private int recipeIndexOffset;
    private float sliderProgress;

    protected StonecutterRecipeControl(BackpackScreen screen, StonecutterRecipeContainer container, Position position) {
        super(position);
        this.screen = screen;
        this.container = container;
        container.setInventoryUpdateListener(this::onInventoryUpdate);
        this.onInventoryUpdate();
    }

    public void moveSlotsToView() {
        Slot inputSlot = this.container.getInputSlot();
        inputSlot.field_75223_e = this.x + this.getCenteredX(16) - this.screen.getGuiLeft();
        inputSlot.field_75221_f = this.y - this.screen.getGuiTop() + 1;
        Slot outputSlot = this.container.getOutputSlot();
        outputSlot.field_75223_e = this.x + this.getCenteredX(16) - this.screen.getGuiLeft();
        outputSlot.field_75221_f = inputSlot.field_75221_f + 18 + 4 + LIST_BACKGROUND.getHeight() + 4 + 4;
    }

    @Override
    protected void renderBg(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        GuiHelper.renderSlotsBackground(minecraft, matrixStack, this.x + this.getCenteredX(18), this.y, 1, 1);
        GuiHelper.blit(minecraft, matrixStack, this.x, this.y + 22, LIST_BACKGROUND);
        GuiHelper.blit(minecraft, matrixStack, this.x + this.getCenteredX(26), this.y + 18 + 4 + LIST_BACKGROUND.getHeight() + 4, GuiHelper.CRAFTING_RESULT_SLOT);
        int sliderYOffset = (int)(39.0f * this.sliderProgress) + 1;
        GuiHelper.blit(minecraft, matrixStack, this.x + 68, this.y + 22 + sliderYOffset, this.canScroll() ? SLIDER : DISABLED_SLIDER);
        int listInnerLeftX = this.x + 1;
        int listTopY = this.getListTopY();
        int recipeIndexOffsetMax = this.recipeIndexOffset + 12;
        this.renderRecipeBackgrounds(matrixStack, mouseX, mouseY, listInnerLeftX, listTopY, recipeIndexOffsetMax);
        this.drawRecipesItems(matrixStack, listInnerLeftX, listTopY, recipeIndexOffsetMax);
    }

    private void drawRecipesItems(MatrixStack matrixStack, int listInnerLeftX, int top, int recipeIndexOffsetMax) {
        List<StonecuttingRecipe> list = this.container.getRecipeList();
        for (int i = this.recipeIndexOffset; i < recipeIndexOffsetMax && i < this.container.getRecipeList().size(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = listInnerLeftX + j % 4 * 16;
            int l = j / 4;
            int i1 = top + l * 18 + 2;
            GuiHelper.renderItemInGUI(matrixStack, this.minecraft, list.get(i).func_77571_b(), k, i1);
        }
    }

    private int getListTopY() {
        return this.y + 22;
    }

    private void renderRecipeBackgrounds(MatrixStack matrixStack, int mouseX, int mouseY, int listInnerLeftX, int listTopY, int recipeIndexOffsetMax) {
        for (int recipeIndex = this.recipeIndexOffset; recipeIndex < recipeIndexOffsetMax && recipeIndex < this.container.getRecipeList().size(); ++recipeIndex) {
            int j = recipeIndex - this.recipeIndexOffset;
            int recipeX = listInnerLeftX + j % 4 * 16;
            int row = j / 4;
            int recipeY = listTopY + row * 18 + 2;
            TextureBlitData background = RECIPE_BACKGROUND;
            if (recipeIndex == this.container.getSelectedRecipe()) {
                background = SELECTED_RECIPE_BACKGROUND;
            } else if (mouseX >= recipeX && mouseY >= recipeY && mouseX < recipeX + 16 && mouseY < recipeY + 18) {
                background = RECIPE_BACKGROUND_HOVERED;
            }
            GuiHelper.blit(this.minecraft, matrixStack, recipeX, recipeY - 1, background);
        }
    }

    private boolean canScroll() {
        return this.hasItemsInInputSlot && this.container.getRecipeList().size() > 12;
    }

    @Override
    protected void renderWidget(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void afterScreenRender(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.afterScreenRender(matrixStack, mouseX, mouseY, partialTicks);
        this.renderHoveredTooltip(matrixStack, mouseX, mouseY);
    }

    private void renderHoveredTooltip(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.hasItemsInInputSlot) {
            int listTopY = this.getListTopY();
            int k = this.recipeIndexOffset + 12;
            List<StonecuttingRecipe> list = this.container.getRecipeList();
            for (int recipeIndex = this.recipeIndexOffset; recipeIndex < k && recipeIndex < list.size(); ++recipeIndex) {
                int inviewRecipeIndex = recipeIndex - this.recipeIndexOffset;
                int recipeLeftX = this.x + inviewRecipeIndex % 4 * 16;
                int k1 = listTopY + inviewRecipeIndex / 4 * 18 + 2;
                if (mouseX < recipeLeftX || mouseX >= recipeLeftX + 16 || mouseY < k1 || mouseY >= k1 + 18) continue;
                this.renderTooltip(matrixStack, list.get(recipeIndex).func_77571_b(), mouseX, mouseY);
            }
        }
    }

    private void renderTooltip(MatrixStack matrixStack, ItemStack itemStack, int mouseX, int mouseY) {
        FontRenderer font = itemStack.func_77973_b().getFontRenderer(itemStack);
        GuiUtils.preItemToolTip((ItemStack)itemStack);
        this.screen.renderWrappedToolTip(matrixStack, this.screen.func_231151_a_(itemStack), mouseX, mouseY, font == null ? this.font : font);
        GuiUtils.postItemToolTip();
    }

    private void onInventoryUpdate() {
        this.hasItemsInInputSlot = this.container.hasItemsInInputSlot();
        if (!this.hasItemsInInputSlot) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        } else if (this.container.getSelectedRecipe() - this.recipeIndexOffset >= 12) {
            int rowsToScroll = (this.container.getSelectedRecipe() - this.recipeIndexOffset - 12) / 4 + 1;
            this.scrollRecipesByDelta(-rowsToScroll);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.clickedOnScroll = false;
        if (this.hasItemsInInputSlot) {
            int listInnerLeftX = this.x + 1;
            int listInnerTopY = this.y + 22 + 1;
            int maxRecipeIndexOffset = this.recipeIndexOffset + 12;
            for (int recipeIndex = this.recipeIndexOffset; recipeIndex < maxRecipeIndexOffset; ++recipeIndex) {
                int visibleRecipeIndex = recipeIndex - this.recipeIndexOffset;
                double relativeX = mouseX - (double)(listInnerLeftX + visibleRecipeIndex % 4 * 16);
                double relativeY = mouseY - (double)(listInnerTopY + Math.floorDiv(visibleRecipeIndex, 4) * 18);
                if (!(relativeX >= 0.0) || !(relativeY >= 0.0) || !(relativeX < 16.0) || !(relativeY < 18.0) || !this.container.selectRecipe(recipeIndex)) continue;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219720_mm, (float)1.0f));
                return true;
            }
            int sliderLeftX = listInnerLeftX + 67;
            if (mouseX >= (double)sliderLeftX && mouseX < (double)(sliderLeftX + 12) && mouseY >= (double)listInnerTopY && mouseY < (double)(listInnerTopY + 54)) {
                this.clickedOnScroll = true;
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.clickedOnScroll && this.canScroll()) {
            int listTopY = this.y + 22;
            int listBottomY = listTopY + 54;
            this.sliderProgress = ((float)mouseY - (float)listTopY - 7.5f) / ((float)(listBottomY - listTopY) - 15.0f);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (this.canScroll()) {
            this.scrollRecipesByDelta(delta);
        }
        return true;
    }

    private void scrollRecipesByDelta(double delta) {
        int i = this.getHiddenRows();
        this.sliderProgress = (float)((double)this.sliderProgress - delta / (double)i);
        this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
        this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)i) + 0.5) * 4;
    }

    protected int getHiddenRows() {
        return (this.container.getRecipeList().size() + 4 - 1) / 4 - 3;
    }

    @Override
    public int getWidth() {
        return 81;
    }

    @Override
    public int getHeight() {
        return 108;
    }
}

