/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common.gui;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntComparators;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IOverflowResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackAccessLogger;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackSettingsManager;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackSettingsHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackUpgradeHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.NoopBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackBackgroundProperties;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackInventorySlot;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.HighStackCountListener;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.IFilterSlot;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.SettingsContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerRegistry;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackContentsMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SyncContainerClientDataMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.ISlotColorCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.backpack.BackpackSettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.nosort.NoSortSettingsCategory;

public class BackpackContainer
extends Container
implements ISyncedContainer {
    public static final ResourceLocation EMPTY_UPGRADE_SLOT_BACKGROUND = new ResourceLocation("sophisticatedbackpacks", "item/empty_upgrade_slot");
    private static final int NUMBER_OF_PLAYER_SLOTS = 36;
    private static final String OPEN_TAB_ID_TAG = "openTabId";
    private static final String SORT_BY_TAG = "sortBy";
    private static final String UPGRADE_ENABLED_TAG = "upgradeEnabled";
    private static final String UPGRADE_SLOT_TAG = "upgradeSlot";
    private static final String ACTION_TAG = "action";
    private final IBackpackWrapper backpackWrapper;
    private final PlayerEntity player;
    private int backpackSlotNumber = -1;
    private final BackpackContext backpackContext;
    private final Map<Integer, UpgradeContainerBase<?, ?>> upgradeContainers = new LinkedHashMap();
    private Consumer<BackpackContainer> upgradeChangeListener = null;
    private final BackpackBackgroundProperties backpackBackgroundProperties;
    public final NonNullList<ItemStack> upgradeItemStacks = NonNullList.func_191196_a();
    public final List<Slot> upgradeSlots = Lists.newArrayList();
    public final NonNullList<ItemStack> realInventoryItemStacks = NonNullList.func_191196_a();
    public final List<Slot> realInventorySlots = Lists.newArrayList();
    private final IBackpackWrapper parentBackpackWrapper;
    private final Map<Integer, ItemStack> slotStacksToUpdate = new HashMap<Integer, ItemStack>();
    private boolean isUpdatingFromPacket = false;
    private CompoundNBT lastSettingsNbt = null;
    private long errorResultExpirationTime = 0L;
    @Nullable
    private UpgradeSlotChangeResult errorUpgradeSlotChangeResult;
    private static final Method ON_SWAP_CRAFT = ObfuscationReflectionHelper.findMethod(Slot.class, (String)"func_190900_b", (Class[])new Class[]{Integer.TYPE});

    public IBackpackWrapper getBackpackWrapper() {
        return this.backpackWrapper;
    }

    public Optional<UpgradeSlotChangeResult> getErrorUpgradeSlotChangeResult() {
        if (this.errorUpgradeSlotChangeResult != null && this.player.field_70170_p.func_82737_E() >= this.errorResultExpirationTime) {
            this.errorResultExpirationTime = 0L;
            this.errorUpgradeSlotChangeResult = null;
        }
        return Optional.ofNullable(this.errorUpgradeSlotChangeResult);
    }

    public BackpackContainer(int windowId, PlayerEntity player, BackpackContext backpackContext) {
        super((ContainerType)ModItems.BACKPACK_CONTAINER_TYPE.get(), windowId);
        this.player = player;
        this.backpackContext = backpackContext;
        this.parentBackpackWrapper = backpackContext.getParentBackpackWrapper(player).orElse(NoopBackpackWrapper.INSTANCE);
        this.backpackWrapper = backpackContext.getBackpackWrapper(player);
        this.removeOpenTabIfKeepOff();
        this.backpackWrapper.fillWithLoot(player);
        this.backpackBackgroundProperties = this.getNumberOfSlots() + this.backpackWrapper.getColumnsTaken() * this.backpackWrapper.getNumberOfSlotRows() <= 81 ? BackpackBackgroundProperties.REGULAR : BackpackBackgroundProperties.WIDE;
        this.initSlotsAndContainers(player, backpackContext.getBackpackSlotIndex(), backpackContext.shouldLockBackpackSlot(player));
        this.backpackWrapper.getContentsUuid().ifPresent(backpackUuid -> {
            ItemStack backpack = this.backpackWrapper.getBackpack();
            BackpackAccessLogger.logPlayerAccess(player, backpack.func_77973_b(), backpackUuid, backpack.func_200301_q().getString(), this.backpackWrapper.getClothColor(), this.backpackWrapper.getBorderColor(), this.backpackWrapper.getColumnsTaken());
        });
    }

    private void sendBackpackSettingsToClient() {
        if (this.player.field_70170_p.field_72995_K) {
            return;
        }
        this.backpackWrapper.getContentsUuid().ifPresent(uuid -> {
            CompoundNBT settingsContents = new CompoundNBT();
            CompoundNBT settingsNbt = this.backpackWrapper.getSettingsHandler().getNbt();
            if (!settingsNbt.isEmpty()) {
                settingsContents.func_218657_a("settings", (INBT)settingsNbt);
                PacketHandler.sendToClient((ServerPlayerEntity)this.player, new BackpackContentsMessage((UUID)uuid, settingsContents));
            }
        });
    }

    public IBackpackWrapper getParentBackpackWrapper() {
        return this.parentBackpackWrapper;
    }

    public int getColumnsTaken() {
        return this.backpackWrapper.getColumnsTaken();
    }

    private void initSlotsAndContainers(PlayerEntity player, int backpackSlotIndex, boolean shouldLockBackpackSlot) {
        int yPosition = this.addBackpackInventorySlots();
        this.addPlayerInventorySlots(player.field_71071_by, yPosition, backpackSlotIndex, shouldLockBackpackSlot);
        this.addBackpackUpgradeSlots(yPosition);
        this.addUpgradeSettingsContainers(player);
    }

    private void addUpgradeSettingsContainers(PlayerEntity player) {
        BackpackUpgradeHandler upgradeHandler = this.backpackWrapper.getUpgradeHandler();
        upgradeHandler.getSlotWrappers().forEach((slot, wrapper) -> UpgradeContainerRegistry.instantiateContainer(player, slot, wrapper).ifPresent(container -> this.upgradeContainers.put((Integer)slot, (UpgradeContainerBase<?, ?>)container)));
        for (UpgradeContainerBase<?, ?> container : this.upgradeContainers.values()) {
            container.getSlots().forEach(this::addUpgradeSlot);
            container.onInit();
        }
        this.backpackWrapper.getOpenTabId().ifPresent(id -> {
            if (this.upgradeContainers.containsKey(id)) {
                this.upgradeContainers.get(id).setIsOpen(true);
            }
        });
    }

    private void addBackpackUpgradeSlots(int lastInventoryRowY) {
        BackpackUpgradeHandler upgradeHandler = this.backpackWrapper.getUpgradeHandler();
        int numberOfSlots = upgradeHandler.getSlots();
        if (numberOfSlots == 0) {
            return;
        }
        int slotIndex = 0;
        int yPosition = lastInventoryRowY - 22 * numberOfSlots;
        while (slotIndex < upgradeHandler.getSlots()) {
            this.addUpgradeSlot((Slot)new BackpackUpgradeSlot(upgradeHandler, slotIndex, yPosition));
            ++slotIndex;
            yPosition += 22;
        }
    }

    protected void addUpgradeSlot(Slot slot) {
        slot.field_75222_d = this.getInventorySlotsSize() + this.upgradeSlots.size();
        this.upgradeSlots.add(slot);
        this.upgradeItemStacks.add((Object)ItemStack.field_190927_a);
    }

    protected void addNoSortSlot(Slot slot) {
        slot.field_75222_d = this.getInventorySlotsSize();
        this.realInventorySlots.add(slot);
        this.realInventoryItemStacks.add((Object)ItemStack.field_190927_a);
    }

    protected Slot func_75146_a(Slot slot) {
        slot.field_75222_d = this.getInventorySlotsSize();
        this.field_75151_b.add(slot);
        this.field_75153_a.add((Object)ItemStack.field_190927_a);
        this.realInventorySlots.add(slot);
        this.realInventoryItemStacks.add((Object)ItemStack.field_190927_a);
        return slot;
    }

    public void setUpgradeChangeListener(Consumer<BackpackContainer> upgradeChangeListener) {
        this.upgradeChangeListener = upgradeChangeListener;
    }

    private int addBackpackInventorySlots() {
        BackpackInventoryHandler inventoryHandler = this.backpackWrapper.getInventoryHandler();
        int slotIndex = 0;
        int yPosition = 18;
        Set<Integer> noSortSlotIndexes = this.getNoSortSlotIndexes();
        while (slotIndex < inventoryHandler.getSlots()) {
            int lineIndex = slotIndex % this.getSlotsOnLine();
            int finalSlotIndex = slotIndex;
            BackpackInventorySlot slot = new BackpackInventorySlot(this.player.field_70170_p.field_72995_K, this.backpackWrapper, inventoryHandler, finalSlotIndex, lineIndex, yPosition);
            if (noSortSlotIndexes.contains(slotIndex)) {
                this.addNoSortSlot(slot);
            } else {
                this.func_75146_a(slot);
            }
            if (++slotIndex % this.getSlotsOnLine() != 0) continue;
            yPosition += 18;
        }
        return this.getNumberOfRows() * 18 + 18;
    }

    private void addPlayerInventorySlots(PlayerInventory playerInventory, int yPosition, int backpackSlotIndex, boolean shouldLockBackpackSlot) {
        int playerInventoryXOffset = this.backpackBackgroundProperties.getPlayerInventoryXOffset();
        yPosition += 14;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int slotIndex = j + i * 9 + 9;
                int xPosition = playerInventoryXOffset + 8 + j * 18;
                Slot slot = this.addBackpackSafeSlot(playerInventory, yPosition, slotIndex, xPosition, backpackSlotIndex, shouldLockBackpackSlot);
                this.addSlotAndUpdateBackpackSlotNumber(backpackSlotIndex, shouldLockBackpackSlot, slotIndex, slot);
            }
            yPosition += 18;
        }
        yPosition += 4;
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            int xPosition = playerInventoryXOffset + 8 + slotIndex * 18;
            Slot slot = this.addBackpackSafeSlot(playerInventory, yPosition, slotIndex, xPosition, backpackSlotIndex, shouldLockBackpackSlot);
            this.addSlotAndUpdateBackpackSlotNumber(backpackSlotIndex, shouldLockBackpackSlot, slotIndex, slot);
        }
    }

    public void func_190896_a(List<ItemStack> items) {
        this.backpackWrapper.setPersistent(false);
        this.isUpdatingFromPacket = true;
        super.func_190896_a(items);
        this.isUpdatingFromPacket = false;
        this.backpackWrapper.setPersistent(true);
        this.backpackWrapper.getInventoryHandler().saveInventory();
        this.backpackWrapper.getUpgradeHandler().saveInventory();
    }

    private Slot addBackpackSafeSlot(PlayerInventory playerInventory, int yPosition, int slotIndex, int xPosition, int backpackSlotIndex, boolean shouldLockBackpackSlot) {
        Slot slot = shouldLockBackpackSlot && slotIndex == backpackSlotIndex ? new Slot((IInventory)playerInventory, slotIndex, xPosition, yPosition){

            public boolean func_82869_a(PlayerEntity playerIn) {
                return false;
            }

            public void func_75218_e() {
                super.func_75218_e();
                BackpackContainer.this.closeBackpackScreenIfSomethingMessedWithBackpackStack(this.func_75211_c());
            }
        } : new Slot((IInventory)playerInventory, slotIndex, xPosition, yPosition);
        return this.func_75146_a(slot);
    }

    public void closeBackpackScreenIfSomethingMessedWithBackpackStack(ItemStack supposedToBeBackpackStack) {
        if (!this.isClientSide() && this.isNotCorrectBackpack(supposedToBeBackpackStack)) {
            this.player.func_71053_j();
        }
    }

    private boolean isNotCorrectBackpack(ItemStack supposedToBeBackpackStack) {
        return supposedToBeBackpackStack.func_190926_b() || !(supposedToBeBackpackStack.func_77973_b() instanceof BackpackItem) || supposedToBeBackpackStack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(w -> w != (this.isFirstLevelBackpack() ? this.backpackWrapper : this.parentBackpackWrapper)).orElse(true) != false;
    }

    private boolean isClientSide() {
        return this.player.field_70170_p.field_72995_K;
    }

    private void addSlotAndUpdateBackpackSlotNumber(int backpackSlotIndex, boolean lockBackpackSlot, int slotIndex, Slot slot) {
        if (lockBackpackSlot && slotIndex == backpackSlotIndex) {
            this.backpackSlotNumber = slot.field_75222_d;
        }
    }

    public int getNumberOfRows() {
        return this.backpackWrapper.getNumberOfSlotRows();
    }

    public int getSlotsOnLine() {
        return this.backpackBackgroundProperties.getSlotsOnLine() - this.backpackWrapper.getColumnsTaken();
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.backpackContext.canInteractWith(player);
    }

    public static BackpackContainer fromBuffer(int windowId, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        return new BackpackContainer(windowId, playerInventory.field_70458_d, BackpackContext.fromBuffer(packetBuffer));
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = this.func_75139_a(index);
        if (slot.func_75216_d()) {
            Optional<UpgradeContainerBase<?, ?>> upgradeContainer = this.getSlotUpgradeContainer(slot);
            ItemStack slotStack = upgradeContainer.map(c -> c.getSlotStackToTransfer(slot)).orElse(slot.func_75211_c());
            itemstack = slotStack.func_77946_l();
            if (!this.mergeSlotStack(slot, index, slotStack, true)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            slot.func_75220_a(slotStack, itemstack);
            if (upgradeContainer.isPresent()) {
                upgradeContainer.ifPresent(c -> c.onTakeFromSlot(slot, this.player, slotStack));
            } else {
                slot.func_190901_a(this.player, slotStack);
            }
        }
        return itemstack;
    }

    private boolean mergeSlotStack(Slot slot, int index, ItemStack slotStack, boolean transferMaxStackSizeFromSource) {
        if (this.isUpgradeSlot(index)) {
            return this.mergeStackToBackpack(slotStack) || this.mergeStackToPlayersInventory(slotStack, true);
        }
        if (this.isBackpackInventorySlot(index)) {
            if (this.shouldShiftClickIntoOpenTabFirst()) {
                return this.mergeStackToOpenUpgradeTab(slotStack, transferMaxStackSizeFromSource) || this.mergeStackToPlayersInventory(slotStack, transferMaxStackSizeFromSource);
            }
            return this.mergeStackToPlayersInventory(slotStack, transferMaxStackSizeFromSource) || this.mergeStackToOpenUpgradeTab(slotStack, transferMaxStackSizeFromSource);
        }
        if (this.isUpgradeSettingsSlot(index)) {
            if (this.getSlotUpgradeContainer(slot).map(c -> c.mergeIntoBackpackFirst(slot)).orElse(true).booleanValue()) {
                return this.mergeStackToBackpack(slotStack) || this.mergeStackToPlayersInventory(slotStack, true);
            }
            return this.mergeStackToPlayersInventory(slotStack, true) || this.mergeStackToBackpack(slotStack);
        }
        if (this.shouldShiftClickIntoOpenTabFirst()) {
            return this.mergeStackToOpenUpgradeTab(slotStack, true) || this.mergeStackToUpgradeSlots(slotStack) || this.mergeStackToBackpack(slotStack);
        }
        return this.mergeStackToUpgradeSlots(slotStack) || this.mergeStackToBackpack(slotStack) || this.mergeStackToOpenUpgradeTab(slotStack, true);
    }

    private boolean shouldShiftClickIntoOpenTabFirst() {
        return BackpackSettingsManager.getBackpackSettingValue(this.player, this.backpackWrapper.getSettingsHandler().getTypeCategory(BackpackSettingsCategory.class), BackpackSettingsManager.SHIFT_CLICK_INTO_OPEN_TAB_FIRST);
    }

    public Optional<ItemStack> getMemorizedStackInSlot(int slotId) {
        return this.backpackWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).getSlotFilterItem(slotId).map(ItemStack::new);
    }

    private boolean mergeStackToUpgradeSlots(ItemStack slotStack) {
        return !this.upgradeSlots.isEmpty() && this.func_75135_a(slotStack, this.getInventorySlotsSize(), this.getInventorySlotsSize() + this.getNumberOfUpgradeSlots(), false);
    }

    private int getInventorySlotsSize() {
        return this.realInventorySlots.size();
    }

    private boolean mergeStackToOpenUpgradeTab(ItemStack slotStack, boolean transferMaxStackSizeFromSource) {
        return this.getOpenContainer().map(c -> {
            List<Slot> slots = c.getSlots();
            if (slots.isEmpty()) {
                return false;
            }
            int firstSlotIndex = slots.get((int)0).field_75222_d;
            int lastSlotIndex = slots.get((int)(slots.size() - 1)).field_75222_d;
            return this.mergeItemStack(slotStack, firstSlotIndex, lastSlotIndex + 1, false, transferMaxStackSizeFromSource);
        }).orElse(false);
    }

    private boolean mergeStackToBackpack(ItemStack slotStack) {
        return this.mergeItemStack(slotStack, 0, this.getNumberOfSlots(), false, false, true);
    }

    private boolean mergeStackToPlayersInventory(ItemStack slotStack, boolean transferMaxStackSizeFromSource) {
        return this.mergeItemStack(slotStack, this.getNumberOfSlots(), this.getInventorySlotsSize(), true, transferMaxStackSizeFromSource);
    }

    public boolean isPlayersInventorySlot(int slotNumber) {
        return slotNumber >= this.getNumberOfSlots() && slotNumber < this.getInventorySlotsSize();
    }

    private boolean isUpgradeSettingsSlot(int index) {
        return index >= this.getNumberOfSlots() + this.getNumberOfUpgradeSlots() + 36;
    }

    public boolean isBackpackInventorySlot(int index) {
        return index >= 0 && index < this.getNumberOfSlots();
    }

    private boolean isUpgradeSlot(int index) {
        return index >= this.getFirstUpgradeSlot() && index - this.getFirstUpgradeSlot() < this.getNumberOfUpgradeSlots();
    }

    public int getFirstUpgradeSlot() {
        return this.getInventorySlotsSize();
    }

    public Optional<UpgradeContainerBase<?, ?>> getSlotUpgradeContainer(Slot slot) {
        if (this.isUpgradeSettingsSlot(slot.field_75222_d)) {
            for (UpgradeContainerBase<?, ?> upgradeContainer : this.upgradeContainers.values()) {
                if (!upgradeContainer.containsSlot(slot)) continue;
                return Optional.of(upgradeContainer);
            }
        }
        return Optional.empty();
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, PlayerEntity player) {
        if (this.isUpgradeSettingsSlot(slotId) && this.func_75139_a(slotId) instanceof IFilterSlot && this.func_75139_a(slotId).func_75214_a(player.field_71071_by.func_70445_o())) {
            Slot slot = this.func_75139_a(slotId);
            ItemStack cursorStack = player.field_71071_by.func_70445_o().func_77946_l();
            if (cursorStack.func_190916_E() > 1) {
                cursorStack.func_190920_e(1);
            }
            slot.func_75215_d(cursorStack);
            return ItemStack.field_190927_a;
        }
        if (this.isUpgradeSlot(slotId) && this.func_75139_a(slotId) instanceof BackpackUpgradeSlot) {
            Slot slot = this.func_75139_a(slotId);
            ItemStack slotStack = slot.func_75211_c();
            if (slot.func_75214_a(player.field_71071_by.func_70445_o())) {
                BackpackUpgradeSlot upgradeSlot = (BackpackUpgradeSlot)slot;
                ItemStack cursorStack = player.field_71071_by.func_70445_o();
                IBackpackUpgradeItem backpackUpgradeItem = (IBackpackUpgradeItem)cursorStack.func_77973_b();
                int newColumnsTaken = backpackUpgradeItem.getInventoryColumnsTaken();
                int currentColumnsTaken = 0;
                if (!slotStack.func_190926_b()) {
                    currentColumnsTaken = ((IBackpackUpgradeItem)slotStack.func_77973_b()).getInventoryColumnsTaken();
                }
                if (this.needsSlotsThatAreOccupied(cursorStack, currentColumnsTaken, upgradeSlot, newColumnsTaken)) {
                    return ItemStack.field_190927_a;
                }
                int columnsToRemove = newColumnsTaken - currentColumnsTaken;
                if (slotStack.func_190926_b() || upgradeSlot.canSwapStack(player, cursorStack)) {
                    player.field_71071_by.func_70437_b(slotStack);
                    upgradeSlot.func_75215_d(cursorStack);
                    this.updateColumnsTaken(columnsToRemove);
                    upgradeSlot.func_75218_e();
                    return slotStack.func_77946_l();
                }
                return ItemStack.field_190927_a;
            }
            if ((player.field_71071_by.func_70445_o().func_190926_b() || slot.func_75214_a(player.field_71071_by.func_70445_o())) && !slotStack.func_190926_b() && slot.func_82869_a(player)) {
                int k2 = dragType == 0 ? Math.min(slotStack.func_190916_E(), slotStack.func_77976_d()) : Math.min(slotStack.func_77976_d() + 1, slotStack.func_190916_E() + 1) / 2;
                int columnsTaken = ((IBackpackUpgradeItem)slotStack.func_77973_b()).getInventoryColumnsTaken();
                ItemStack result = ItemStack.field_190927_a;
                if (clickType == ClickType.QUICK_MOVE) {
                    result = this.func_82846_b(player, slotId);
                } else {
                    player.field_71071_by.func_70437_b(slot.func_75209_a(k2));
                }
                this.updateColumnsTaken(-columnsTaken);
                slot.func_190901_a(player, player.field_71071_by.func_70445_o());
                return result;
            }
            return ItemStack.field_190927_a;
        }
        if (this.isOverflowLogicSlotAndAction(slotId, clickType) && this.handleOverflow(slotId, clickType, dragType, player)) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }

    private boolean handleOverflow(int slotId, ClickType clickType, int dragType, PlayerEntity player) {
        ItemStack cursorStack = clickType == ClickType.SWAP ? player.field_71071_by.func_70301_a(dragType) : player.field_71071_by.func_70445_o();
        Consumer<ItemStack> updateCursorStack = clickType == ClickType.SWAP ? s -> player.field_71071_by.func_70299_a(dragType, s) : arg_0 -> ((PlayerInventory)player.field_71071_by).func_70437_b(arg_0);
        Slot slot = this.func_75139_a(slotId);
        if (clickType != ClickType.SWAP && cursorStack.func_190926_b() || !slot.func_75214_a(cursorStack)) {
            return false;
        }
        ItemStack slotStack = slot.func_75211_c();
        if (slotStack.func_190926_b() || slot.func_82869_a(player) && slotStack.func_77973_b() != cursorStack.func_77973_b() && cursorStack.func_190916_E() <= slot.func_178170_b(cursorStack) && slotStack.func_190916_E() <= slotStack.func_77976_d()) {
            return this.processOverflowIfSlotWithSameItemFound(slotId, cursorStack, updateCursorStack, slotStack);
        }
        if (slotStack.func_77973_b() == cursorStack.func_77973_b()) {
            return this.processOverflowForAnythingOverSlotMaxSize(cursorStack, updateCursorStack, slot, slotStack);
        }
        return false;
    }

    private boolean processOverflowForAnythingOverSlotMaxSize(ItemStack cursorStack, Consumer<ItemStack> updateCursorStack, Slot slot, ItemStack slotStack) {
        int remainingSpaceInSlot = slot.func_178170_b(cursorStack) - slotStack.func_190916_E();
        if (remainingSpaceInSlot < cursorStack.func_190916_E()) {
            ItemStack overflow = cursorStack.func_77946_l();
            int overflowCount = cursorStack.func_190916_E() - remainingSpaceInSlot;
            overflow.func_190920_e(overflowCount);
            ItemStack result = this.processOverflowLogic(overflow);
            if (result.func_190916_E() < overflowCount) {
                cursorStack.func_190918_g(overflowCount - result.func_190916_E());
                if (cursorStack.func_190926_b()) {
                    updateCursorStack.accept(ItemStack.field_190927_a);
                    return true;
                }
                updateCursorStack.accept(cursorStack);
            }
        }
        return false;
    }

    private boolean processOverflowIfSlotWithSameItemFound(int slotId, ItemStack cursorStack, Consumer<ItemStack> updateCursorStack, ItemStack slotStack) {
        for (int slotIndex = 0; slotIndex < this.getNumberOfSlots(); ++slotIndex) {
            if (slotIndex == slotId || !BackpackContainer.func_195929_a((ItemStack)this.func_75139_a(slotIndex).func_75211_c(), (ItemStack)cursorStack)) continue;
            ItemStack result = this.processOverflowLogic(cursorStack);
            if (result.func_190916_E() < cursorStack.func_190916_E()) {
                updateCursorStack.accept(result);
                return slotStack.func_190926_b();
            }
            return false;
        }
        return false;
    }

    private boolean isOverflowLogicSlotAndAction(int slotId, ClickType clickType) {
        return this.isBackpackInventorySlot(slotId) && (clickType == ClickType.SWAP || clickType == ClickType.PICKUP);
    }

    private void updateColumnsTaken(int columnsToRemove) {
        if (columnsToRemove != 0) {
            this.backpackWrapper.setColumnsTaken(Math.max(0, this.backpackWrapper.getColumnsTaken() + columnsToRemove));
            this.backpackWrapper.onContentsNbtUpdated();
            this.refreshAllSlots();
        }
    }

    private boolean needsSlotsThatAreOccupied(ItemStack cursorStack, int currentColumnsTaken, BackpackUpgradeSlot upgradeSlot, int newColumnsTaken) {
        if (currentColumnsTaken >= newColumnsTaken) {
            return false;
        }
        int slotsToCheck = (newColumnsTaken - currentColumnsTaken) * this.getNumberOfRows();
        BackpackInventoryHandler invHandler = this.backpackWrapper.getInventoryHandler();
        HashSet<Integer> errorSlots = new HashSet<Integer>();
        int slots = this.getNumberOfSlots();
        for (int slotIndex = slots - 1; slotIndex >= slots - slotsToCheck; --slotIndex) {
            if (invHandler.getStackInSlot(slotIndex).func_190926_b()) continue;
            errorSlots.add(slotIndex);
        }
        if (!errorSlots.isEmpty()) {
            upgradeSlot.updateSlotChangeError(new UpgradeSlotChangeResult.Fail(TranslationHelper.translError("add.needs_occupied_inventory_slots", slotsToCheck, cursorStack.func_200301_q()), Collections.emptySet(), errorSlots, Collections.emptySet()));
            return true;
        }
        return false;
    }

    public int getNumberOfSlots() {
        return this.backpackWrapper.getInventoryHandler().getSlots();
    }

    public BackpackBackgroundProperties getBackpackBackgroundProperties() {
        return this.backpackBackgroundProperties;
    }

    public int getNumberOfUpgradeSlots() {
        return this.backpackWrapper.getUpgradeHandler().getSlots();
    }

    public int getFirstUpgradeSettingsSlot() {
        return this.getNumberOfSlots() + this.getNumberOfUpgradeSlots() + 36;
    }

    public Map<Integer, UpgradeContainerBase<?, ?>> getUpgradeContainers() {
        return this.upgradeContainers;
    }

    @Override
    public void handleMessage(CompoundNBT data) {
        if (data.func_74764_b("containerId")) {
            int containerId = data.func_74762_e("containerId");
            if (this.upgradeContainers.containsKey(containerId)) {
                this.upgradeContainers.get(containerId).handleMessage(data);
            }
        } else if (data.func_74764_b(OPEN_TAB_ID_TAG)) {
            this.setOpenTabId(data.func_74762_e(OPEN_TAB_ID_TAG));
        } else if (data.func_74764_b(SORT_BY_TAG)) {
            this.setSortBy(SortBy.fromName(data.func_74779_i(SORT_BY_TAG)));
        } else if (data.func_74764_b(ACTION_TAG)) {
            String actionName;
            switch (actionName = data.func_74779_i(ACTION_TAG)) {
                case "sort": {
                    this.sort();
                    break;
                }
                case "openSettings": {
                    this.openSettings();
                    break;
                }
            }
        } else if (data.func_74764_b(UPGRADE_ENABLED_TAG)) {
            this.setUpgradeEnabled(data.func_74762_e(UPGRADE_SLOT_TAG), data.func_74767_n(UPGRADE_ENABLED_TAG));
        }
    }

    public void setOpenTabId(int tabId) {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.func_74768_a(OPEN_TAB_ID_TAG, tabId));
        }
        if (tabId == -1) {
            this.backpackWrapper.removeOpenTabId();
        } else {
            this.backpackWrapper.setOpenTabId(tabId);
        }
    }

    public void removeOpenTabId() {
        this.setOpenTabId(-1);
    }

    public SortBy getSortBy() {
        return this.backpackWrapper.getSortBy();
    }

    private void sendToServer(Consumer<CompoundNBT> addData) {
        CompoundNBT data = new CompoundNBT();
        addData.accept(data);
        PacketHandler.sendToServer(new SyncContainerClientDataMessage(data));
    }

    public void setSortBy(SortBy sortBy) {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.func_74778_a(SORT_BY_TAG, sortBy.func_176610_l()));
        }
        this.backpackWrapper.setSortBy(sortBy);
    }

    public void sort() {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.func_74778_a(ACTION_TAG, "sort"));
            return;
        }
        this.backpackWrapper.sort();
    }

    public boolean isFirstLevelBackpack() {
        return this.parentBackpackWrapper == NoopBackpackWrapper.INSTANCE;
    }

    public BackpackContext getBackpackContext() {
        return this.backpackContext;
    }

    public boolean canDisableUpgrade(int upgradeSlot) {
        Map<Integer, IUpgradeWrapper> slotWrappers = this.backpackWrapper.getUpgradeHandler().getSlotWrappers();
        if (!slotWrappers.containsKey(upgradeSlot)) {
            return false;
        }
        return slotWrappers.get(upgradeSlot).canBeDisabled();
    }

    public boolean getUpgradeEnabled(int upgradeSlot) {
        Map<Integer, IUpgradeWrapper> slotWrappers = this.backpackWrapper.getUpgradeHandler().getSlotWrappers();
        if (!slotWrappers.containsKey(upgradeSlot)) {
            return false;
        }
        return slotWrappers.get(upgradeSlot).isEnabled();
    }

    public void setUpgradeEnabled(int upgradeSlot, boolean enabled) {
        Map<Integer, IUpgradeWrapper> slotWrappers = this.backpackWrapper.getUpgradeHandler().getSlotWrappers();
        if (!slotWrappers.containsKey(upgradeSlot)) {
            return;
        }
        if (this.isClientSide()) {
            this.sendToServer(data -> {
                data.func_74757_a(UPGRADE_ENABLED_TAG, enabled);
                data.func_74768_a(UPGRADE_SLOT_TAG, upgradeSlot);
            });
        }
        slotWrappers.get(upgradeSlot).setEnabled(enabled);
    }

    public Optional<UpgradeContainerBase<?, ?>> getOpenContainer() {
        return this.backpackWrapper.getOpenTabId().flatMap(id -> this.upgradeContainers.containsKey(id) ? Optional.of(this.upgradeContainers.get(id)) : Optional.empty());
    }

    public void openSettings() {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.func_74778_a(ACTION_TAG, "openSettings"));
            return;
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)this.player), (INamedContainerProvider)new SimpleNamedContainerProvider((w, p, pl) -> new SettingsContainer(w, pl, this.backpackContext), (ITextComponent)new TranslationTextComponent(TranslationHelper.translGui("settings.title"))), this.backpackContext::toBuffer);
    }

    public List<Integer> getSlotOverlayColors(int slot) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        this.backpackWrapper.getSettingsHandler().getCategoriesThatImplement(ISlotColorCategory.class).forEach(c -> c.getSlotColor(slot).ifPresent(ret::add));
        return ret;
    }

    public <T extends UpgradeContainerBase<?, ?>> Optional<T> getOpenOrFirstCraftingContainer() {
        UpgradeContainerBase<?, ?> firstContainer = null;
        for (UpgradeContainerBase<?, ?> container : this.upgradeContainers.values()) {
            if (!(container instanceof ICraftingContainer)) continue;
            if (container.isOpen()) {
                return Optional.of(container);
            }
            if (firstContainer != null) continue;
            firstContainer = container;
        }
        return Optional.ofNullable(firstContainer);
    }

    public NonNullList<ItemStack> func_75138_a() {
        NonNullList list = NonNullList.func_191196_a();
        for (int i = 0; i < this.realInventorySlots.size(); ++i) {
            list.add((Object)this.realInventorySlots.get(i).func_75211_c());
        }
        this.upgradeSlots.forEach(upgradeSlot -> list.add((Object)upgradeSlot.func_75211_c()));
        return list;
    }

    public void func_75142_b() {
        if (this.backpackSlotNumber != -1) {
            this.closeBackpackScreenIfSomethingMessedWithBackpackStack(this.func_75139_a(this.backpackSlotNumber).func_75211_c());
        }
        this.detectAndSendChangesIn(this.upgradeItemStacks, this.upgradeSlots);
        this.detectAndSendChangesIn(this.realInventoryItemStacks, this.realInventorySlots);
        if (this.lastSettingsNbt == null || !this.lastSettingsNbt.equals((Object)this.backpackWrapper.getSettingsHandler().getNbt())) {
            this.lastSettingsNbt = this.backpackWrapper.getSettingsHandler().getNbt().func_74737_b();
            this.sendBackpackSettingsToClient();
            this.refreshInventorySlotsIfNeeded();
        }
    }

    private void detectAndSendChangesIn(NonNullList<ItemStack> stacksCollection, List<Slot> slotsCollection) {
        for (int i = 0; i < slotsCollection.size(); ++i) {
            Slot slot = slotsCollection.get(i);
            ItemStack currentStack = slot.func_75211_c();
            ItemStack previousStack = (ItemStack)stacksCollection.get(i);
            if (ItemStack.func_77989_b((ItemStack)previousStack, (ItemStack)currentStack)) continue;
            boolean clientStackChanged = !previousStack.equals(currentStack, true);
            ItemStack stackCopy = currentStack.func_77946_l();
            stacksCollection.set(i, (Object)stackCopy);
            if (!clientStackChanged) continue;
            for (IContainerListener icontainerlistener : this.field_75149_d) {
                icontainerlistener.func_71111_a((Container)this, slot.field_75222_d, stackCopy);
            }
        }
    }

    private void refreshInventorySlotsIfNeeded() {
        Set<Integer> noSortSlotIndexes = this.getNoSortSlotIndexes();
        boolean needRefresh = false;
        if (this.realInventorySlots.size() - this.field_75151_b.size() != noSortSlotIndexes.size()) {
            needRefresh = true;
        } else {
            for (Slot slot : this.realInventorySlots) {
                if (this.field_75151_b.contains(slot) || noSortSlotIndexes.contains(slot.field_75222_d)) continue;
                needRefresh = true;
                break;
            }
        }
        if (!needRefresh) {
            return;
        }
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.realInventorySlots.clear();
        this.realInventoryItemStacks.clear();
        int yPosition = this.addBackpackInventorySlots();
        this.addPlayerInventorySlots(this.player.field_71071_by, yPosition, this.backpackContext.getBackpackSlotIndex(), this.backpackContext.shouldLockBackpackSlot(this.player));
    }

    private void refreshAllSlots() {
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.realInventorySlots.clear();
        this.realInventoryItemStacks.clear();
        this.upgradeSlots.clear();
        this.upgradeItemStacks.clear();
        this.upgradeContainers.clear();
        this.initSlotsAndContainers(this.player, this.backpackContext.getBackpackSlotIndex(), this.backpackContext.shouldLockBackpackSlot(this.player));
    }

    private Set<Integer> getNoSortSlotIndexes() {
        BackpackSettingsHandler settingsHandler = this.backpackWrapper.getSettingsHandler();
        HashSet<Integer> slotIndexesExcludedFromSort = new HashSet<Integer>();
        slotIndexesExcludedFromSort.addAll(settingsHandler.getTypeCategory(NoSortSettingsCategory.class).getNoSortSlots());
        slotIndexesExcludedFromSort.addAll(settingsHandler.getTypeCategory(MemorySettingsCategory.class).getSlotIndexes());
        return slotIndexesExcludedFromSort;
    }

    public void detectSettingsChangeAndReload() {
        this.backpackWrapper.getContentsUuid().ifPresent(uuid -> {
            BackpackStorage storage = BackpackStorage.get();
            if (storage.removeUpdatedBackpackSettingsFlag((UUID)uuid)) {
                this.backpackWrapper.getSettingsHandler().reloadFrom(storage.getOrCreateBackpackContents((UUID)uuid));
                this.refreshInventorySlotsIfNeeded();
            }
        });
    }

    public Slot func_75139_a(int slotId) {
        if (slotId >= this.getInventorySlotsSize()) {
            return this.upgradeSlots.get(slotId - this.getInventorySlotsSize());
        }
        return this.realInventorySlots.get(slotId);
    }

    private void onSwapCraft(Slot slot, int numItemsCrafted) {
        try {
            ON_SWAP_CRAFT.invoke((Object)slot, numItemsCrafted);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            SophisticatedBackpacks.LOGGER.error("Error invoking onSwapCraft method in Slot class", (Throwable)e);
        }
    }

    protected ItemStack func_241440_b_(int slotId, int dragType, ClickType clickType, PlayerEntity player) {
        ItemStack ret = ItemStack.field_190927_a;
        PlayerInventory playerinventory = player.field_71071_by;
        if (clickType == ClickType.QUICK_CRAFT) {
            int prevDragEvent = this.field_94536_g;
            this.field_94536_g = BackpackContainer.func_94532_c((int)dragType);
            if ((prevDragEvent != 1 || this.field_94536_g != 2) && prevDragEvent != this.field_94536_g) {
                this.func_94533_d();
            } else if (playerinventory.func_70445_o().func_190926_b()) {
                this.func_94533_d();
            } else if (this.field_94536_g == 0) {
                this.field_94535_f = BackpackContainer.func_94529_b((int)dragType);
                if (BackpackContainer.func_180610_a((int)this.field_94535_f, (PlayerEntity)player)) {
                    this.field_94536_g = 1;
                    this.field_94537_h.clear();
                } else {
                    this.func_94533_d();
                }
            } else if (this.field_94536_g == 1) {
                ItemStack itemstack12;
                Slot slot7 = this.func_75139_a(slotId);
                if (BackpackContainer.canMergeItemToSlot(slot7, itemstack12 = playerinventory.func_70445_o()) && slot7.func_75214_a(itemstack12) && (this.field_94535_f == 2 || itemstack12.func_190916_E() > this.field_94537_h.size()) && this.func_94531_b(slot7)) {
                    this.field_94537_h.add(slot7);
                }
            } else if (this.field_94536_g == 2) {
                if (!this.field_94537_h.isEmpty()) {
                    if (this.field_94537_h.size() == 1) {
                        int l = ((Slot)this.field_94537_h.iterator().next()).field_75222_d;
                        this.func_94533_d();
                        return this.func_184996_a(l, this.field_94535_f, ClickType.PICKUP, player);
                    }
                    ItemStack cursorStack = playerinventory.func_70445_o().func_77946_l();
                    int k1 = playerinventory.func_70445_o().func_190916_E();
                    for (Slot slot8 : this.field_94537_h) {
                        ItemStack itemstack13 = playerinventory.func_70445_o();
                        if (slot8 == null || !BackpackContainer.canMergeItemToSlot(slot8, itemstack13) || !slot8.func_75214_a(itemstack13) || this.field_94535_f != 2 && itemstack13.func_190916_E() < this.field_94537_h.size() || !this.func_94531_b(slot8)) continue;
                        ItemStack itemstack14 = cursorStack.func_77946_l();
                        int j3 = slot8.func_75216_d() ? slot8.func_75211_c().func_190916_E() : 0;
                        BackpackContainer.func_94525_a((Set)this.field_94537_h, (int)this.field_94535_f, (ItemStack)itemstack14, (int)j3);
                        int slotStackLimit = slot8.func_178170_b(itemstack14);
                        if (!(slot8 instanceof BackpackInventorySlot) && slotStackLimit > cursorStack.func_77976_d()) {
                            slotStackLimit = cursorStack.func_77976_d();
                        }
                        if (itemstack14.func_190916_E() > slotStackLimit) {
                            itemstack14.func_190920_e(slotStackLimit);
                        }
                        k1 -= itemstack14.func_190916_E() - j3;
                        slot8.func_75215_d(itemstack14);
                    }
                    cursorStack.func_190920_e(k1);
                    playerinventory.func_70437_b(cursorStack);
                }
                this.func_94533_d();
            } else {
                this.func_94533_d();
            }
        } else if (this.field_94536_g != 0) {
            this.func_94533_d();
        } else if (!(clickType != ClickType.PICKUP && clickType != ClickType.QUICK_MOVE || dragType != 0 && dragType != 1)) {
            if (slotId == -999) {
                if (!playerinventory.func_70445_o().func_190926_b()) {
                    if (dragType == 0) {
                        player.func_71019_a(playerinventory.func_70445_o(), true);
                        playerinventory.func_70437_b(ItemStack.field_190927_a);
                    }
                    if (dragType == 1) {
                        player.func_71019_a(playerinventory.func_70445_o().func_77979_a(1), true);
                    }
                }
            } else if (clickType == ClickType.QUICK_MOVE) {
                if (slotId < 0) {
                    return ItemStack.field_190927_a;
                }
                Slot slot5 = this.func_75139_a(slotId);
                if (!slot5.func_82869_a(player)) {
                    return ItemStack.field_190927_a;
                }
                if (this.isBackpackInventorySlot(slotId)) {
                    ret = this.func_82846_b(player, slotId).func_77946_l();
                } else {
                    ItemStack itemstack8 = this.func_82846_b(player, slotId);
                    while (!itemstack8.func_190926_b() && ItemStack.func_179545_c((ItemStack)slot5.func_75211_c(), (ItemStack)itemstack8)) {
                        ret = itemstack8.func_77946_l();
                        itemstack8 = this.func_82846_b(player, slotId);
                    }
                }
            } else {
                if (slotId < 0) {
                    return ItemStack.field_190927_a;
                }
                Slot slot6 = this.func_75139_a(slotId);
                ItemStack slotStack = slot6.func_75211_c();
                ItemStack cursorStack = playerinventory.func_70445_o();
                if (!slotStack.func_190926_b()) {
                    ret = slotStack.func_77946_l();
                }
                if (slotStack.func_190926_b()) {
                    if (!cursorStack.func_190926_b() && slot6.func_75214_a(cursorStack)) {
                        int j2;
                        int n = j2 = dragType == 0 ? cursorStack.func_190916_E() : 1;
                        if (j2 > slot6.func_178170_b(cursorStack)) {
                            j2 = slot6.func_178170_b(cursorStack);
                        }
                        slot6.func_75215_d(cursorStack.func_77979_a(j2));
                    }
                } else if (slot6.func_82869_a(player)) {
                    int i3;
                    if (cursorStack.func_190926_b()) {
                        if (slotStack.func_190926_b()) {
                            slot6.func_75215_d(ItemStack.field_190927_a);
                            playerinventory.func_70437_b(ItemStack.field_190927_a);
                        } else {
                            int k2 = dragType == 0 ? Math.min(slotStack.func_190916_E(), slotStack.func_77976_d()) : Math.min(slotStack.func_77976_d() + 1, slotStack.func_190916_E() + 1) / 2;
                            playerinventory.func_70437_b(slot6.func_75209_a(k2));
                            if (slotStack.func_190926_b()) {
                                slot6.func_75215_d(ItemStack.field_190927_a);
                            }
                            slot6.func_190901_a(player, playerinventory.func_70445_o());
                        }
                    } else if (slot6.func_75214_a(cursorStack)) {
                        if (BackpackContainer.func_195929_a((ItemStack)slotStack, (ItemStack)cursorStack)) {
                            int countToInsert;
                            int n = countToInsert = dragType == 0 ? cursorStack.func_190916_E() : 1;
                            if (countToInsert > slot6.func_178170_b(cursorStack) - slotStack.func_190916_E()) {
                                countToInsert = slot6.func_178170_b(cursorStack) - slotStack.func_190916_E();
                            }
                            if (!(slot6 instanceof BackpackInventorySlot) && countToInsert > cursorStack.func_77976_d() - slotStack.func_190916_E()) {
                                countToInsert = cursorStack.func_77976_d() - slotStack.func_190916_E();
                            }
                            cursorStack.func_190918_g(countToInsert);
                            slotStack.func_190917_f(countToInsert);
                        } else if (cursorStack.func_190916_E() <= slot6.func_178170_b(cursorStack) && slotStack.func_190916_E() <= slotStack.func_77976_d()) {
                            slot6.func_75215_d(cursorStack);
                            playerinventory.func_70437_b(slotStack);
                        }
                    } else if (cursorStack.func_77976_d() > 1 && BackpackContainer.func_195929_a((ItemStack)slotStack, (ItemStack)cursorStack) && !slotStack.func_190926_b() && (i3 = slotStack.func_190916_E()) + cursorStack.func_190916_E() <= cursorStack.func_77976_d()) {
                        cursorStack.func_190917_f(i3);
                        slotStack = slot6.func_75209_a(i3);
                        if (slotStack.func_190926_b()) {
                            slot6.func_75215_d(ItemStack.field_190927_a);
                        }
                        slot6.func_190901_a(player, playerinventory.func_70445_o());
                    }
                }
                slot6.func_75218_e();
            }
        } else if (clickType == ClickType.SWAP) {
            Slot slot = this.func_75139_a(slotId);
            ItemStack cursorStack = playerinventory.func_70301_a(dragType);
            ItemStack slotStack = slot.func_75211_c();
            if (!cursorStack.func_190926_b() || !slotStack.func_190926_b()) {
                if (cursorStack.func_190926_b()) {
                    if (slot.func_82869_a(player)) {
                        if (slotStack.func_190916_E() <= slotStack.func_77976_d()) {
                            playerinventory.func_70299_a(dragType, slotStack);
                            this.onSwapCraft(slot, slotStack.func_190916_E());
                            slot.func_75215_d(ItemStack.field_190927_a);
                            slot.func_190901_a(player, slotStack);
                        } else {
                            playerinventory.func_70299_a(dragType, slotStack.func_77979_a(slotStack.func_77976_d()));
                            slot.func_75218_e();
                        }
                    }
                } else if (slotStack.func_190926_b()) {
                    if (slot.func_75214_a(cursorStack)) {
                        int i = slot.func_178170_b(cursorStack);
                        if (cursorStack.func_190916_E() > i) {
                            slot.func_75215_d(cursorStack.func_77979_a(i));
                        } else {
                            slot.func_75215_d(cursorStack);
                            playerinventory.func_70299_a(dragType, ItemStack.field_190927_a);
                        }
                    }
                } else if (slotStack.func_190916_E() <= slotStack.func_77976_d() && slot.func_82869_a(player) && slot.func_75214_a(cursorStack)) {
                    int l1 = slot.func_178170_b(cursorStack);
                    if (cursorStack.func_190916_E() > l1) {
                        slot.func_75215_d(cursorStack.func_77979_a(l1));
                        slot.func_190901_a(player, slotStack);
                        if (!playerinventory.func_70441_a(slotStack)) {
                            player.func_71019_a(slotStack, true);
                        }
                    } else {
                        slot.func_75215_d(cursorStack);
                        playerinventory.func_70299_a(dragType, slotStack);
                        slot.func_190901_a(player, slotStack);
                    }
                }
            }
        } else if (clickType == ClickType.CLONE && player.field_71075_bZ.field_75098_d && playerinventory.func_70445_o().func_190926_b() && slotId >= 0) {
            Slot slot4 = this.func_75139_a(slotId);
            if (slot4.func_75216_d()) {
                ItemStack itemstack7 = slot4.func_75211_c().func_77946_l();
                itemstack7.func_190920_e(itemstack7.func_77976_d());
                playerinventory.func_70437_b(itemstack7);
            }
        } else if (clickType == ClickType.THROW && playerinventory.func_70445_o().func_190926_b() && slotId >= 0) {
            Slot slot3 = this.func_75139_a(slotId);
            if (slot3.func_75216_d() && slot3.func_82869_a(player)) {
                ItemStack stackToThrow = slot3.func_75209_a(dragType == 0 ? 1 : Math.min(slot3.func_75211_c().func_190916_E(), slot3.func_75211_c().func_77976_d()));
                slot3.func_190901_a(player, stackToThrow);
                player.func_71019_a(stackToThrow, true);
            }
        } else if (clickType == ClickType.PICKUP_ALL && slotId >= 0) {
            Slot slot2 = this.func_75139_a(slotId);
            ItemStack cursorStack = playerinventory.func_70445_o();
            if (!(cursorStack.func_190926_b() || slot2.func_75216_d() && slot2.func_82869_a(player))) {
                ItemStack itemstack4;
                int l;
                ItemStack itemstack3;
                int j;
                int j1 = dragType == 0 ? 0 : this.getInventorySlotsSize() - 1;
                int i2 = dragType == 0 ? 1 : -1;
                for (j = 0; j < 2; ++j) {
                    for (int k = j1; k >= 0 && k < this.getInventorySlotsSize() && cursorStack.func_190916_E() < cursorStack.func_77976_d(); k += i2) {
                        Slot slot1 = this.func_75139_a(k);
                        if (!slot1.func_75216_d() || !BackpackContainer.canMergeItemToSlot(slot1, cursorStack) || !slot1.func_82869_a(player) || !this.func_94530_a(cursorStack, slot1)) continue;
                        itemstack3 = slot1.func_75211_c();
                        if (j == 0 && itemstack3.func_190916_E() == itemstack3.func_77976_d()) continue;
                        l = Math.min(cursorStack.func_77976_d() - cursorStack.func_190916_E(), itemstack3.func_190916_E());
                        itemstack4 = slot1.func_75209_a(l);
                        cursorStack.func_190917_f(l);
                        if (itemstack4.func_190926_b()) {
                            slot1.func_75215_d(ItemStack.field_190927_a);
                        }
                        slot1.func_190901_a(player, itemstack4);
                    }
                }
                j1 = dragType == 0 ? 0 : this.upgradeSlots.size() - 1;
                for (j = 0; j < 2; ++j) {
                    for (int upgradeSlotId = j1; upgradeSlotId >= 0 && upgradeSlotId < this.upgradeSlots.size() && cursorStack.func_190916_E() < cursorStack.func_77976_d(); upgradeSlotId += i2) {
                        Slot upgradeSlot = this.upgradeSlots.get(upgradeSlotId);
                        if (!upgradeSlot.func_75216_d() || !BackpackContainer.canMergeItemToSlot(upgradeSlot, cursorStack) || !upgradeSlot.func_82869_a(player) || !this.func_94530_a(cursorStack, upgradeSlot)) continue;
                        itemstack3 = upgradeSlot.func_75211_c();
                        if (j == 0 && itemstack3.func_190916_E() == itemstack3.func_77976_d()) continue;
                        l = Math.min(cursorStack.func_77976_d() - cursorStack.func_190916_E(), itemstack3.func_190916_E());
                        itemstack4 = upgradeSlot.func_75209_a(l);
                        cursorStack.func_190917_f(l);
                        if (itemstack4.func_190926_b()) {
                            upgradeSlot.func_75215_d(ItemStack.field_190927_a);
                        }
                        upgradeSlot.func_190901_a(player, itemstack4);
                    }
                }
            }
            this.func_75142_b();
        }
        this.sendSlotUpdates();
        return ret;
    }

    public void sendSlotUpdates() {
        if (!this.player.field_70170_p.field_72995_K) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)this.player;
            this.slotStacksToUpdate.forEach((slot, stack) -> serverPlayer.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(serverPlayer.field_71070_bA.field_75152_c, slot.intValue(), stack)));
            this.slotStacksToUpdate.clear();
        }
    }

    public static boolean canMergeItemToSlot(@Nullable Slot slot, ItemStack stack) {
        boolean flag;
        boolean bl = flag = slot == null || !slot.func_75216_d();
        if (!flag && stack.func_77969_a(slot.func_75211_c()) && ItemStack.func_77970_a((ItemStack)slot.func_75211_c(), (ItemStack)stack)) {
            return slot.func_75211_c().func_190916_E() <= BackpackContainer.calculateMaxCountForStack(slot.func_75219_a(), stack);
        }
        return flag;
    }

    private static int calculateMaxCountForStack(int slotLimit, ItemStack stack) {
        return slotLimit / 64 * stack.func_77976_d();
    }

    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return this.mergeItemStack(stack, startIndex, endIndex, reverseDirection, false);
    }

    protected boolean mergeItemStack(ItemStack sourceStack, int startIndex, int endIndex, boolean reverseDirection, boolean transferMaxStackSizeFromSource) {
        return this.mergeItemStack(sourceStack, startIndex, endIndex, reverseDirection, transferMaxStackSizeFromSource, false);
    }

    protected boolean mergeItemStack(ItemStack sourceStack, int startIndex, int endIndex, boolean reverseDirection, boolean transferMaxStackSizeFromSource, boolean runOverflowLogic) {
        int toTransfer;
        boolean mergedSomething = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        int n = toTransfer = transferMaxStackSizeFromSource ? Math.min(sourceStack.func_77976_d(), sourceStack.func_190916_E()) : sourceStack.func_190916_E();
        if (runOverflowLogic || sourceStack.func_77985_e() || this.func_75139_a(startIndex).func_75219_a() > 64) {
            while (toTransfer > 0 && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                ItemStack destStack;
                Slot slot = this.func_75139_a(i);
                if (slot.func_75214_a(sourceStack) && !(destStack = slot.func_75211_c()).func_190926_b() && BackpackContainer.func_195929_a((ItemStack)sourceStack, (ItemStack)destStack)) {
                    ItemStack result;
                    int maxSize;
                    int j = destStack.func_190916_E() + toTransfer;
                    if (j <= (maxSize = BackpackContainer.calculateMaxCountForStack(slot.func_75219_a(), sourceStack))) {
                        sourceStack.func_190918_g(toTransfer);
                        destStack.func_190920_e(j);
                        toTransfer = 0;
                        slot.func_75218_e();
                        mergedSomething = true;
                    } else if (destStack.func_190916_E() < maxSize) {
                        sourceStack.func_190918_g(maxSize - destStack.func_190916_E());
                        toTransfer -= maxSize - destStack.func_190916_E();
                        destStack.func_190920_e(maxSize);
                        slot.func_75218_e();
                        mergedSomething = true;
                    }
                    if (runOverflowLogic && !sourceStack.func_190926_b() && (result = this.processOverflowLogic(sourceStack)) != sourceStack) {
                        sourceStack.func_190920_e(result.func_190916_E());
                        mergedSomething = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (toTransfer > 0) {
            int firstIndex = reverseDirection ? endIndex - 1 : startIndex;
            int increment = reverseDirection ? -1 : 1;
            MemorySettingsCategory memory = this.backpackWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class);
            int slotIndex = firstIndex;
            while ((reverseDirection ? slotIndex >= startIndex : slotIndex < endIndex) && toTransfer > 0) {
                ItemStack destStack;
                Slot slot;
                if (memory.getSlotIndexes().contains(slotIndex) && memory.matchesFilter(slotIndex, sourceStack) && (slot = this.func_75139_a(slotIndex)).func_75214_a(sourceStack) && (destStack = slot.func_75211_c()).func_190926_b()) {
                    slot.func_75215_d(sourceStack.func_77979_a(slot.func_75219_a()));
                    slot.func_75218_e();
                    toTransfer = sourceStack.func_190916_E();
                    mergedSomething = true;
                }
                slotIndex += increment;
            }
        }
        if (toTransfer > 0) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot destSlot = this.func_75139_a(i);
                ItemStack itemstack1 = destSlot.func_75211_c();
                if (itemstack1.func_190926_b() && destSlot.func_75214_a(sourceStack) && !(destSlot instanceof IFilterSlot)) {
                    boolean errorMerging = false;
                    if (toTransfer > destSlot.func_75219_a()) {
                        destSlot.func_75215_d(sourceStack.func_77979_a(destSlot.func_75219_a()));
                    } else if (this.isUpgradeSlot(i)) {
                        IBackpackUpgradeItem backpackUpgradeItem;
                        int newColumnsTaken;
                        BackpackUpgradeSlot upgradeSlot = (BackpackUpgradeSlot)this.func_75139_a(i);
                        if (!this.needsSlotsThatAreOccupied(sourceStack, 0, upgradeSlot, newColumnsTaken = (backpackUpgradeItem = (IBackpackUpgradeItem)sourceStack.func_77973_b()).getInventoryColumnsTaken())) {
                            destSlot.func_75215_d(sourceStack.func_77979_a(toTransfer));
                            this.updateColumnsTaken(newColumnsTaken);
                        } else {
                            errorMerging = true;
                        }
                    } else {
                        destSlot.func_75215_d(sourceStack.func_77979_a(toTransfer));
                    }
                    if (!errorMerging) {
                        destSlot.func_75218_e();
                        mergedSomething = true;
                        break;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return mergedSomething;
    }

    private ItemStack processOverflowLogic(ItemStack stack) {
        IOverflowResponseUpgrade overflowUpgrade;
        ItemStack result = stack;
        Iterator<IOverflowResponseUpgrade> iterator = this.backpackWrapper.getUpgradeHandler().getWrappersThatImplement(IOverflowResponseUpgrade.class).iterator();
        while (!(!iterator.hasNext() || (overflowUpgrade = iterator.next()).worksInGui() && (result = overflowUpgrade.onOverflow(result)).func_190926_b())) {
        }
        return result;
    }

    public void func_75132_a(IContainerListener listener) {
        if (listener instanceof ServerPlayerEntity && this.backpackWrapper.getInventoryHandler().getStackSizeMultiplier() > 1) {
            super.func_75132_a((IContainerListener)new HighStackCountListener((ServerPlayerEntity)listener));
            return;
        }
        super.func_75132_a(listener);
    }

    public void func_75134_a(PlayerEntity player) {
        for (Slot slot : this.upgradeSlots) {
            if (slot instanceof BackpackUpgradeSlot || !this.isInventorySlotInUpgradeTab(player, slot) || !(slot.func_75211_c().func_77973_b() instanceof BackpackItem) || this.backpackWrapper.getInventoryHandler().isItemValid(0, slot.func_75211_c())) continue;
            ItemStack slotStack = slot.func_75211_c();
            slot.func_75215_d(ItemStack.field_190927_a);
            if (player.func_191521_c(slotStack)) continue;
            player.func_71019_a(slotStack, false);
        }
        super.func_75134_a(player);
        if (!player.field_70170_p.field_72995_K) {
            this.removeOpenTabIfKeepOff();
        }
    }

    private void removeOpenTabIfKeepOff() {
        if (Boolean.FALSE.equals(BackpackSettingsManager.getBackpackSettingValue(this.player, this.backpackWrapper.getSettingsHandler().getTypeCategory(BackpackSettingsCategory.class), BackpackSettingsManager.KEEP_TAB_OPEN))) {
            this.backpackWrapper.removeOpenTabId();
        }
    }

    private boolean isInventorySlotInUpgradeTab(PlayerEntity player, Slot slot) {
        return slot.func_82869_a(player) && !(slot instanceof CraftingResultSlot);
    }

    public void setSlotStackToUpdate(int slot, ItemStack stack) {
        this.slotStacksToUpdate.put(slot, stack);
    }

    public class BackpackUpgradeSlot
    extends SlotItemHandler {
        private boolean wasEmpty;

        public BackpackUpgradeSlot(BackpackUpgradeHandler upgradeHandler, int slotIndex, int yPosition) {
            super((IItemHandler)upgradeHandler, slotIndex, -15, yPosition);
            this.wasEmpty = false;
        }

        public void func_75218_e() {
            super.func_75218_e();
            if (!BackpackContainer.this.isUpdatingFromPacket && this.wasEmpty != this.func_75211_c().func_190926_b() || this.updateWrappersAndCheckForReloadNeeded()) {
                this.reloadUpgradeControl();
                if (!BackpackContainer.this.isFirstLevelBackpack()) {
                    BackpackContainer.this.parentBackpackWrapper.getUpgradeHandler().refreshUpgradeWrappers();
                }
                BackpackContainer.this.backpackContext.onUpgradeChanged(BackpackContainer.this.player);
            }
            this.wasEmpty = this.func_75211_c().func_190926_b();
        }

        public boolean func_75214_a(ItemStack stack) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IBackpackUpgradeItem)) {
                return false;
            }
            UpgradeSlotChangeResult result = ((IBackpackUpgradeItem)stack.func_77973_b()).canAddUpgradeTo(BackpackContainer.this.backpackWrapper, stack, BackpackContainer.this.isFirstLevelBackpack());
            this.updateSlotChangeError(result);
            return result.isSuccessful();
        }

        private void updateSlotChangeError(UpgradeSlotChangeResult result) {
            if (((BackpackContainer)BackpackContainer.this).player.field_70170_p.field_72995_K && !result.isSuccessful()) {
                BackpackContainer.this.errorUpgradeSlotChangeResult = result;
                BackpackContainer.this.errorResultExpirationTime = ((BackpackContainer)BackpackContainer.this).player.field_70170_p.func_82737_E() + 60L;
            }
        }

        public boolean func_82869_a(PlayerEntity player) {
            boolean ret = super.func_82869_a(player);
            if (!ret) {
                return false;
            }
            UpgradeSlotChangeResult result = ((IBackpackUpgradeItem)this.func_75211_c().func_77973_b()).canRemoveUpgradeFrom(BackpackContainer.this.backpackWrapper);
            this.updateSlotChangeError(result);
            return result.isSuccessful();
        }

        public boolean canSwapStack(PlayerEntity player, ItemStack stackToPut) {
            boolean ret = super.func_82869_a(player);
            if (!ret) {
                return false;
            }
            UpgradeSlotChangeResult result = ((IBackpackUpgradeItem)this.func_75211_c().func_77973_b()).canSwapUpgradeFor(stackToPut, BackpackContainer.this.backpackWrapper);
            this.updateSlotChangeError(result);
            return result.isSuccessful();
        }

        private boolean updateWrappersAndCheckForReloadNeeded() {
            int checkedContainersCount = 0;
            for (Map.Entry<Integer, IUpgradeWrapper> slotWrapper : BackpackContainer.this.backpackWrapper.getUpgradeHandler().getSlotWrappers().entrySet()) {
                UpgradeContainerBase container = (UpgradeContainerBase)BackpackContainer.this.upgradeContainers.get(slotWrapper.getKey());
                if (slotWrapper.getValue().hideSettingsTab()) {
                    if (container == null) continue;
                    return true;
                }
                if (container == null || container.getUpgradeWrapper().isEnabled() != slotWrapper.getValue().isEnabled()) {
                    return true;
                }
                if (container.getUpgradeWrapper() == slotWrapper.getValue()) continue;
                if (container.getUpgradeWrapper().getUpgradeStack().func_77973_b() != slotWrapper.getValue().getUpgradeStack().func_77973_b()) {
                    return true;
                }
                container.setUpgradeWrapper(slotWrapper.getValue());
                ++checkedContainersCount;
            }
            return checkedContainersCount != BackpackContainer.this.upgradeContainers.size();
        }

        private void reloadUpgradeControl() {
            BackpackContainer.this.backpackWrapper.removeOpenTabId();
            this.removeUpgradeSettingsSlots();
            BackpackContainer.this.upgradeContainers.clear();
            BackpackContainer.this.addUpgradeSettingsContainers(BackpackContainer.this.player);
            this.onUpgradesChanged();
        }

        private void removeUpgradeSettingsSlots() {
            ArrayList slotNumbersToRemove = new ArrayList();
            for (UpgradeContainerBase container : BackpackContainer.this.upgradeContainers.values()) {
                container.getSlots().forEach(slot -> {
                    int upgradeSlotIndex = slot.field_75222_d - BackpackContainer.this.getInventorySlotsSize();
                    slotNumbersToRemove.add(upgradeSlotIndex);
                    BackpackContainer.this.upgradeSlots.remove(slot);
                });
            }
            slotNumbersToRemove.sort(IntComparators.OPPOSITE_COMPARATOR);
            Iterator<Object> iterator = slotNumbersToRemove.iterator();
            while (iterator.hasNext()) {
                int slotNumber = (Integer)iterator.next();
                BackpackContainer.this.upgradeItemStacks.remove(slotNumber);
            }
        }

        private void onUpgradesChanged() {
            if (BackpackContainer.this.upgradeChangeListener != null) {
                BackpackContainer.this.upgradeChangeListener.accept(BackpackContainer.this);
            }
        }

        @Nullable
        public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
            return new Pair((Object)PlayerContainer.field_226615_c_, (Object)EMPTY_UPGRADE_SLOT_BACKGROUND);
        }
    }
}

