/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.blocks;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ResultCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.FakePlayerGetter;
import mcjty.lib.varia.InventoryTools;
import mcjty.lib.varia.ItemStackTools;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.SoundTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.compat.JEIRecipeAcceptor;
import mcjty.rftoolsbase.api.infoscreen.CapabilityInformationScreenInfo;
import mcjty.rftoolsbase.api.infoscreen.IInformationScreenInfo;
import mcjty.rftoolsbase.api.storage.IInventoryTracker;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsstorage.RFToolsStorage;
import mcjty.rftoolsstorage.craftinggrid.CraftingGrid;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridInventory;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.CraftingRecipe;
import mcjty.rftoolsstorage.craftinggrid.StorageCraftingTools;
import mcjty.rftoolsstorage.craftinggrid.TileEntityItemSource;
import mcjty.rftoolsstorage.modules.craftingmanager.blocks.CraftingManagerTileEntity;
import mcjty.rftoolsstorage.modules.craftingmanager.system.CraftingSystem;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerConfiguration;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerModule;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerContainer;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerInformationScreenInfo;
import mcjty.rftoolsstorage.modules.scanner.tools.CachedItemCount;
import mcjty.rftoolsstorage.modules.scanner.tools.CachedItemKey;
import mcjty.rftoolsstorage.modules.scanner.tools.InventoryAccessSettings;
import mcjty.rftoolsstorage.modules.scanner.tools.SortingMode;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.StringUtils;

public class StorageScannerTileEntity
extends TickingTileEntity
implements CraftingGridProvider,
JEIRecipeAcceptor,
IStorageScanner {
    public static final Key<Integer> PARAM_INDEX = new Key("index", Type.INTEGER);
    public static final Key<BlockPos> PARAM_POS = new Key("pos", Type.BLOCKPOS);
    public static final Key<Boolean> PARAM_VIEW = new Key("view", Type.BOOLEAN);
    @GuiValue(name="export")
    private boolean exportToCurrent = false;
    @GuiValue
    public static final Value<?, Integer> VALUE_RADIUS = Value.create((String)"radius", (Type)Type.INTEGER, StorageScannerTileEntity::getRadius, StorageScannerTileEntity::setRadius);
    @GuiValue
    private SortingMode sortMode = SortingMode.NAME;
    public long rfReceived = 0L;
    public boolean exportToCurrentReceived = false;
    private final FakePlayerGetter lazyPlayer = new FakePlayerGetter((GenericTileEntity)this, "rftools_storage");
    public static final int XNETDELAY = 40;
    private final CraftingSystem craftingSystem = new CraftingSystem(this);
    private List<BlockPos> inventories = new ArrayList<BlockPos>();
    private List<BlockPos> craftingInventories = null;
    private final Set<BlockPos> inventoriesFromXNet = new HashSet<BlockPos>();
    private Map<BlockPos, InventoryAccessSettings> xnetAccess = Collections.emptyMap();
    private int xnetDelay = 40;
    private final Map<CachedItemKey, CachedItemCount> cachedCounts = new HashMap<CachedItemKey, CachedItemCount>();
    private final Set<BlockPos> routable = new HashSet<BlockPos>();
    private int radius = 1;
    private BlockPos lastSelectedInventory = null;
    @GuiValue
    private boolean openWideView = true;
    private final LazyOptional<IInformationScreenInfo> infoScreenInfo = LazyOptional.of(this::createScreenInfo);
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)StorageScannerConfiguration.MAXENERGY.get()).intValue(), (long)((Integer)StorageScannerConfiguration.RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.ITEMS)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, StorageScannerContainer.CONTAINER_FACTORY).insertable(GenericItemHandler.slot((int)2)).build();
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Storage Scanner").containerSupplier((windowId, player) -> StorageScannerContainer.create(windowId, this.func_174877_v(), this, player)).energyHandler(() -> this.energyStorage).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((TileEntity)this));
    private final CraftingGrid craftingGrid = new CraftingGrid();
    private RegistryKey<World> dummyType = null;
    private static final ItemStack DUMMY = new ItemStack((IItemProvider)Items.field_221598_z, 666);
    @ServerCommand
    public static final Command<?> CMD_CLEARGRID = Command.create((String)"clearGrid", (te, player, params) -> te.clearGrid());
    @ServerCommand
    public static final Command<?> CMD_UP = Command.create((String)"scanner.up", (te, player, params) -> te.moveUp((Integer)params.get(PARAM_INDEX)));
    @ServerCommand
    public static final Command<?> CMD_TOP = Command.create((String)"scanner.top", (te, player, params) -> te.moveTop((Integer)params.get(PARAM_INDEX)));
    @ServerCommand
    public static final Command<?> CMD_DOWN = Command.create((String)"scanner.down", (te, player, params) -> te.moveDown((Integer)params.get(PARAM_INDEX)));
    @ServerCommand
    public static final Command<?> CMD_BOTTOM = Command.create((String)"scanner.bottom", (te, player, params) -> te.moveBottom((Integer)params.get(PARAM_INDEX)));
    @ServerCommand
    public static final Command<?> CMD_REMOVE = Command.create((String)"scanner.remove", (te, player, params) -> te.removeInventory((Integer)params.get(PARAM_INDEX)));
    @ServerCommand
    public static final Command<?> CMD_TOGGLEROUTABLE = Command.create((String)"scanner.toggleRoutable", (te, player, params) -> te.toggleRoutable((BlockPos)params.get(PARAM_POS)));
    @ServerCommand
    public static final Command<?> CMD_SETVIEW = Command.create((String)"scanner.setView", (te, player, params) -> te.setOpenWideView((Boolean)params.get(PARAM_VIEW)));
    public static final Key<Long> PARAM_ENERGY = new Key("energy", Type.LONG);
    public static final Key<Boolean> PARAM_EXPORT = new Key("export", Type.BOOLEAN);
    @ServerCommand
    public static final ResultCommand<?> CMD_SCANNER_INFO = ResultCommand.create((String)"getScannerInfo", (te, player, params) -> TypedMap.builder().put(PARAM_ENERGY, (Object)te.getStoredPower()).put(PARAM_EXPORT, (Object)te.isExportToCurrent()).build(), (te, player, params) -> {
        te.rfReceived = (Long)params.get(PARAM_ENERGY);
        te.exportToCurrentReceived = (Boolean)params.get(PARAM_EXPORT);
    });

    public StorageScannerTileEntity() {
        super((TileEntityType)StorageScannerModule.TYPE_STORAGE_SCANNER.get());
        this.radius = (Boolean)StorageScannerConfiguration.xnetRequired.get() != false && RFToolsStorage.setup.xnet ? 0 : 1;
    }

    public StorageScannerTileEntity(RegistryKey<World> type) {
        this();
        this.dummyType = type;
    }

    @Override
    public void storeRecipe(int index) {
        this.getCraftingGrid().storeRecipe(index);
    }

    @Override
    public void setRecipe(int index, ItemStack[] stacks) {
        this.craftingGrid.setRecipe(index, stacks);
        this.func_70296_d();
    }

    @Override
    public CraftingGrid getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public void markInventoryDirty() {
        this.func_70296_d();
    }

    @Override
    @Nonnull
    public int[] craft(PlayerEntity player, int n, boolean test) {
        CraftingRecipe activeRecipe = this.craftingGrid.getActiveRecipe();
        return this.craft(player, n, test, activeRecipe);
    }

    @Nonnull
    public int[] craft(PlayerEntity player, int n, boolean test, CraftingRecipe activeRecipe) {
        TileEntityItemSource itemSource = new TileEntityItemSource().add((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), 0);
        this.inventories.stream().filter(p -> this.isOutputFromGui((BlockPos)p) && this.isRoutable((BlockPos)p)).forEachOrdered(p -> {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(p);
            if (!(tileEntity instanceof CraftingManagerTileEntity) && tileEntity != null && !(tileEntity instanceof StorageScannerTileEntity)) {
                itemSource.add(tileEntity, 0);
            }
        });
        if (test) {
            return StorageCraftingTools.testCraftItems(player, n, activeRecipe, itemSource);
        }
        StorageCraftingTools.craftItems(player, n, activeRecipe, itemSource);
        return new int[0];
    }

    public void setGridContents(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.craftingGrid.getCraftingGridInventory().setStackInSlot(i, stacks.get(i));
        }
        this.func_70296_d();
    }

    private long getStoredPower() {
        return this.energyStorage.getEnergy();
    }

    private void consumeEnergy(long e) {
        this.energyStorage.consumeEnergy(e);
    }

    protected void tickServer() {
        ItemStack stack;
        this.craftingSystem.tick(this.field_145850_b);
        --this.xnetDelay;
        if (this.xnetDelay < 0) {
            this.xnetAccess = Collections.emptyMap();
            this.xnetDelay = 40;
        }
        if (!this.items.getStackInSlot(0).func_190926_b()) {
            if (this.getStoredPower() < (long)((Integer)StorageScannerConfiguration.rfPerInsert.get()).intValue()) {
                return;
            }
            stack = this.items.getStackInSlot(0);
            stack = this.injectStackInternal(stack, this.exportToCurrent, (Function<BlockPos, Boolean>)((Function)this::isInputFromGui));
            this.items.setStackInSlot(0, stack);
            this.consumeEnergy(((Integer)StorageScannerConfiguration.rfPerInsert.get()).intValue());
        }
        if (!this.items.getStackInSlot(2).func_190926_b()) {
            if (this.getStoredPower() < (long)((Integer)StorageScannerConfiguration.rfPerInsert.get()).intValue()) {
                return;
            }
            stack = this.items.getStackInSlot(2);
            stack = this.injectStackInternal(stack, false, (Function<BlockPos, Boolean>)((Function)this::isInputFromAuto));
            this.items.setStackInSlot(2, stack);
            this.consumeEnergy(((Integer)StorageScannerConfiguration.rfPerInsert.get()).intValue());
        }
    }

    public ItemStack injectStackFromScreen(ItemStack stack, PlayerEntity player) {
        if (this.getStoredPower() < (long)((Integer)StorageScannerConfiguration.rfPerInsert.get()).intValue()) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Not enough power to insert items!"), false);
            return stack;
        }
        if (!this.checkForRoutableInventories()) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "There are no routable inventories!"), false);
            return stack;
        }
        if ((stack = this.injectStackInternal(stack, false, (Function<BlockPos, Boolean>)((Function)this::isInputFromScreen))).func_190926_b()) {
            this.consumeEnergy(((Integer)StorageScannerConfiguration.rfPerInsert.get()).intValue());
            SoundTools.playSound((World)this.field_145850_b, (SoundEvent)SoundEvents.field_187638_cR, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)1.0, (double)3.0);
        }
        return stack;
    }

    private boolean checkForRoutableInventories() {
        return this.inventories.stream().filter(p -> this.isValid((BlockPos)p) && !p.equals((Object)this.func_174877_v()) && this.isRoutable((BlockPos)p) && LevelTools.isLoaded((World)this.field_145850_b, (BlockPos)p)).anyMatch(p -> this.field_145850_b.func_175625_s(p) != null);
    }

    private ItemStack injectStackInternal(ItemStack stack, boolean toSelected, @Nonnull Function<BlockPos, Boolean> testAccess) {
        if (toSelected && this.lastSelectedInventory != null && this.lastSelectedInventory.func_177956_o() != -1) {
            TileEntity te2 = this.field_145850_b.func_175625_s(this.lastSelectedInventory);
            if (te2 != null && !(te2 instanceof StorageScannerTileEntity) && ((Boolean)testAccess.apply((Object)this.lastSelectedInventory)).booleanValue() && this.getInputMatcher(this.lastSelectedInventory).test(stack) && (stack = InventoryTools.insertItem((World)this.field_145850_b, (BlockPos)this.lastSelectedInventory, null, (ItemStack)stack)).func_190926_b()) {
                return stack;
            }
            return stack;
        }
        ItemStack finalStack = stack;
        Iterator iterator = this.inventories.stream().filter(p -> (Boolean)testAccess.apply(p) != false && !p.equals((Object)this.func_174877_v()) && this.isRoutable((BlockPos)p) && LevelTools.isLoaded((World)this.field_145850_b, (BlockPos)p) && this.getInputMatcher((BlockPos)p).test(finalStack)).map(arg_0 -> ((World)this.field_145850_b).func_175625_s(arg_0)).filter(te -> te != null && !(te instanceof StorageScannerTileEntity) && !(te instanceof CraftingManagerTileEntity)).iterator();
        while (!stack.func_190926_b() && iterator.hasNext()) {
            TileEntity te3 = (TileEntity)iterator.next();
            stack = InventoryTools.insertItem((World)this.field_145850_b, (BlockPos)te3.func_174877_v(), null, (ItemStack)stack);
        }
        return stack;
    }

    public void giveToPlayerFromScreen(ItemStack stack, boolean single, PlayerEntity player) {
        if (stack.func_190926_b()) {
            return;
        }
        if (this.getStoredPower() < (long)((Integer)StorageScannerConfiguration.rfPerRequest.get()).intValue()) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Not enough power to request items!"), false);
            return;
        }
        int[] cnt = new int[]{single ? 1 : stack.func_77976_d()};
        int orig = cnt[0];
        this.inventories.stream().filter(this::isOutputFromScreen).map(this::getItemHandlerAt).forEachOrdered(handler -> handler.ifPresent(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                ItemStack itemStack = h.getStackInSlot(i);
                if (!StorageScannerTileEntity.isItemEqual(stack, itemStack)) continue;
                ItemStack received = h.extractItem(i, cnt[0], false);
                this.giveItemToPlayer(player, cnt, received);
            }
        }));
        if (orig != cnt[0]) {
            this.consumeEnergy(((Integer)StorageScannerConfiguration.rfPerRequest.get()).intValue());
            SoundTools.playSound((World)this.field_145850_b, (SoundEvent)SoundEvents.field_187638_cR, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)1.0, (double)1.0);
        }
    }

    private boolean giveItemToPlayer(PlayerEntity player, int[] cnt, ItemStack received) {
        if (!received.func_190926_b() && cnt[0] > 0) {
            cnt[0] = cnt[0] - received.func_190916_E();
            this.giveToPlayer(received, player);
            return true;
        }
        return false;
    }

    private boolean giveToPlayer(ItemStack stack, PlayerEntity player) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_70099_a(stack, 1.05f);
        }
        return true;
    }

    public int countItems(Predicate<ItemStack> matcher, boolean starred, @Nullable Integer maxneeded) {
        int[] cc = new int[]{0};
        this.inventories.stream().filter(p -> this.isValid((BlockPos)p) && (!starred || this.isRoutable((BlockPos)p)) && LevelTools.isLoaded((World)this.field_145850_b, (BlockPos)p)).map(arg_0 -> ((World)this.field_145850_b).func_175625_s(arg_0)).filter(te -> te != null && !(te instanceof StorageScannerTileEntity) && !(te instanceof CraftingManagerTileEntity)).allMatch(te -> {
            InventoryTools.getItems((TileEntity)te, (Predicate)matcher).forEach(s -> {
                cc[0] = cc[0] + s.func_190916_E();
            });
            return maxneeded == null || cc[0] < maxneeded;
        });
        return cc[0];
    }

    @Nonnull
    public ItemStack getItem(Predicate<ItemStack> matcher, boolean starred) {
        return this.inventories.stream().filter(p -> this.isValid((BlockPos)p) && (!starred || this.isRoutable((BlockPos)p)) && LevelTools.isLoaded((World)this.field_145850_b, (BlockPos)p)).map(arg_0 -> ((World)this.field_145850_b).func_175625_s(arg_0)).filter(te -> te != null && !(te instanceof StorageScannerTileEntity) && !(te instanceof CraftingManagerTileEntity)).map(te -> InventoryTools.getFirstMatchingItem((TileEntity)te, (Predicate)matcher)).filter(s -> !s.func_190926_b()).findFirst().orElse(ItemStack.field_190927_a);
    }

    public int countItems(ItemStack match, boolean routable) {
        return this.countItems(match, routable, null);
    }

    public int countItems(ItemStack stack, boolean starred, @Nullable Integer maxneeded) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Iterator iterator = this.inventories.stream().filter(p -> this.isValid((BlockPos)p) && (!starred || this.isRoutable((BlockPos)p)) && LevelTools.isLoaded((World)this.field_145850_b, (BlockPos)p)).map(arg_0 -> ((World)this.field_145850_b).func_175625_s(arg_0)).filter(te -> te != null && !(te instanceof StorageScannerTileEntity) && !(te instanceof CraftingManagerTileEntity)).iterator();
        int cnt = 0;
        while (iterator.hasNext()) {
            TileEntity te2 = (TileEntity)iterator.next();
            Integer cachedCount = null;
            if (te2 instanceof IInventoryTracker) {
                Integer oldVersion;
                IInventoryTracker tracker = (IInventoryTracker)te2;
                CachedItemCount itemCount = this.cachedCounts.get(new CachedItemKey(te2.func_174877_v(), stack.func_77973_b(), 0));
                if (itemCount != null && (oldVersion = Integer.valueOf(itemCount.getVersion())).intValue() == tracker.getVersion()) {
                    cachedCount = itemCount.getCount();
                }
            }
            if (cachedCount != null) {
                cnt += cachedCount.intValue();
            } else {
                int[] cc = new int[]{0};
                InventoryTools.getItems((TileEntity)te2, s -> StorageScannerTileEntity.isItemEqual(stack, s)).forEach(s -> {
                    cc[0] = cc[0] + s.func_190916_E();
                });
                if (te2 instanceof IInventoryTracker) {
                    IInventoryTracker tracker = (IInventoryTracker)te2;
                    this.cachedCounts.put(new CachedItemKey(te2.func_174877_v(), stack.func_77973_b(), 0), new CachedItemCount(tracker.getVersion(), cc[0]));
                }
                cnt += cc[0];
            }
            if (maxneeded == null || cnt < maxneeded) continue;
            break;
        }
        return cnt;
    }

    public static boolean isItemEqual(ItemStack thisItem, ItemStack other) {
        if (other.func_190926_b()) {
            return false;
        }
        return thisItem.func_77969_a(other);
    }

    public Set<BlockPos> performSearch(String search) {
        Predicate<ItemStack> matcher = StorageScannerTileEntity.getMatcher(search);
        HashSet<BlockPos> output = new HashSet<BlockPos>();
        this.inventories.stream().filter(this::isValid).map(arg_0 -> ((World)this.field_145850_b).func_175625_s(arg_0)).filter(te -> te != null && !(te instanceof StorageScannerTileEntity)).forEach(te -> InventoryTools.getItems((TileEntity)te, (Predicate)matcher).forEach(s -> output.add(te.func_174877_v())));
        return output;
    }

    public static Predicate<ItemStack> getMatcher(String search) {
        String[] splitted;
        Predicate<ItemStack> matcher = null;
        search = search.toLowerCase();
        for (String split : splitted = StringUtils.split((String)search)) {
            matcher = matcher == null ? StorageScannerTileEntity.makeSearchPredicate(split) : matcher.and(StorageScannerTileEntity.makeSearchPredicate(split));
        }
        if (matcher == null) {
            matcher = s -> true;
        }
        return matcher;
    }

    private static Predicate<ItemStack> makeSearchPredicate(String split) {
        if (split.startsWith("@")) {
            return s -> Tools.getModid((ItemStack)s).toLowerCase().startsWith(split.substring(1));
        }
        return s -> s.func_200301_q().getString().toLowerCase().contains(split);
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int v) {
        this.radius = v;
        if (((Boolean)StorageScannerConfiguration.xnetRequired.get()).booleanValue() && RFToolsStorage.setup.xnet) {
            this.radius = 0;
        }
        this.func_70296_d();
    }

    public boolean isOpenWideView() {
        return this.openWideView;
    }

    public void setOpenWideView(boolean openWideView) {
        this.openWideView = openWideView;
        this.func_70296_d();
    }

    public boolean isExportToCurrent() {
        return this.exportToCurrent;
    }

    public void setExportToCurrent(boolean exportToCurrent) {
        this.exportToCurrent = exportToCurrent;
        this.func_70296_d();
    }

    private void toggleExportRoutable() {
        this.exportToCurrent = !this.exportToCurrent;
        this.func_70296_d();
    }

    public boolean isRoutable(BlockPos p) {
        return this.routable.contains(p);
    }

    public boolean isValid(BlockPos p) {
        if (this.xnetAccess.containsKey(p)) {
            return true;
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public boolean isOutputFromGui(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return !settings.isBlockOutputGui();
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public boolean isOutputFromScreen(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return !settings.isBlockOutputScreen();
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public boolean isOutputFromAuto(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return !settings.isBlockOutputAuto();
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public Predicate<ItemStack> getInputMatcher(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return settings.getMatcher();
        }
        return stack -> true;
    }

    public boolean isInputFromGui(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return !settings.isBlockInputGui();
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public boolean isInputFromScreen(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return !settings.isBlockInputScreen();
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public boolean isInputFromAuto(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return !settings.isBlockInputAuto();
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public void toggleRoutable(BlockPos p) {
        if (this.routable.contains(p)) {
            this.routable.remove(p);
        } else {
            this.routable.add(p);
        }
        this.func_70296_d();
    }

    public void register(Map<BlockPos, InventoryAccessSettings> access) {
        this.xnetAccess = access;
        this.xnetDelay = 40;
    }

    private void moveUp(int index) {
        if (index <= 0) {
            return;
        }
        if (index >= this.inventories.size()) {
            return;
        }
        BlockPos p1 = this.inventories.get(index - 1);
        BlockPos p2 = this.inventories.get(index);
        this.inventories.set(index - 1, p2);
        this.inventories.set(index, p1);
        this.func_70296_d();
    }

    private void moveTop(int index) {
        if (index <= 0) {
            return;
        }
        if (index >= this.inventories.size()) {
            return;
        }
        BlockPos p = this.inventories.get(index);
        this.inventories.remove(index);
        this.inventories.add(0, p);
        this.func_70296_d();
    }

    private void moveDown(int index) {
        if (index < 0) {
            return;
        }
        if (index >= this.inventories.size() - 1) {
            return;
        }
        BlockPos p1 = this.inventories.get(index);
        BlockPos p2 = this.inventories.get(index + 1);
        this.inventories.set(index, p2);
        this.inventories.set(index + 1, p1);
        this.func_70296_d();
    }

    private void moveBottom(int index) {
        if (index < 0) {
            return;
        }
        if (index >= this.inventories.size() - 1) {
            return;
        }
        BlockPos p = this.inventories.get(index);
        this.inventories.remove(index);
        this.inventories.add(p);
        this.func_70296_d();
    }

    private void removeInventory(int index) {
        if (index < 0) {
            return;
        }
        if (index >= this.inventories.size()) {
            return;
        }
        BlockPos p = this.inventories.get(index);
        if (this.inventoriesFromXNet.contains(p)) {
            return;
        }
        BlockPos removed = this.inventories.remove(index);
        if (this.craftingInventories != null) {
            this.craftingInventories.remove(removed);
        }
        this.func_70296_d();
    }

    private boolean canPlayerAccess(PlayerEntity fakePlayer, BlockPos p) {
        if (((Boolean)StorageScannerConfiguration.scannerNoRestrictions.get()).booleanValue()) {
            return true;
        }
        return this.field_145850_b.func_180495_p(p).canEntityDestroy((IBlockReader)this.field_145850_b, p, (Entity)fakePlayer);
    }

    public void clearCachedCounts() {
        this.cachedCounts.clear();
    }

    public Stream<BlockPos> findInventories() {
        if (RFToolsStorage.setup.xnet && ((Boolean)StorageScannerConfiguration.xnetRequired.get()).booleanValue()) {
            this.radius = 0;
        }
        this.cachedCounts.clear();
        this.inventoriesFromXNet.clear();
        List<BlockPos> old = this.inventories;
        HashSet<BlockPos> oldAdded = new HashSet<BlockPos>();
        HashSet<BlockPos> seenPositions = new HashSet<BlockPos>();
        this.inventories = new ArrayList<BlockPos>();
        this.craftingInventories = new ArrayList<BlockPos>();
        ServerPlayerEntity fakePlayer = this.lazyPlayer.get();
        for (BlockPos p : old) {
            TileEntity te;
            if (!this.xnetAccess.containsKey(p) && !this.inRange(p) || (te = this.field_145850_b.func_175625_s(p)) == null || te instanceof StorageScannerTileEntity || !this.canPlayerAccess((PlayerEntity)fakePlayer, p)) continue;
            if (te instanceof CraftingManagerTileEntity) {
                if (!seenPositions.add(p)) continue;
                this.inventories.add(p);
                this.craftingInventories.add(p);
                oldAdded.add(p);
                continue;
            }
            te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                if (seenPositions.add(p)) {
                    this.inventories.add(p);
                    oldAdded.add(p);
                }
            });
        }
        for (int x = this.func_174877_v().func_177958_n() - this.radius; x <= this.func_174877_v().func_177958_n() + this.radius; ++x) {
            for (int z = this.func_174877_v().func_177952_p() - this.radius; z <= this.func_174877_v().func_177952_p() + this.radius; ++z) {
                for (int y = this.func_174877_v().func_177956_o() - this.radius; y <= this.func_174877_v().func_177956_o() + this.radius; ++y) {
                    BlockPos p = new BlockPos(x, y, z);
                    this.inventoryAddNew(oldAdded, seenPositions, p);
                }
            }
        }
        for (BlockPos p : this.xnetAccess.keySet()) {
            this.inventoryAddNew(oldAdded, seenPositions, p);
            this.inventoriesFromXNet.add(p);
        }
        return this.getAllInventories();
    }

    public List<BlockPos> getCraftingInventories() {
        if (this.craftingInventories == null) {
            this.craftingInventories = new ArrayList<BlockPos>();
            this.getAllInventories().forEach(pos -> {
                if (this.field_145850_b.func_175625_s(pos) instanceof CraftingManagerTileEntity) {
                    this.craftingInventories.add((BlockPos)pos);
                }
            });
        }
        return this.craftingInventories;
    }

    public Stream<BlockPos> getAllInventories() {
        return this.inventories.stream().filter(this::isValid);
    }

    private void inventoryAddNew(Set<BlockPos> oldAdded, Set<BlockPos> seenPositions, BlockPos p) {
        if (!oldAdded.contains(p)) {
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (this.canPlayerAccess((PlayerEntity)this.lazyPlayer.get(), p) && te != null && !(te instanceof StorageScannerTileEntity)) {
                if (te instanceof CraftingManagerTileEntity) {
                    if (seenPositions.add(p)) {
                        this.inventories.add(p);
                        this.craftingInventories.add(p);
                    }
                } else if (!this.inventories.contains(p)) {
                    te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                        if (seenPositions.add(p)) {
                            this.inventories.add(p);
                        }
                    });
                }
            }
        }
    }

    private boolean inRange(BlockPos p) {
        return p.func_177958_n() >= this.func_174877_v().func_177958_n() - this.radius && p.func_177958_n() <= this.func_174877_v().func_177958_n() + this.radius && p.func_177956_o() >= this.func_174877_v().func_177956_o() - this.radius && p.func_177956_o() <= this.func_174877_v().func_177956_o() + this.radius && p.func_177952_p() >= this.func_174877_v().func_177952_p() - this.radius && p.func_177952_p() <= this.func_174877_v().func_177952_p() + this.radius;
    }

    public ItemStack requestItem(Predicate<ItemStack> matcher, boolean simulate, int amount, boolean doRoutable) {
        if (this.getStoredPower() < (long)((Integer)StorageScannerConfiguration.rfPerRequest.get()).intValue()) {
            return ItemStack.field_190927_a;
        }
        ServerPlayerEntity fakePlayer = this.lazyPlayer.get();
        return this.inventories.stream().filter(p -> this.isOutputFromAuto((BlockPos)p) && (!doRoutable || this.isRoutable((BlockPos)p))).filter(p -> !(this.field_145850_b.func_175625_s(p) instanceof CraftingManagerTileEntity)).filter(arg_0 -> this.lambda$requestItem$37((PlayerEntity)fakePlayer, arg_0)).map(this::getItemHandlerAt).map(handler -> handler.map(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                ItemStack received;
                ItemStack itemStack = h.getStackInSlot(i);
                if (!matcher.test(itemStack) || (received = h.extractItem(i, amount, simulate)).func_190926_b()) continue;
                return received.func_77946_l();
            }
            return DUMMY;
        }).orElse(DUMMY)).filter(s -> s != DUMMY).findFirst().orElse(ItemStack.field_190927_a);
    }

    public ItemStack requestItem(ItemStack match, int amount, boolean doRoutable) {
        if (match.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.getStoredPower() < (long)((Integer)StorageScannerConfiguration.rfPerRequest.get()).intValue()) {
            return ItemStack.field_190927_a;
        }
        ItemStack[] result = new ItemStack[]{ItemStack.field_190927_a};
        int[] cnt = new int[]{match.func_77976_d() < amount ? match.func_77976_d() : amount};
        ServerPlayerEntity fakePlayer = this.lazyPlayer.get();
        this.inventories.stream().filter(p -> this.isOutputFromAuto((BlockPos)p) && !doRoutable || this.isRoutable((BlockPos)p)).filter(p -> !(this.field_145850_b.func_175625_s(p) instanceof CraftingManagerTileEntity)).filter(arg_0 -> this.lambda$requestItem$43((PlayerEntity)fakePlayer, arg_0)).map(this::getItemHandlerAt).allMatch(handler -> {
            handler.ifPresent(h -> {
                for (int i = 0; i < h.getSlots(); ++i) {
                    ItemStack received;
                    ItemStack itemStack = h.getStackInSlot(i);
                    if (!StorageScannerTileEntity.isItemEqual(match, itemStack) || (received = h.extractItem(i, cnt[0], false)).func_190926_b()) continue;
                    if (result[0].func_190926_b()) {
                        result[0] = received;
                    } else {
                        result[0].func_190917_f(received.func_190916_E());
                    }
                    cnt[0] = cnt[0] - received.func_190916_E();
                }
            });
            return cnt[0] > 0;
        });
        if (!result[0].func_190926_b()) {
            this.consumeEnergy(((Integer)StorageScannerConfiguration.rfPerRequest.get()).intValue());
        }
        return result[0];
    }

    @Nonnull
    private LazyOptional<IItemHandler> getItemHandlerAt(BlockPos p) {
        if (!LevelTools.isLoaded((World)this.field_145850_b, (BlockPos)p)) {
            return LazyOptional.empty();
        }
        TileEntity te = this.field_145850_b.func_175625_s(p);
        if (te == null || te instanceof StorageScannerTileEntity) {
            return LazyOptional.empty();
        }
        return StorageScannerTileEntity.getItemHandlerAt(te, null);
    }

    @Nonnull
    private static LazyOptional<IItemHandler> getItemHandlerAt(@Nullable TileEntity te, Direction intSide) {
        if (te != null) {
            return te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, intSide);
        }
        return LazyOptional.empty();
    }

    public int insertItem(ItemStack stack) {
        ItemStack s = this.insertItem(stack, false);
        return s.func_190916_E();
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        if (this.getStoredPower() < (long)((Integer)StorageScannerConfiguration.rfPerInsert.get()).intValue()) {
            return stack;
        }
        ItemStack result = this.insertInternal(stack, simulate);
        this.consumeEnergy(((Integer)StorageScannerConfiguration.rfPerInsert.get()).intValue());
        return result;
    }

    public ItemStack insertInternal(ItemStack stack, boolean simulate) {
        ItemStack[] toInsert = new ItemStack[]{stack.func_77946_l()};
        ServerPlayerEntity fakePlayer = this.lazyPlayer.get();
        Iterator iterator = this.inventories.stream().filter(p -> this.isInputFromAuto((BlockPos)p) && !p.equals((Object)this.func_174877_v()) && this.isRoutable((BlockPos)p) && this.getInputMatcher((BlockPos)p).test(stack)).filter(p -> !(this.field_145850_b.func_175625_s(p) instanceof CraftingManagerTileEntity)).filter(arg_0 -> this.lambda$insertInternal$48((PlayerEntity)fakePlayer, arg_0)).map(this::getItemHandlerAt).filter(LazyOptional::isPresent).iterator();
        while (!toInsert[0].func_190926_b() && iterator.hasNext()) {
            LazyOptional handler = (LazyOptional)iterator.next();
            handler.ifPresent(h -> {
                toInsert[0] = ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)toInsert[0], (boolean)simulate);
            });
        }
        return toInsert[0];
    }

    private ItemStack requestStackFromInv(BlockPos invPos, ItemStack requested, Integer[] todo, ItemStack outSlot) {
        TileEntity tileEntity = this.field_145850_b.func_175625_s(invPos);
        if (tileEntity instanceof StorageScannerTileEntity) {
            return outSlot;
        }
        int size = InventoryTools.getInventorySize((TileEntity)tileEntity);
        for (int i = 0; i < size; ++i) {
            ItemStack stack = ItemStackTools.getStack((TileEntity)tileEntity, (int)i);
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)requested, (ItemStack)stack)) continue;
            ItemStack extracted = ItemStackTools.extractItem((TileEntity)tileEntity, (int)i, (int)todo[0]);
            Integer[] integerArray = todo;
            Integer.valueOf(integerArray[0] - extracted.func_190916_E());
            if (outSlot.func_190926_b()) {
                outSlot = extracted;
            } else {
                outSlot.func_190917_f(extracted.func_190916_E());
            }
            if (todo[0] == 0) break;
        }
        return outSlot;
    }

    @Nullable
    public List<ItemStack> requestIngredients(List<Ingredient> ingredients, Consumer<Ingredient> missingIngredientConsumer, boolean extract) {
        ArrayList<Ingredient> missing = new ArrayList<Ingredient>();
        for (Ingredient ingredient : ingredients) {
            ItemStack stack = this.requestItem((Predicate<ItemStack>)ingredient, true, 1, true);
            if (!stack.func_190926_b() || ingredient.test(stack)) continue;
            missing.add(ingredient);
        }
        if (missing.isEmpty()) {
            if (extract) {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (Ingredient ingredient : ingredients) {
                    ItemStack stack = this.requestItem((Predicate<ItemStack>)ingredient, false, 1, true);
                    stacks.add(stack);
                }
                return stacks;
            }
            return Collections.emptyList();
        }
        for (Ingredient ingredient : missing) {
            if (this.getAllInventories().anyMatch(p -> {
                CraftingManagerTileEntity craftingManager;
                TileEntity te = this.field_145850_b.func_175625_s(p);
                if (te instanceof CraftingManagerTileEntity && (craftingManager = (CraftingManagerTileEntity)te).canCraft(ingredient)) {
                    missingIngredientConsumer.accept(ingredient);
                    return true;
                }
                return false;
            })) continue;
            return null;
        }
        return Collections.emptyList();
    }

    public void requestCraft(BlockPos invPos, ItemStack requested, int amount, PlayerEntity player) {
        int rf = (Integer)StorageScannerConfiguration.rfPerRequest.get();
        if (amount >= 0) {
            rf /= 10;
        }
        if (amount == -1) {
            amount = requested.func_77976_d();
        }
        if (this.getStoredPower() < (long)rf) {
            return;
        }
        this.craftingSystem.requestCraft(requested, amount);
    }

    public void requestStack(BlockPos invPos, ItemStack requested, int amount, PlayerEntity player) {
        int rf = (Integer)StorageScannerConfiguration.rfPerRequest.get();
        if (amount >= 0) {
            rf /= 10;
        }
        if (amount == -1) {
            amount = requested.func_77976_d();
        }
        if (this.getStoredPower() < (long)rf) {
            return;
        }
        Integer[] todo = new Integer[]{amount};
        int finalAmount = amount;
        int finalRf = rf;
        ItemStack outSlot = this.items.getStackInSlot(1);
        if (!outSlot.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)outSlot, (ItemStack)requested)) {
                return;
            }
            if (outSlot.func_190916_E() >= requested.func_77976_d()) {
                return;
            }
            todo[0] = Math.min(todo[0], requested.func_77976_d() - outSlot.func_190916_E());
        }
        if (invPos.func_177956_o() == -1) {
            ServerPlayerEntity fakePlayer = this.lazyPlayer.get();
            Iterator iterator = this.inventories.stream().filter(p -> !(this.field_145850_b.func_175625_s(p) instanceof CraftingManagerTileEntity)).filter(arg_0 -> this.lambda$requestStack$52((PlayerEntity)fakePlayer, arg_0)).filter(p -> this.isOutputFromGui((BlockPos)p) && this.isRoutable((BlockPos)p)).iterator();
            while (iterator.hasNext()) {
                BlockPos blockPos = (BlockPos)iterator.next();
                outSlot = this.requestStackFromInv(blockPos, requested, todo, outSlot);
                if (todo[0] != 0) continue;
                break;
            }
        } else if (this.isOutputFromGui(invPos)) {
            outSlot = this.requestStackFromInv(invPos, requested, todo, outSlot);
        }
        if (todo[0] == finalAmount) {
            return;
        }
        this.consumeEnergy(finalRf);
        this.items.setStackInSlot(1, outSlot);
        if (((Boolean)StorageScannerConfiguration.requestStraightToInventory.get()).booleanValue() && player.field_71071_by.func_70441_a(outSlot)) {
            this.items.setStackInSlot(1, ItemStack.field_190927_a);
        }
    }

    private void addItemStack(List<ItemStack> stacks, Set<Item> foundItems, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        if (foundItems.contains(stack.func_77973_b())) {
            for (ItemStack s : stacks) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s.getStack(), (ItemStack)stack)) continue;
                s.getStack().func_190917_f(stack.func_190916_E());
                return;
            }
        }
        stacks.add(stack.func_77946_l());
        foundItems.add(stack.func_77973_b());
    }

    public void getInventoryForBlock(BlockPos cpos, List<ItemStack> stacks, List<ItemStack> craftable) {
        HashSet<Item> foundItems = new HashSet<Item>();
        this.lastSelectedInventory = cpos;
        if (cpos.func_177956_o() == -1) {
            for (BlockPos blockPos : this.inventories) {
                if (!this.routable.contains(blockPos)) continue;
                this.addItemsFromInventory(blockPos, foundItems, stacks, craftable);
            }
        } else {
            this.addItemsFromInventory(cpos, foundItems, stacks, craftable);
        }
    }

    private void addItemsFromInventory(BlockPos cpos, Set<Item> foundItems, List<ItemStack> stacks, List<ItemStack> craftable) {
        TileEntity tileEntity = this.field_145850_b.func_175625_s(cpos);
        if (tileEntity instanceof CraftingManagerTileEntity) {
            for (ItemStack stack : ((CraftingManagerTileEntity)tileEntity).getCraftables()) {
                this.addItemStack(craftable, foundItems, stack);
            }
        } else {
            StorageScannerTileEntity.getItemHandlerAt(tileEntity, null).ifPresent(h -> {
                for (int i = 0; i < h.getSlots(); ++i) {
                    this.addItemStack(stacks, foundItems, h.getStackInSlot(i));
                }
            });
        }
    }

    public SortingMode getSortMode() {
        return this.sortMode;
    }

    public void setSortMode(SortingMode sortMode) {
        this.sortMode = sortMode;
        this.func_70296_d();
    }

    public void load(CompoundNBT tagCompound) {
        BlockPos c;
        CompoundNBT tag;
        super.load(tagCompound);
        this.craftingSystem.read(tagCompound.func_74775_l("CS"));
        ListNBT list = tagCompound.func_150295_c("inventories", 10);
        this.inventories.clear();
        this.craftingInventories = null;
        for (INBT inbt : list) {
            tag = (CompoundNBT)inbt;
            c = BlockPosTools.read((CompoundNBT)tag, (String)"c");
            this.inventories.add(c);
        }
        list = tagCompound.func_150295_c("routable", 10);
        this.routable.clear();
        for (INBT inbt : list) {
            tag = (CompoundNBT)inbt;
            c = BlockPosTools.read((CompoundNBT)tag, (String)"c");
            this.routable.add(c);
        }
        list = tagCompound.func_150295_c("fromxnet", 10);
        this.inventoriesFromXNet.clear();
        for (INBT inbt : list) {
            tag = (CompoundNBT)inbt;
            c = BlockPosTools.read((CompoundNBT)tag, (String)"c");
            this.inventoriesFromXNet.add(c);
        }
    }

    protected void loadInfo(CompoundNBT tagCompound) {
        super.loadInfo(tagCompound);
        if (tagCompound.func_74764_b("Info")) {
            CompoundNBT infoTag = tagCompound.func_74775_l("Info");
            if (infoTag.func_74764_b("radius")) {
                this.radius = infoTag.func_74762_e("radius");
            }
            if (infoTag.func_74764_b("exportC")) {
                this.exportToCurrent = infoTag.func_74767_n("exportC");
            }
            if (infoTag.func_74764_b("wideview")) {
                this.openWideView = infoTag.func_74767_n("wideview");
            }
            if (infoTag.func_74764_b("grid")) {
                this.craftingGrid.readFromNBT(infoTag.func_74775_l("grid"));
            }
            if (infoTag.func_74764_b("sortMode")) {
                int m = infoTag.func_74762_e("sortMode");
                this.sortMode = SortingMode.values()[m];
            }
        } else {
            this.openWideView = true;
            this.sortMode = SortingMode.NAME;
        }
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        CompoundNBT tag;
        super.saveAdditional(tagCompound);
        tagCompound.func_218657_a("CS", (INBT)this.craftingSystem.write());
        ListNBT list = new ListNBT();
        for (BlockPos c : this.inventories) {
            tag = BlockPosTools.write((BlockPos)c);
            list.add((Object)tag);
        }
        tagCompound.func_218657_a("inventories", (INBT)list);
        list = new ListNBT();
        for (BlockPos c : this.routable) {
            tag = BlockPosTools.write((BlockPos)c);
            list.add((Object)tag);
        }
        tagCompound.func_218657_a("routable", (INBT)list);
        list = new ListNBT();
        for (BlockPos c : this.inventoriesFromXNet) {
            tag = BlockPosTools.write((BlockPos)c);
            list.add((Object)tag);
        }
        tagCompound.func_218657_a("fromxnet", (INBT)list);
    }

    protected void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT infoTag = this.getOrCreateInfo(tagCompound);
        infoTag.func_74768_a("radius", this.radius);
        infoTag.func_74757_a("exportC", this.exportToCurrent);
        infoTag.func_74757_a("wideview", this.openWideView);
        infoTag.func_218657_a("grid", (INBT)this.craftingGrid.writeToNBT());
        infoTag.func_74768_a("sortMode", this.sortMode.ordinal());
    }

    private void clearGrid() {
        CraftingGridInventory inventory = this.craftingGrid.getCraftingGridInventory();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        this.func_70296_d();
    }

    public boolean isDummy() {
        return this.dummyType != null;
    }

    public RegistryKey<World> getDimension() {
        if (this.dummyType != null) {
            return this.dummyType;
        }
        return super.getDimension();
    }

    public BlockPos getCraftingGridContainerPos() {
        return this.func_174877_v();
    }

    public CraftingGridProvider getCraftingGridProvider() {
        return this;
    }

    public BlockPos getStorageScannerPos() {
        return this.func_174877_v();
    }

    public CraftingSystem getCraftingSystem() {
        return this.craftingSystem;
    }

    @Nonnull
    private IInformationScreenInfo createScreenInfo() {
        return new StorageScannerInformationScreenInfo(this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityInformationScreenInfo.INFORMATION_SCREEN_INFO_CAPABILITY) {
            return this.infoScreenInfo.cast();
        }
        return super.getCapability(cap, facing);
    }

    private /* synthetic */ boolean lambda$requestStack$52(PlayerEntity fakePlayer, BlockPos p) {
        return this.canPlayerAccess(fakePlayer, p);
    }

    private /* synthetic */ boolean lambda$insertInternal$48(PlayerEntity fakePlayer, BlockPos p) {
        return this.canPlayerAccess(fakePlayer, p);
    }

    private /* synthetic */ boolean lambda$requestItem$43(PlayerEntity fakePlayer, BlockPos p) {
        return this.canPlayerAccess(fakePlayer, p);
    }

    private /* synthetic */ boolean lambda$requestItem$37(PlayerEntity fakePlayer, BlockPos p) {
        return this.canPlayerAccess(fakePlayer, p);
    }
}

