/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.client.GuiTools;
import mcjty.lib.container.BaseSlot;
import mcjty.lib.container.GhostOutputSlot;
import mcjty.lib.container.GhostSlot;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.GuiCraftingGrid;
import mcjty.rftoolsstorage.modules.modularstorage.ModularStorageConfiguration;
import mcjty.rftoolsstorage.modules.modularstorage.ModularStorageModule;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageContainer;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageTileEntity;
import mcjty.rftoolsstorage.setup.CommandHandler;
import mcjty.rftoolsstorage.setup.RFToolsStorageMessages;
import mcjty.rftoolsstorage.storage.modules.DefaultTypeModule;
import mcjty.rftoolsstorage.storage.modules.TypeModule;
import mcjty.rftoolsstorage.storage.sorters.ItemSorter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class GuiModularStorage
extends GenericGuiContainer<ModularStorageTileEntity, ModularStorageContainer> {
    public static final int STORAGE_WIDTH = 256;
    public static final String VIEW_LIST = "list";
    public static final String VIEW_COLUMNS = "columns";
    public static final String VIEW_ICONS = "icons";
    private TypeModule typeModule;
    private static final ResourceLocation iconLocationTop = new ResourceLocation("rftoolsstorage", "textures/gui/modularstoragetop.png");
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsstorage", "textures/gui/modularstorage.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftoolsbase", "textures/gui/guielements.png");
    private WidgetList itemList;
    private TextField filter;
    private ImageChoiceLabel viewMode;
    private ImageChoiceLabel sortMode;
    private ImageChoiceLabel groupMode;
    private Label amountLabel;
    private ToggleButton lockButton;
    private Button cycleButton;
    private Button compactButton;
    private Label warningLabel;
    private GuiCraftingGrid craftingGrid = new GuiCraftingGrid();

    public GuiModularStorage(ModularStorageTileEntity tileEntity, ModularStorageContainer container, PlayerInventory inventory) {
        super((GenericTileEntity)tileEntity, (Container)container, inventory, ((BaseBlock)ModularStorageModule.MODULAR_STORAGE.get()).getManualEntry());
        this.field_146999_f = 256;
        double height = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        this.field_147000_g = height > 510.0 ? (Integer)ModularStorageConfiguration.height3.get() : (height > 340.0 ? ((Integer)ModularStorageConfiguration.height2.get()).intValue() : ((Integer)ModularStorageConfiguration.height1.get()).intValue());
    }

    public static void register() {
        GuiModularStorage.register((ContainerType)((ContainerType)ModularStorageModule.CONTAINER_MODULAR_STORAGE.get()), GuiModularStorage::new);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.itemList = ((WidgetList)((WidgetList)Widgets.list((int)5, (int)3, (int)235, (int)(this.field_147000_g - 89)).name("items")).noSelectionMode(true).userObject((Object)new Integer(-1))).leftMargin(0).rowheight(-1);
        Slider slider = ((Slider)Widgets.slider((int)241, (int)3, (int)11, (int)(this.field_147000_g - 89)).desiredWidth(11)).vertical().scrollableName("items");
        this.warningLabel = Widgets.label((int)20, (int)20, (int)200, (int)20, (String)"Lock the storage to access the items!");
        this.lockButton = (ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().hint(5, this.field_147000_g - 23 - 18, 16, 16)).text("L")).name("lock")).event(this::updateSettings).tooltips(new String[]{"Lock/unlock the module slots"});
        this.cycleButton = (Button)((Button)((Button)Widgets.button((int)5, (int)(this.field_147000_g - 23), (int)16, (int)16, (String)"C").name("cycle")).channel("cycle")).tooltips(new String[]{"Cycle to the next storage module"});
        Panel modePanel = this.setupModePanel();
        Panel toplevel = (Panel)Widgets.positional().children(new Widget[]{this.itemList, slider, modePanel, this.lockButton, this.cycleButton, this.warningLabel});
        toplevel.setBackgrounds(iconLocationTop, iconLocation);
        toplevel.setBackgroundLayout(false, this.field_147000_g - (Integer)ModularStorageConfiguration.height1.get() + 2);
        if (this.tileEntity == null) {
            ImageLabel hideLabel = new ImageLabel();
            hideLabel.hint(4, this.field_147000_g - 26 - 54, 20, 55);
            hideLabel.image(guiElements, 32, 32);
            toplevel.children(new Widget[]{hideLabel});
        }
        toplevel.bounds(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.window.event("cycle", (source, params) -> this.cycleStorage());
        this.window.event("compact", (source, params) -> this.compact());
        if (((Boolean)ModularStorageConfiguration.autofocusSearch.get()).booleanValue()) {
            this.window.setTextFocus((Widget)this.filter);
        }
        CraftingGridProvider provider = null;
        BlockPos pos = null;
        if (this.tileEntity == null) {
            throw new RuntimeException("Should not happen!");
        }
        provider = (CraftingGridProvider)this.tileEntity;
        pos = ((ModularStorageTileEntity)this.tileEntity).func_174877_v();
        this.craftingGrid.initGui(RFToolsStorageMessages.INSTANCE, this.field_230706_i_, this, pos, (RegistryKey<World>)((ModularStorageTileEntity)this.tileEntity).getDimension(), provider, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.sendServerCommand(RFToolsStorageMessages.INSTANCE, "rftoolsstorage", "requestGridSync", TypedMap.builder().put(CommandHandler.PARAM_POS, (Object)pos).put(CommandHandler.PARAM_DIMENSION, (Object)((ModularStorageTileEntity)this.tileEntity).getDimension()).build());
    }

    protected void registerWindows(WindowManager mgr) {
        super.registerWindows(mgr);
        mgr.addWindow(this.craftingGrid.getWindow());
    }

    private Panel setupModePanel() {
        this.filter = ((TextField)Widgets.textfield((int)3, (int)3, (int)57, (int)13).tooltips(new String[]{"Name based filter for items"})).event(newText -> this.updateSettings());
        this.viewMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel().hint(4, 19, 16, 16)).tooltips(new String[]{"Control how items are shown", "in the view"})).event(newChoice -> this.updateSettings());
        this.viewMode.choice(VIEW_LIST, "Items are shown in a list view", guiElements, 144, 16);
        this.viewMode.choice(VIEW_COLUMNS, "Items are shown in columns", guiElements, 160, 16);
        this.viewMode.choice(VIEW_ICONS, "Items are shown with icons", guiElements, 176, 16);
        this.updateTypeModule();
        this.sortMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel().hint(23, 19, 16, 16)).tooltips(new String[]{"Control how items are sorted", "in the view"})).event(newChoice -> this.updateSettings());
        for (ItemSorter sorter : this.typeModule.getSorters()) {
            this.sortMode.choice(sorter.getName(), sorter.getTooltip(), guiElements, sorter.getU(), sorter.getV());
        }
        this.groupMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel().hint(42, 19, 16, 16)).tooltips(new String[]{"If enabled it will show groups", "based on sorting criterium"})).event(newChoice -> this.updateSettings());
        this.groupMode.choice("Off", "Don't show groups", guiElements, 208, 0);
        this.groupMode.choice("On", "Show groups", guiElements, 224, 0);
        this.amountLabel = (Label)((Label)Widgets.label((int)16, (int)40, (int)66, (int)12, (String)"?/?").horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).tooltips(new String[]{"Amount of stacks / maximum amount"});
        this.compactButton = (Button)((Button)((Button)Widgets.button((int)4, (int)39, (int)12, (int)12, (String)"z").name("compact")).channel("compact")).tooltips(new String[]{"Compact equal stacks"});
        if (this.tileEntity != null) {
            this.filter.text((Boolean)ModularStorageConfiguration.clearSearchOnOpen.get() != false ? "" : ((ModularStorageTileEntity)this.tileEntity).getFilter());
            this.setViewMode(((ModularStorageTileEntity)this.tileEntity).getViewMode());
            this.setSortMode(((ModularStorageTileEntity)this.tileEntity).getSortMode());
            this.groupMode.setCurrentChoice(((ModularStorageTileEntity)this.tileEntity).isGroupMode() ? 1 : 0);
            this.lockButton.pressed(((ModularStorageTileEntity)this.tileEntity).isLocked());
            this.warningLabel.visible(!((ModularStorageTileEntity)this.tileEntity).isLocked());
            this.itemList.visible(((ModularStorageTileEntity)this.tileEntity).isLocked());
        } else {
            ItemStack heldItem = this.field_230706_i_.field_71439_g.func_184586_b(Hand.MAIN_HAND);
            if (!heldItem.func_190926_b() && heldItem.func_77942_o()) {
                CompoundNBT tagCompound = heldItem.func_77978_p();
                this.filter.text((Boolean)ModularStorageConfiguration.clearSearchOnOpen.get() != false ? "" : tagCompound.func_74779_i("filter"));
                this.setViewMode(tagCompound.func_74779_i("viewMode"));
                this.setSortMode(tagCompound.func_74779_i("sortMode"));
                this.groupMode.setCurrentChoice(tagCompound.func_74767_n("groupMode") ? 1 : 0);
            }
        }
        return (Panel)((Panel)((Panel)((Panel)Widgets.positional().hint(24, this.field_147000_g - 80, 64, 77)).filledRectThickness(-2)).filledBackground(StyleConfig.colorListBackground)).children(new Widget[]{this.filter, this.viewMode, this.sortMode, this.groupMode, this.amountLabel, this.compactButton});
    }

    private void setSortMode(String sortMode) {
        int idx = this.sortMode.findChoice(sortMode);
        if (idx == -1) {
            this.sortMode.setCurrentChoice(0);
        } else {
            this.sortMode.setCurrentChoice(idx);
        }
    }

    private void setViewMode(String viewMode) {
        int idx = this.viewMode.findChoice(viewMode);
        if (idx == -1) {
            this.viewMode.setCurrentChoice(VIEW_LIST);
        } else {
            this.viewMode.setCurrentChoice(idx);
        }
    }

    private void cycleStorage() {
        if (this.tileEntity != null) {
            this.window.sendServerCommand(RFToolsStorageMessages.INSTANCE, ModularStorageTileEntity.CMD_CYCLE, TypedMap.EMPTY);
        } else {
            this.sendServerCommand(RFToolsStorageMessages.INSTANCE, "rftoolsstorage", "cycleStorage");
        }
    }

    private void compact() {
        if (this.tileEntity != null) {
            this.window.sendServerCommand(RFToolsStorageMessages.INSTANCE, ModularStorageTileEntity.CMD_COMPACT, TypedMap.EMPTY);
        } else {
            this.sendServerCommand(RFToolsStorageMessages.INSTANCE, "rftoolsstorage", "compact");
        }
    }

    private void updateSettings() {
        if (this.tileEntity != null) {
            ((ModularStorageTileEntity)this.tileEntity).setSortMode(this.sortMode.getCurrentChoice());
            ((ModularStorageTileEntity)this.tileEntity).setViewMode(this.viewMode.getCurrentChoice());
            ((ModularStorageTileEntity)this.tileEntity).setFilter(this.filter.getText());
            ((ModularStorageTileEntity)this.tileEntity).setGroupMode(this.groupMode.getCurrentChoiceIndex() == 1);
            ((ModularStorageTileEntity)this.tileEntity).setLocked(this.lockButton.isPressed());
            this.warningLabel.visible(!((ModularStorageTileEntity)this.tileEntity).isLocked());
            this.itemList.visible(((ModularStorageTileEntity)this.tileEntity).isLocked());
            this.sendServerCommandTyped(RFToolsStorageMessages.INSTANCE, ModularStorageTileEntity.CMD_SETTINGS, TypedMap.builder().put(ModularStorageTileEntity.PARAM_SORTMODE, (Object)this.sortMode.getCurrentChoice()).put(ModularStorageTileEntity.PARAM_VIEWMODE, (Object)this.viewMode.getCurrentChoice()).put(ModularStorageTileEntity.PARAM_FILTER, (Object)this.filter.getText()).put(ModularStorageTileEntity.PARAM_GROUPMODE, (Object)(this.groupMode.getCurrentChoiceIndex() == 1 ? 1 : 0)).put(ModularStorageTileEntity.PARAM_LOCKED, (Object)this.lockButton.isPressed()).build());
        }
    }

    private Slot findEmptySlot() {
        for (Object slotObject : ((ModularStorageContainer)this.field_147002_h).field_75151_b) {
            Slot slot = (Slot)slotObject;
            if (this.tileEntity != null && !(slot instanceof BaseSlot) || slot.func_75216_d() && slot.func_75211_c().func_190916_E() != 0) continue;
            return slot;
        }
        return null;
    }

    public boolean func_195362_a(@Nonnull Slot slotIn, double x, double y) {
        if (slotIn instanceof BaseSlot && ((BaseSlot)slotIn).getTe() instanceof ModularStorageTileEntity) {
            Widget widget = this.window.getToplevel().getWidgetAtPosition(x, y);
            if (widget instanceof BlockRender) {
                Object userObject = widget.getUserObject();
                if (userObject instanceof Integer) {
                    Integer slotIndex = (Integer)userObject;
                    return slotIndex == slotIn.field_75222_d;
                }
            } else {
                return super.func_195362_a(slotIn, x, y);
            }
            return false;
        }
        return super.func_195362_a(slotIn, x, y);
    }

    public Slot func_195360_a(double x, double y) {
        Object userObject;
        Widget widget = this.window.getToplevel().getWidgetAtPosition(x, y);
        if (widget != null && (userObject = widget.getUserObject()) instanceof Integer) {
            Integer slotIndex = (Integer)userObject;
            if (slotIndex != -1) {
                return ((ModularStorageContainer)this.field_147002_h).func_75139_a(slotIndex);
            }
            return this.findEmptySlot();
        }
        return super.func_195360_a(x, y);
    }

    private void dumpClasses(String name, Object o) {
        Logging.log((String)(name + ":" + o.getClass().getCanonicalName()));
        Class<?>[] classes = o.getClass().getClasses();
        for (Class<?> a : classes) {
            Logging.log((String)("        " + a.getCanonicalName()));
        }
        Logging.log((String)("        Super:" + o.getClass().getGenericSuperclass()));
        for (Type type : o.getClass().getGenericInterfaces()) {
            Logging.log((String)("        type:" + type.getClass().getCanonicalName()));
        }
    }

    public boolean func_231044_a_(double x, double y, int button) {
        Slot slot;
        boolean r = super.func_231044_a_(x, y, button);
        if (button == 1 && (slot = this.func_195360_a(x, y)) instanceof GhostOutputSlot) {
            if (this.tileEntity != null) {
                this.window.sendServerCommand(RFToolsStorageMessages.INSTANCE, ModularStorageTileEntity.CMD_CLEARGRID, TypedMap.EMPTY);
            } else {
                this.sendServerCommand(RFToolsStorageMessages.INSTANCE, "rftoolsstorage", "clearGrid");
            }
        }
        return r;
    }

    private void updateList() {
        int spacing;
        int labelWidth;
        int numcolumns;
        this.itemList.removeChildren();
        if (this.tileEntity != null && !((ModularStorageContainer)this.field_147002_h).func_75139_a(0).func_75216_d()) {
            this.amountLabel.text("(empty)");
            this.compactButton.enabled(false);
            this.cycleButton.enabled(false);
            return;
        }
        this.cycleButton.enabled(this.isTabletWithRemote() || this.isRemote());
        String filterText = this.filter.getText().toLowerCase().trim();
        String view = this.viewMode.getCurrentChoice();
        if (VIEW_LIST.equals(view)) {
            numcolumns = 1;
            labelWidth = 210;
            spacing = 5;
        } else if (VIEW_COLUMNS.equals(view)) {
            numcolumns = 2;
            labelWidth = 86;
            spacing = 5;
        } else {
            numcolumns = 12;
            labelWidth = 0;
            spacing = 3;
        }
        AtomicInteger max = new AtomicInteger();
        ArrayList items = new ArrayList();
        if (this.tileEntity != null) {
            ((ModularStorageTileEntity)this.tileEntity).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    String displayName = stack.func_200301_q().getString();
                    if (!filterText.isEmpty() && !displayName.toLowerCase().contains(filterText)) continue;
                    items.add(Pair.of((Object)stack, (Object)(i + 3)));
                }
                max.set(handler.getSlots());
            });
        }
        this.amountLabel.text(items.size() + "/" + max);
        this.compactButton.enabled(max.get() > 0);
        int sort = this.getCurrentSortMode();
        boolean dogroups = this.groupMode.getCurrentChoiceIndex() == 1;
        ItemSorter itemSorter = this.typeModule.getSorters().get(sort);
        Collections.sort(items, itemSorter.getComparator());
        Pair<Panel, Integer> currentPos = MutablePair.of(null, (Object)0);
        Pair prevItem = null;
        for (Pair item : items) {
            currentPos = this.addItemToList((ItemStack)item.getKey(), this.itemList, currentPos, numcolumns, labelWidth, spacing, (Integer)item.getValue(), dogroups && (prevItem == null || !itemSorter.isSameGroup(prevItem, (Pair<ItemStack, Integer>)item)), itemSorter.getGroupName((Pair<ItemStack, Integer>)item));
            prevItem = item;
        }
        int newfirst = -1;
        if (this.itemList.getCountSelected() == 0) {
            if (this.itemList.getBounds() != null) {
                this.itemList.setFirstSelected(0);
                newfirst = this.itemList.getChildCount() - this.itemList.getCountSelected();
                if (newfirst < 0) {
                    newfirst = 0;
                }
            }
        } else if (this.itemList.getFirstSelected() > this.itemList.getChildCount() - this.itemList.getCountSelected()) {
            newfirst = this.itemList.getChildCount() - this.itemList.getCountSelected();
        }
        if (newfirst >= 0) {
            this.itemList.setFirstSelected(newfirst);
        }
    }

    private boolean isRemote() {
        return false;
    }

    private boolean isTabletWithRemote() {
        if (this.tileEntity != null) {
            return false;
        }
        ItemStack heldItem = this.field_230706_i_.field_71439_g.func_184586_b(Hand.MAIN_HAND);
        if (!heldItem.func_190926_b() && heldItem.func_77942_o()) {
            int storageType = heldItem.func_77978_p().func_74762_e("childDamage");
            return storageType == 6;
        }
        return false;
    }

    private int getCurrentSortMode() {
        this.updateTypeModule();
        String sortName = this.sortMode.getCurrentChoice();
        this.sortMode.clear();
        for (ItemSorter sorter : this.typeModule.getSorters()) {
            this.sortMode.choice(sorter.getName(), sorter.getTooltip(), guiElements, sorter.getU(), sorter.getV());
        }
        int sort = this.sortMode.findChoice(sortName);
        if (sort == -1) {
            sort = 0;
        }
        this.sortMode.setCurrentChoice(sort);
        return sort;
    }

    private void updateTypeModule() {
        ItemStack typeStack;
        this.typeModule = this.tileEntity != null ? ((typeStack = ItemStack.field_190927_a).func_190926_b() || !(typeStack.func_77973_b() instanceof TypeModule) ? new DefaultTypeModule() : (TypeModule)typeStack.func_77973_b()) : new DefaultTypeModule();
    }

    private Pair<Panel, Integer> addItemToList(ItemStack stack, WidgetList itemList, Pair<Panel, Integer> currentPos, int numcolumns, int labelWidth, int spacing, int slot, boolean newgroup, String groupName) {
        Panel panel = (Panel)currentPos.getKey();
        if (panel == null || (Integer)currentPos.getValue() >= numcolumns || newgroup && groupName != null) {
            if (newgroup && groupName != null) {
                AbstractWidget groupLabel = ((Label)((Label)((Label)((Label)((Label)Widgets.label((String)groupName).color(((Integer)ModularStorageConfiguration.groupForeground.get()).intValue())).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).filledBackground(((Integer)ModularStorageConfiguration.groupBackground.get()).intValue())).desiredHeight(10)).desiredWidth(231);
                itemList.children(new Widget[]{((Panel)new Panel().layout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(2)).setVerticalMargin(0)).desiredHeight(10)).children(new Widget[]{groupLabel})});
            }
            panel = (Panel)((Panel)((Panel)Widgets.horizontal((int)5, (int)spacing).desiredHeight(12)).userObject((Object)-1)).desiredHeight(16);
            currentPos = MutablePair.of((Object)panel, (Object)0);
            itemList.children(new Widget[]{panel});
        }
        BlockRender blockRender = ((BlockRender)new BlockRender().renderItem((Object)stack).userObject((Object)slot)).offsetX(-1).offsetY(-1);
        panel.children(new Widget[]{blockRender});
        if (labelWidth > 0) {
            String displayName = labelWidth > 100 ? this.typeModule.getLongLabel(stack) : this.typeModule.getShortLabel(stack);
            AbstractWidget label = ((Label)((Label)((Label)Widgets.label((String)displayName).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(labelWidth)).userObject((Object)new Integer(-1));
            panel.children(new Widget[]{label});
        }
        currentPos.setValue((Object)((Integer)currentPos.getValue() + 1));
        return currentPos;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        boolean rc = false;
        if (!this.window.keyTyped(keyCode, scanCode)) {
            if (keyCode >= 49 && keyCode <= 57) {
                return true;
            }
            rc = super.func_231046_a_(keyCode, scanCode, modifiers);
        }
        return rc;
    }

    protected void func_230450_a_(@Nonnull MatrixStack matrixStack, float v, int i, int i2) {
        this.updateList();
        if (this.tileEntity != null) {
            this.viewMode.setCurrentChoice(((ModularStorageTileEntity)this.tileEntity).getViewMode());
            this.sortMode.setCurrentChoice(((ModularStorageTileEntity)this.tileEntity).getSortMode());
            this.groupMode.setCurrentChoice(((ModularStorageTileEntity)this.tileEntity).isGroupMode() ? 1 : 0);
            String curFilter = ((ModularStorageTileEntity)this.tileEntity).getFilter();
            if (!this.filter.getText().equals(curFilter)) {
                this.filter.text(curFilter);
            }
        }
        this.drawWindow(matrixStack);
    }

    protected void func_230459_a_(@Nonnull MatrixStack matrixStack, int x, int y) {
        Slot slot = this.func_195360_a(x, y);
        if (slot instanceof SlotItemHandler && !(slot instanceof BaseSlot) && !(slot instanceof GhostOutputSlot) && !(slot instanceof GhostSlot) && ((ModularStorageTileEntity)this.tileEntity).isLocked()) {
            this.func_238652_a_(matrixStack, (ITextComponent)new StringTextComponent("Unlock to access these slots").func_240699_a_(TextFormatting.RED), x, y);
            return;
        }
        super.func_230459_a_(matrixStack, x, y);
    }

    protected void drawStackTooltips(MatrixStack matrixStack, int mouseX, int mouseY) {
    }

    protected void func_230451_b_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        int x = GuiTools.getRelativeX((Screen)this);
        int y = GuiTools.getRelativeY((Screen)this);
        List tooltips = this.craftingGrid.getWindow().getTooltips();
        if (tooltips != null) {
            this.drawHoveringText(matrixStack, tooltips, this.window.getTooltipItems(), x - this.field_147003_i, y - this.field_147009_r, this.field_230706_i_.field_71466_p);
        }
        if (((ModularStorageTileEntity)this.tileEntity).isLocked()) {
            this.field_230706_i_.func_110434_K().func_110577_a(guiElements);
            int offset = 300;
            GuiModularStorage.func_238464_a_((MatrixStack)matrixStack, (int)5, (int)(this.field_147000_g - 79), (int)offset, (float)96.0f, (float)96.0f, (int)16, (int)16, (int)256, (int)256);
            GuiModularStorage.func_238464_a_((MatrixStack)matrixStack, (int)5, (int)(this.field_147000_g - 61), (int)offset, (float)96.0f, (float)96.0f, (int)16, (int)16, (int)256, (int)256);
        }
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.warningLabel.visible(!((ModularStorageTileEntity)this.tileEntity).isLocked());
        this.itemList.visible(((ModularStorageTileEntity)this.tileEntity).isLocked());
        this.lockButton.pressed(((ModularStorageTileEntity)this.tileEntity).isLocked());
    }

    protected void drawWindow(MatrixStack matrixStack) {
        super.drawWindow(matrixStack);
        this.craftingGrid.draw(matrixStack);
    }
}

