/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.compat;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.compat.theoneprobe.McJtyLibTOPDriver;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsstorage.modules.modularstorage.ModularStorageModule;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class RFToolsStorageTOPDriver
implements TOPDriver {
    public static final RFToolsStorageTOPDriver DRIVER = new RFToolsStorageTOPDriver();
    private final Map<ResourceLocation, TOPDriver> drivers = new HashMap<ResourceLocation, TOPDriver>();

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        TOPDriver driver;
        ResourceLocation id = blockState.func_177230_c().getRegistryName();
        if (!this.drivers.containsKey(id)) {
            if (blockState.func_177230_c() == ModularStorageModule.MODULAR_STORAGE.get()) {
                this.drivers.put(id, new ModularStorageDriver());
            } else {
                this.drivers.put(id, new DefaultDriver());
            }
        }
        if ((driver = this.drivers.get(id)) != null) {
            driver.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }

    private static class ModularStorageDriver
    implements TOPDriver {
        private ModularStorageDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_175625_s(data.getPos()), te -> {
                int maxSize = te.getMaxSize();
                if (maxSize == 0) {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.WARNING).text("No storage module!"));
                } else {
                    int stacks;
                    IItemHandler cardHandler = te.getCardHandler();
                    ItemStack storageModule = cardHandler.getStackInSlot(0);
                    if (!storageModule.func_190926_b() && storageModule.func_77978_p().func_74764_b("display")) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Module: ", (Object)storageModule.func_200301_q()));
                    }
                    if ((stacks = te.getNumStacks()) == -1) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Maximum size: ", (Object)maxSize));
                    } else {
                        probeInfo.text(CompoundText.create().style(TextStyleClass.INFO).text(stacks + " out of " + maxSize));
                    }
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class DefaultDriver
    implements TOPDriver {
        private DefaultDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }
}

