/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.network.packets;

import com.direwolf20.mininggadgets.common.containers.ModificationTableCommands;
import com.direwolf20.mininggadgets.common.containers.ModificationTableContainer;
import com.direwolf20.mininggadgets.common.tiles.ModificationTableTileEntity;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public final class PacketInsertUpgrade {
    private final BlockPos pos;
    private final ItemStack upgrade;

    public static PacketInsertUpgrade decode(PacketBuffer buffer) {
        return new PacketInsertUpgrade(buffer.func_179259_c(), buffer.func_150791_c());
    }

    public PacketInsertUpgrade(BlockPos blockPos, ItemStack stack) {
        this.pos = blockPos;
        this.upgrade = stack;
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.func_150788_a(this.upgrade);
    }

    public void handler(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            World world = player.field_70170_p;
            BlockPos pos = this.pos;
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof ModificationTableTileEntity)) {
                return;
            }
            ModificationTableContainer container = ((ModificationTableTileEntity)te).getContainer((PlayerEntity)player);
            ItemStack stack = player.field_71071_by.func_70445_o();
            if (!stack.func_77969_a(this.upgrade)) {
                return;
            }
            if (ModificationTableCommands.insertButton(container, this.upgrade)) {
                player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

